/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore;

import com.sun.jdo.api.persistence.support.JDODataStoreException;
import com.sun.jdo.api.persistence.support.JDOFatalInternalException;
import com.sun.jdo.spi.persistence.support.sqlstore.LogHelperSQLStore;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceManager;
import com.sun.jdo.spi.persistence.support.sqlstore.ResultFieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.SCODate;
import com.sun.jdo.spi.persistence.support.sqlstore.StateManager;
import com.sun.jdo.spi.persistence.support.sqlstore.model.ClassDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.FieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.ForeignFieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.LocalFieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.ColumnRef;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.SQLObjectInputStream;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ResourceBundle;

public class ResultDesc {
    private ArrayList fields = new ArrayList();
    private ArrayList fnames = new ArrayList();
    private ResultDesc superclassResultDesc;
    private ArrayList subclassResultDescs;
    private ClassDesc config;
    private ForeignFieldDesc parentField;
    private ResultFieldDesc verticalDiscriminator;
    private ResultFieldDesc horizontalDiscriminator;
    private boolean projection = false;
    private ResultFieldDesc fieldProjection = null;
    private static Logger logger = LogHelperSQLStore.getLogger();
    private static final ResourceBundle messages = I18NHelper.loadBundle(class$com$sun$jdo$spi$persistence$support$sqlstore$ResultDesc == null ? (class$com$sun$jdo$spi$persistence$support$sqlstore$ResultDesc = ResultDesc.class$("com.sun.jdo.spi.persistence.support.sqlstore.ResultDesc")) : class$com$sun$jdo$spi$persistence$support$sqlstore$ResultDesc);
    private boolean debug;
    static /* synthetic */ Class class$com$sun$jdo$spi$persistence$support$sqlstore$ResultDesc;

    public void addField(FieldDesc fieldDesc, ColumnRef columnRef) {
        this.addField(fieldDesc, columnRef, false);
    }

    public void addField(FieldDesc fieldDesc, ColumnRef columnRef, boolean bl) {
        ResultFieldDesc resultFieldDesc = new ResultFieldDesc(fieldDesc, columnRef);
        resultFieldDesc.setProjection(bl);
        if (bl) {
            this.projection = true;
            this.fieldProjection = resultFieldDesc;
        }
        this.fields.add(resultFieldDesc);
        this.fnames.add(fieldDesc.getName());
        if (fieldDesc.isVerticalDiscriminator()) {
            this.verticalDiscriminator = resultFieldDesc;
        }
        if (fieldDesc.isHorizontalDiscriminator()) {
            this.horizontalDiscriminator = resultFieldDesc;
        }
    }

    public void addField(ResultDesc resultDesc) {
        if (resultDesc != null) {
            this.fields.add(resultDesc);
            this.fnames.add(null);
        }
    }

    public void setSuperclassResultDesc(ResultDesc resultDesc) {
        this.superclassResultDesc = resultDesc;
        this.superclassResultDesc.addSubclassResultDesc(this);
    }

    public ResultDesc getSuperclassResultDesc() {
        return this.superclassResultDesc;
    }

    private void addSubclassResultDesc(ResultDesc resultDesc) {
        if (this.subclassResultDescs == null) {
            this.subclassResultDescs = new ArrayList();
        }
        this.subclassResultDescs.add(resultDesc);
    }

    public void copyFields(ResultDesc resultDesc) {
        ArrayList arrayList = resultDesc.getFields();
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            Object e = arrayList.get(n2);
            this.fields.add(e);
            if (e instanceof ResultFieldDesc) {
                this.fnames.add(((ResultFieldDesc)e).getFieldDesc().getName());
            } else {
                this.fnames.add(null);
            }
            ++n2;
        }
    }

    public ArrayList getFields() {
        return this.fields;
    }

    public void setParentField(ForeignFieldDesc foreignFieldDesc) {
        this.parentField = foreignFieldDesc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getSerializedObject(ResultSet resultSet, int n, FieldDesc fieldDesc) {
        Object object = null;
        if ((fieldDesc.sqlProperties & 0x80) > 0) {
            InputStream inputStream = null;
            try {
                inputStream = resultSet.getBinaryStream(n);
                if (inputStream != null) {
                    if (this.debug) {
                        logger.finest("sqlstore.resultdesc.deserializing", fieldDesc.getName());
                    }
                    SQLObjectInputStream sQLObjectInputStream = new SQLObjectInputStream(inputStream, fieldDesc.getType().getClassLoader());
                    object = sQLObjectInputStream.readObject();
                }
            }
            catch (Throwable throwable) {
                logger.log(900, "sqlstore.exception.log", throwable);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {
                        logger.log(500, "sqlstore.exception.log", exception);
                    }
                }
            }
        }
        return object;
    }

    private Object getConvertedObject(ResultSet resultSet, int n, FieldDesc fieldDesc, StateManager stateManager) {
        Object object;
        block27: {
            boolean bl;
            int n2;
            block26: {
                n2 = fieldDesc.getEnumType();
                object = null;
                bl = false;
                if ((fieldDesc.sqlProperties & 0x80) <= 0) break block26;
                object = this.getSerializedObject(resultSet, n, fieldDesc);
                bl = true;
                break block27;
            }
            try {
                switch (n2) {
                    case 1: 
                    case 11: {
                        boolean bl2 = resultSet.getBoolean(n);
                        if (!resultSet.wasNull()) {
                            object = new Boolean(bl2);
                        }
                        bl = true;
                        break;
                    }
                    case 3: 
                    case 13: {
                        byte by = resultSet.getByte(n);
                        if (!resultSet.wasNull()) {
                            object = new Byte(by);
                        }
                        bl = true;
                        break;
                    }
                    case 8: 
                    case 18: {
                        double d = resultSet.getDouble(n);
                        if (!resultSet.wasNull()) {
                            object = new Double(d);
                        }
                        bl = true;
                        break;
                    }
                    case 7: 
                    case 17: {
                        float f = resultSet.getFloat(n);
                        if (!resultSet.wasNull()) {
                            object = new Float(f);
                        }
                        bl = true;
                        break;
                    }
                    case 5: 
                    case 15: {
                        int n3 = resultSet.getInt(n);
                        if (!resultSet.wasNull()) {
                            object = new Integer(n3);
                        }
                        bl = true;
                        break;
                    }
                    case 6: 
                    case 16: {
                        long l = resultSet.getLong(n);
                        if (!resultSet.wasNull()) {
                            object = new Long(l);
                        }
                        bl = true;
                        break;
                    }
                    case 4: 
                    case 14: {
                        short s = resultSet.getShort(n);
                        if (!resultSet.wasNull()) {
                            object = new Short(s);
                        }
                        bl = true;
                        break;
                    }
                    case 21: {
                        object = resultSet.getString(n);
                        bl = true;
                        break;
                    }
                    case 2: 
                    case 12: {
                        String string = resultSet.getString(n);
                        if (string != null) {
                            object = FieldDesc.getCharFromString(string);
                        }
                        bl = true;
                        break;
                    }
                    case 19: 
                    case 20: {
                        object = resultSet.getBigDecimal(n);
                        if (n2 == 20 && object != null) {
                            object = ((BigDecimal)object).toBigInteger();
                        }
                        bl = true;
                        break;
                    }
                    case 51: {
                        InputStream inputStream = resultSet.getBinaryStream(n);
                        object = this.readInputStreamToByteArray(inputStream);
                        bl = true;
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (bl) break block27;
            try {
                object = fieldDesc.convertValue(resultSet.getObject(n), stateManager);
            }
            catch (SQLException sQLException) {
                logger.log(900, "sqlstore.exception.log", sQLException);
            }
        }
        return object;
    }

    private byte[] readInputStreamToByteArray(InputStream inputStream) throws IOException {
        byte[] byArray = null;
        if (inputStream != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray2 = new byte[2000];
            int n = 0;
            try {
                while ((n = inputStream.read(byArray2)) != -1) {
                    byteArrayOutputStream.write(byArray2, 0, n);
                }
                byArray = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                logger.log(900, "sqlstore.exception.log", iOException);
                throw iOException;
            }
        }
        return byArray;
    }

    private Object getObject(ResultSet resultSet, int n, FieldDesc fieldDesc) {
        Object object = null;
        if ((fieldDesc.sqlProperties & 0x80) > 0) {
            object = this.getSerializedObject(resultSet, n, fieldDesc);
        } else {
            try {
                object = resultSet.getObject(n);
            }
            catch (SQLException sQLException) {
                logger.log(900, "sqlstore.exception.log", sQLException);
            }
        }
        return object;
    }

    private ResultDesc getDiscriminatingSubclassResultDesc(ResultSet resultSet) {
        int n = this.subclassResultDescs.size();
        int n2 = 0;
        while (n2 < n) {
            ResultDesc resultDesc = (ResultDesc)this.subclassResultDescs.get(n2);
            ResultDesc resultDesc2 = null;
            ResultFieldDesc resultFieldDesc = resultDesc.horizontalDiscriminator;
            ResultFieldDesc resultFieldDesc2 = resultDesc.verticalDiscriminator;
            int n3 = -1;
            int n4 = -1;
            if (resultFieldDesc2 != null) {
                n4 = this.getObject(resultSet, resultFieldDesc2.getColumnRef().getIndex(), resultFieldDesc2.getFieldDesc()) == null ? 0 : 1;
            }
            if (resultFieldDesc != null) {
                LocalFieldDesc localFieldDesc = (LocalFieldDesc)resultFieldDesc.getFieldDesc();
                Object object = localFieldDesc.getDiscriminatorValue();
                Object object2 = this.getObject(resultSet, resultFieldDesc.getColumnRef().getIndex(), localFieldDesc);
                if (this.debug) {
                    Object[] objectArray = new Object[]{object, object2};
                    logger.finest("sqlstore.resultdesc.dvalue", objectArray);
                }
                n3 = object2 != null && object != null && object.toString().compareTo(object2.toString()) == 0 || object2 == null && object == null ? 1 : 0;
            }
            if (n3 == -1 && n4 == -1) {
                throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "sqlstore.resultdesc.nodiscriminators"));
            }
            if (n3 == 1) {
                if (n4 != 0) {
                    return resultDesc;
                }
                throw new JDODataStoreException(I18NHelper.getMessage(messages, "sqlstore.resultdesc.inconsistentmatch"));
            }
            if (n4 != 0) {
                if (resultDesc.subclassResultDescs != null && (resultDesc2 = resultDesc.getDiscriminatingResultDesc(resultSet)) != null) {
                    return resultDesc2;
                }
                if (n4 == 1 && n3 != 0) {
                    return resultDesc;
                }
            }
            ++n2;
        }
        return null;
    }

    private ResultDesc getDiscriminatingResultDesc(ResultSet resultSet) {
        ResultDesc resultDesc = null;
        if (this.horizontalDiscriminator != null) {
            LocalFieldDesc localFieldDesc = (LocalFieldDesc)this.horizontalDiscriminator.getFieldDesc();
            Object object = localFieldDesc.getDiscriminatorValue();
            Object object2 = this.getObject(resultSet, this.horizontalDiscriminator.getColumnRef().getIndex(), localFieldDesc);
            if (this.debug) {
                Object[] objectArray = new Object[]{object, object2};
                logger.finest("sqlstore.resultdesc.dvalue", objectArray);
            }
            if (object2 != null && object != null && object.toString().compareTo(object2.toString()) == 0 || object2 == null && object == null) {
                resultDesc = this;
            } else if (this.subclassResultDescs != null) {
                resultDesc = this.getDiscriminatingSubclassResultDesc(resultSet);
            }
        } else {
            if (this.subclassResultDescs != null) {
                resultDesc = this.getDiscriminatingSubclassResultDesc(resultSet);
            }
            if (resultDesc == null) {
                resultDesc = this;
            }
        }
        return resultDesc;
    }

    public void getResult(PersistenceManager persistenceManager, Collection collection, ResultSet resultSet, int n) throws SQLException {
        this.debug = logger.isLoggable(300);
        int n2 = 0;
        while (n2 < n && resultSet.next()) {
            ResultDesc resultDesc = this.getDiscriminatingResultDesc(resultSet);
            if (resultDesc == null) continue;
            collection.add(resultDesc.setFields(persistenceManager, resultSet, null, null));
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object setFields(PersistenceManager persistenceManager, ResultSet resultSet, Object object, StateManager stateManager) {
        Object object2;
        Object object3 = null;
        ArrayList<ResultDesc> arrayList = new ArrayList<ResultDesc>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        ArrayList<StateManager> arrayList3 = new ArrayList<StateManager>();
        ArrayList<Boolean> arrayList4 = new ArrayList<Boolean>();
        ArrayList<Integer> arrayList5 = new ArrayList<Integer>();
        ArrayList<FieldDesc> arrayList6 = new ArrayList<FieldDesc>();
        ArrayList<StateManager> arrayList7 = new ArrayList<StateManager>();
        Object object4 = this;
        Object object5 = object;
        StateManager stateManager2 = stateManager;
        StateManager stateManager3 = null;
        Boolean bl = Boolean.FALSE;
        Integer n = new Integer(0);
        FieldDesc fieldDesc = null;
        try {
            if (stateManager2 != null) {
                stateManager2.getLock();
            }
            while (object4 != null) {
                int n2;
                Object object6;
                Object object7;
                int n3;
                if (((ResultDesc)object4).fieldProjection != null && !persistenceManager.isOptimisticTransaction()) {
                    ResultFieldDesc resultFieldDesc = ((ResultDesc)object4).fieldProjection;
                    FieldDesc fieldDesc2 = resultFieldDesc.getFieldDesc();
                    if (this.debug) {
                        logger.finest("sqlstore.resultdesc.returning_field", fieldDesc2.getName());
                    }
                    n3 = resultFieldDesc.getColumnRef().getIndex();
                    object3 = this.getConvertedObject(resultSet, n3, fieldDesc2, null);
                    break;
                }
                if (object5 == null) {
                    stateManager2 = this.findOrCreateStateManager((ResultDesc)object4, resultSet, persistenceManager);
                    if (stateManager2 == null) {
                        bl = Boolean.TRUE;
                    } else {
                        object5 = stateManager2.getPersistent();
                        stateManager2.getLock();
                    }
                }
                if (((ResultDesc)object4).getSuperclassResultDesc() != null && (object7 = ((ResultDesc)object4).getSuperclassResultDesc().setFields(persistenceManager, resultSet, object5, stateManager2)) != object) {
                    object5 = object7;
                    if (stateManager2 != null) {
                        stateManager2.releaseLock();
                    }
                    stateManager2 = persistenceManager.getStateManager(object5);
                    stateManager2.getLock();
                }
                if (((ResultDesc)object4).fieldProjection != null) {
                    ResultFieldDesc resultFieldDesc = ((ResultDesc)object4).fieldProjection;
                    FieldDesc fieldDesc3 = resultFieldDesc.getFieldDesc();
                    if (stateManager2.getPresenceMaskBit(fieldDesc3.absoluteID)) {
                        object3 = fieldDesc3.getValue(stateManager2);
                        if (object3 instanceof SCODate) {
                            object3 = fieldDesc3.convertValue(object3, null);
                        }
                    } else {
                        n3 = resultFieldDesc.getColumnRef().getIndex();
                        object3 = this.getConvertedObject(resultSet, n3, fieldDesc3, null);
                    }
                    if (!this.debug) break;
                    logger.finest("sqlstore.resultdesc.returning_field", fieldDesc3.getName());
                    break;
                }
                int n4 = ((ResultDesc)object4).getFields().size();
                int n5 = n;
                n3 = n5 >= n4 ? 1 : 0;
                int n6 = n5;
                while (n6 < n4) {
                    Object object8;
                    Object object9;
                    object6 = ((ResultDesc)object4).getFields().get(n6);
                    if (!(object6 instanceof ResultFieldDesc)) {
                        object9 = (ResultDesc)object6;
                        object8 = ((ResultDesc)object9).getDiscriminatingResultDesc(resultSet);
                        if (object8 == null) {
                            object8 = object9;
                        } else {
                            ((ResultDesc)object8).setProjection(((ResultDesc)object9).isProjection());
                            ((ResultDesc)object8).setClassDesc(((ResultDesc)object9).getClassDesc());
                        }
                        arrayList.add((ResultDesc)object4);
                        arrayList2.add(object5);
                        arrayList3.add(stateManager2);
                        arrayList4.add(bl);
                        arrayList5.add(new Integer(n6 + 1));
                        arrayList6.add(fieldDesc);
                        arrayList7.add(stateManager3);
                        object4 = object8;
                        object5 = null;
                        stateManager3 = stateManager2;
                        if (stateManager2 != null) {
                            stateManager2.releaseLock();
                        }
                        stateManager2 = null;
                        bl = Boolean.FALSE;
                        n = new Integer(0);
                        fieldDesc = ((ResultDesc)object9).parentField;
                        break;
                    }
                    int n7 = n3 = n4 == n6 + 1 ? 1 : 0;
                    if (!bl.booleanValue()) {
                        object9 = (ResultFieldDesc)object6;
                        object8 = ((ResultFieldDesc)object9).getFieldDesc();
                        if (!stateManager2.getPresenceMaskBit(((FieldDesc)object8).absoluteID)) {
                            int n8 = ((ResultFieldDesc)object9).getColumnRef().getIndex();
                            Object object10 = this.getConvertedObject(resultSet, n8, (FieldDesc)object8, stateManager2);
                            ((FieldDesc)object8).setValue(stateManager2, object10);
                            if (this.debug) {
                                logger.finest("sqlstore.resultdesc.marking_field", ((FieldDesc)object8).getName());
                            }
                            stateManager2.setPresenceMaskBit(((FieldDesc)object8).absoluteID);
                        }
                    }
                    ++n6;
                }
                if (n3 == 0) continue;
                if (!bl.booleanValue()) {
                    stateManager2.initialize(true);
                    object3 = object5;
                }
                if (((ResultDesc)object4).isProjection()) {
                    object6 = object3;
                    Object var30_36 = null;
                    if (stateManager2 == null) return object6;
                    stateManager2.releaseLock();
                    return object6;
                }
                if (fieldDesc != null) {
                    fieldDesc.setValue(stateManager3, object3);
                    if (this.debug) {
                        logger.finest("sqlstore.resultdesc.marking_foreign_field", fieldDesc.getName());
                    }
                    stateManager3.setPresenceMaskBit(((ForeignFieldDesc)fieldDesc).absoluteID);
                }
                if ((n2 = arrayList.size() - 1) >= 0) {
                    object4 = (ResultDesc)arrayList.remove(n2);
                    object5 = arrayList2.remove(n2);
                    if (stateManager2 != null) {
                        stateManager2.releaseLock();
                    }
                    if ((stateManager2 = (StateManager)arrayList3.remove(n2)) != null) {
                        stateManager2.getLock();
                    }
                    bl = (Boolean)arrayList4.remove(n2);
                    n = (Integer)arrayList5.remove(n2);
                    fieldDesc = (ForeignFieldDesc)arrayList6.remove(n2);
                    stateManager3 = (StateManager)arrayList7.remove(n2);
                    continue;
                }
                object4 = null;
            }
            object2 = object3;
        }
        catch (Throwable throwable) {
            Object var30_38 = null;
            if (stateManager2 == null) throw throwable;
            stateManager2.releaseLock();
            throw throwable;
        }
        Object var30_37 = null;
        if (stateManager2 == null) return object2;
        stateManager2.releaseLock();
        return object2;
    }

    public boolean isProjection() {
        return this.projection;
    }

    public void setProjection(boolean bl) {
        this.projection = bl;
    }

    public void setClassDesc(ClassDesc classDesc) {
        this.config = classDesc;
    }

    public ClassDesc getClassDesc() {
        return this.config;
    }

    private StateManager findOrCreateStateManager(ResultDesc resultDesc, ResultSet resultSet, PersistenceManager persistenceManager) {
        try {
            Class clazz = resultDesc.config.getOidClass();
            Object t = clazz.newInstance();
            Field[] fieldArray = resultDesc.config.getKeyFields();
            String[] stringArray = resultDesc.config.getKeyFieldNames();
            int n = 0;
            while (n < fieldArray.length) {
                Field field = fieldArray[n];
                String string = stringArray[n];
                FieldDesc fieldDesc = resultDesc.config.getField(string);
                int n2 = resultDesc.fnames.indexOf(string);
                ResultFieldDesc resultFieldDesc = (ResultFieldDesc)resultDesc.getFields().get(n2);
                int n3 = resultFieldDesc.getColumnRef().getIndex();
                Object object = this.getConvertedObject(resultSet, n3, fieldDesc, null);
                if (this.debug) {
                    logger.finest("sqlstore.resultdesc.marking_key_field", string);
                }
                if (object == null) {
                    return null;
                }
                field.set(t, object);
                ++n;
            }
            return persistenceManager.findOrCreateStateManager(t, resultDesc.config.getPersistenceCapableClass());
        }
        catch (Exception exception) {
            throw new JDOFatalInternalException(exception.getMessage());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

