/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.generator;

import com.sun.jdo.api.persistence.enhancer.meta.ExtendedJDOMetaData;
import com.sun.jdo.api.persistence.enhancer.util.Assertion;
import com.sun.jdo.spi.persistence.utility.JavaTypeHelper;
import com.sun.jdo.spi.persistence.utility.generator.JavaClassWriterHelper;
import java.util.ArrayList;
import java.util.HashMap;

final class ImplHelper
extends Assertion {
    static final String[] COMMENT_ENHANCER_ADDED = null;
    static final String[] COMMENT_NOT_ENHANCER_ADDED = null;
    static final String CLASSNAME_JDO_PERSISTENCE_CAPABLE = "com.sun.jdo.spi.persistence.support.sqlstore.PersistenceCapable";
    static final String CLASSNAME_JDO_PERSISTENCE_MANAGER = "com.sun.jdo.api.persistence.support.PersistenceManager";
    static final String CLASSNAME_JDO_STATE_MANAGER = "com.sun.jdo.spi.persistence.support.sqlstore.StateManager";
    static final String CLASSNAME_JDO_SCO = "com.sun.jdo.spi.persistence.support.sqlstore.SCO";
    static final String CLASSNAME_JDO_FATAL_EXCEPTION = "com.sun.jdo.api.persistence.support.JDOFatalException";
    static final String FIELDNAME_JDO_FLAGS = "jdoFlags";
    static final String FIELDNAME_JDO_STATE_MANAGER = "jdoStateManager";
    static final String FIELDNAME_JDO_INHERITED_FIELD_COUNT = "jdoInheritedFieldCount";
    static final String FIELDNAME_JDO_FIELD_NAMES = "jdoFieldNames";
    static final String FIELDNAME_JDO_FIELD_TYPES = "jdoFieldTypes";
    static final String FIELDNAME_JDO_FIELD_FLAGS = "jdoFieldFlags";
    static final String METHODNAME_JDO_NEW_INSTANCE = "jdoNewInstance";
    static final String METHODNAME_JDO_SET_FIELD = "jdoSetField";
    static final String METHODNAME_JDO_GET_FIELD = "jdoGetField";
    static final String METHODNAME_JDO_GET_STATE_MANAGER = "jdoGetStateManager";
    static final String METHODNAME_JDO_SET_STATE_MANAGER = "jdoSetStateManager";
    static final String METHODNAME_JDO_GET_FLAGS = "jdoGetFlags";
    static final String METHODNAME_JDO_SET_FLAGS = "jdoSetFlags";
    static final String METHODNAME_JDO_GET_PERSISTENCE_MANAGER = "jdoGetPersistenceManager";
    static final String METHODNAME_JDO_CLEAR = "jdoClear";
    static final String METHODNAME_JDO_MAKE_DIRTY = "jdoMakeDirty";
    static final String METHODNAME_JDO_GET_OBJECT_ID = "jdoGetObjectId";
    static final String METHODNAME_JDO_IS_PERSISTENT = "jdoIsPersistent";
    static final String METHODNAME_JDO_IS_TRANSACTIONAL = "jdoIsTransactional";
    static final String METHODNAME_JDO_IS_NEW = "jdoIsNew";
    static final String METHODNAME_JDO_IS_DIRTY = "jdoIsDirty";
    static final String METHODNAME_JDO_IS_DELETED = "jdoIsDeleted";
    private static final HashMap typeNameConversion = new HashMap();

    ImplHelper() {
    }

    private static boolean isPrimitiveClass(String string) {
        Assertion.affirm(!string.equals("void"));
        return JavaTypeHelper.getWrapperName(string) != null;
    }

    private static String getConvertedTypeName(String string) {
        String string2 = (String)typeNameConversion.get(string);
        return string2 != null ? string2 : "Object";
    }

    private static String getMethodNameGetField(String string) {
        return "get" + ImplHelper.getConvertedTypeName(string) + "Field";
    }

    private static String getMethodNameSetField(String string) {
        return "set" + ImplHelper.getConvertedTypeName(string) + "Field";
    }

    static String[] getJDOManagedFieldCountImpl(int n) {
        return new String[]{"jdoInheritedFieldCount + " + n + ";"};
    }

    static String[] getDefaultConstructorImpl() {
        return JavaClassWriterHelper.super_;
    }

    static String[] getCloneImpl(String string) {
        string = ImplHelper.normalizeClassName(string);
        String[] stringArray = new String[4];
        int n = 0;
        stringArray[n++] = string + " clone = (" + string + ")super.clone();";
        stringArray[n++] = "clone.jdoFlags = (byte)0;";
        stringArray[n++] = "clone.jdoStateManager = null;";
        stringArray[n++] = "return clone;";
        return stringArray;
    }

    static String[] getJDOConstructorSMImpl(String string) {
        String[] stringArray = new String[2];
        int n = 0;
        stringArray[n++] = "jdoFlags = (byte)1; // == LOAD_REQUIRED";
        stringArray[n++] = "this.jdoStateManager = " + string + ";";
        return stringArray;
    }

    static String[] getJDONewInstanceImpl(String string, String string2) {
        string = ImplHelper.getClassName(string);
        return new String[]{"return new " + string + "(" + string2 + ");"};
    }

    static String[] getFieldDirectReadImpl(String string, String string2, int n) {
        string2 = ImplHelper.normalizeClassName(string2);
        return new String[]{"// annotation: grant direct read access", "return " + string + ";"};
    }

    static String[] getFieldMediateReadImpl(String string, String string2, int n) {
        string2 = ImplHelper.normalizeClassName(string2);
        String[] stringArray = new String[6];
        int n2 = 0;
        stringArray[n2++] = "// annotation: mediate read access";
        stringArray[n2++] = "final " + CLASSNAME_JDO_STATE_MANAGER + " stateManager = this." + FIELDNAME_JDO_STATE_MANAGER + ";";
        stringArray[n2++] = "if (stateManager != null) {";
        stringArray[n2++] = "    " + "stateManager.prepareGetField(" + n + ");";
        stringArray[n2++] = "}";
        stringArray[n2++] = "return " + string + ";";
        return stringArray;
    }

    static String[] getFieldCheckReadImpl(String string, String string2, int n) {
        String[] stringArray = new String[5];
        int n2 = 0;
        string2 = ImplHelper.normalizeClassName(string2);
        stringArray[n2++] = "// annotation: check read access";
        stringArray[n2++] = "if (" + FIELDNAME_JDO_FLAGS + " > 0) {";
        stringArray[n2++] = "   jdoStateManager.loadForRead();";
        stringArray[n2++] = "}";
        stringArray[n2++] = "return " + string + ";";
        return stringArray;
    }

    static String[] getFieldDirectWriteImpl(String string, String string2, int n, String string3) {
        string2 = ImplHelper.normalizeClassName(string2);
        return new String[]{"// annotation: grant direct write access", "this." + string + " = " + string3 + ";"};
    }

    static String[] getFieldMediateWriteImpl(String string, String string2, int n, String string3) {
        String[] stringArray = new String[7];
        int n2 = 0;
        string2 = ImplHelper.normalizeClassName(string2);
        stringArray[n2++] = "// annotation: mediate write access";
        stringArray[n2++] = "final " + CLASSNAME_JDO_STATE_MANAGER + " stateManager = this." + FIELDNAME_JDO_STATE_MANAGER + ";";
        stringArray[n2++] = "if (stateManager == null) {";
        stringArray[n2++] = "    this." + string + " = " + string3 + ";";
        stringArray[n2++] = "} else {";
        stringArray[n2++] = "    stateManager." + ImplHelper.getMethodNameSetField(string2) + '(' + n + ", " + string3 + ");";
        stringArray[n2++] = "}";
        return stringArray;
    }

    static String[] getFieldCheckWriteImpl(String string, String string2, int n, String string3) {
        String[] stringArray = new String[5];
        int n2 = 0;
        string2 = ImplHelper.normalizeClassName(string2);
        stringArray[n2++] = "// annotation: check write access";
        stringArray[n2++] = "if (jdoFlags != 0) {";
        stringArray[n2++] = "    jdoStateManager.loadForUpdate();";
        stringArray[n2++] = "}";
        stringArray[n2++] = "this." + string + " = " + string3 + ";";
        return stringArray;
    }

    static String[] getJDOClearImpl(String string, ExtendedJDOMetaData extendedJDOMetaData, String[] stringArray, String[] stringArray2) {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>(20);
        int n = 0;
        while (n < stringArray.length) {
            object = stringArray2[n];
            String string2 = ImplHelper.normalizeClassName(stringArray2[n]);
            String string3 = stringArray[n];
            if (!extendedJDOMetaData.isKeyField(string, string3)) {
                String string4 = JavaTypeHelper.getWrapperName(string2);
                if (extendedJDOMetaData.isMutableSecondClassObjectType((String)object)) {
                    arrayList.add("if (" + string3 + " instanceof " + CLASSNAME_JDO_SCO + ") {");
                    arrayList.add("    ((" + CLASSNAME_JDO_SCO + ")" + string3 + ").unsetOwner();");
                    arrayList.add("}");
                    arrayList.add(string3 + " = null;");
                } else if (string4 == null) {
                    arrayList.add(string3 + " = null;");
                } else if ("boolean".equals(string2)) {
                    arrayList.add(string3 + " = false;");
                } else {
                    arrayList.add(string3 + " = 0;");
                }
            }
            ++n;
        }
        object = new String[arrayList.size()];
        return arrayList.toArray((T[])object);
    }

    static String[] getJDOGetFieldImpl(String string, String[] stringArray, String[] stringArray2) {
        String[] stringArray3;
        ArrayList<String> arrayList = new ArrayList<String>(20);
        arrayList.add("switch (" + string + ") {");
        int n = 0;
        while (n < stringArray.length) {
            stringArray3 = ImplHelper.normalizeClassName(stringArray2[n]);
            arrayList.add("case " + n + ':');
            String string2 = JavaTypeHelper.getWrapperName((String)stringArray3);
            if (string2 == null) {
                arrayList.add("    return " + stringArray[n] + ";");
            } else {
                arrayList.add("    return new " + string2 + "(" + stringArray[n] + ");");
            }
            ++n;
        }
        arrayList.add("default:");
        arrayList.add("    throw new com.sun.jdo.api.persistence.support.JDOFatalException();");
        arrayList.add("}");
        stringArray3 = new String[arrayList.size()];
        return arrayList.toArray(stringArray3);
    }

    static String[] getJDOSetFieldImpl(String string, String string2, String[] stringArray, String[] stringArray2) {
        String[] stringArray3;
        ArrayList<String> arrayList = new ArrayList<String>(20);
        arrayList.add("switch (" + string + ") {");
        int n = 0;
        while (n < stringArray.length) {
            stringArray3 = ImplHelper.normalizeClassName(stringArray2[n]);
            arrayList.add("case " + n + ':');
            String string3 = JavaTypeHelper.getWrapperName((String)stringArray3);
            if (string3 == null) {
                arrayList.add("    this." + stringArray[n] + " = (" + (String)stringArray3 + ")" + string2 + ";");
            } else {
                arrayList.add("    this." + stringArray[n] + " = ((" + string3 + ")" + string2 + ")." + ((String)typeNameConversion.get(stringArray3)).toLowerCase() + "Value();");
            }
            arrayList.add("    return;");
            ++n;
        }
        arrayList.add("default:");
        arrayList.add("    throw new com.sun.jdo.api.persistence.support.JDOFatalException();");
        arrayList.add("}");
        stringArray3 = new String[arrayList.size()];
        return arrayList.toArray(stringArray3);
    }

    private static String[] getJDOStateManagerDelegationImpl(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>(7);
        arrayList.add("final " + CLASSNAME_JDO_STATE_MANAGER + " stateManager = this." + FIELDNAME_JDO_STATE_MANAGER + ";");
        arrayList.add("if (stateManager != null) {");
        StringBuffer stringBuffer = new StringBuffer("    ");
        if (string2 != null) {
            stringBuffer.append("return ");
        }
        arrayList.add(stringBuffer.append("stateManager.").append(string).append(";").toString());
        arrayList.add("}");
        if (string2 != null) {
            arrayList.add("return " + string2 + ";");
        }
        String[] stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }

    static String[] getJDOStateManagerVoidDelegationImpl(String string) {
        return ImplHelper.getJDOStateManagerDelegationImpl(string, null);
    }

    static String[] getJDOStateManagerObjectDelegationImpl(String string) {
        return ImplHelper.getJDOStateManagerDelegationImpl(string, "null");
    }

    static String[] getJDOStateManagerBooleanDelegationImpl(String string) {
        return ImplHelper.getJDOStateManagerDelegationImpl(string, "false");
    }

    static String[] getOidHashCodeImpl(String[] stringArray, String[] stringArray2, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>(3);
        if (bl) {
            arrayList.add("int hash = 0;");
        } else {
            arrayList.add("int hash = super.hashCode();");
        }
        int n = 0;
        while (n < stringArray.length) {
            if (ImplHelper.isPrimitiveClass(stringArray2[n])) {
                if (stringArray2[n].equals("boolean")) {
                    arrayList.add("hash += (" + stringArray[n] + " ? 1 : 0);");
                } else {
                    arrayList.add("hash += (int)" + stringArray[n] + ";");
                }
            } else {
                arrayList.add("hash += (this." + stringArray[n] + " != null ? this." + stringArray[n] + ".hashCode() : 0);");
            }
            ++n;
        }
        arrayList.add("return hash;");
        String[] stringArray3 = new String[arrayList.size()];
        return arrayList.toArray(stringArray3);
    }

    static String[] getOidEqualsImpl(String string, String[] stringArray, String[] stringArray2, String string2, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>(31);
        if (bl) {
            arrayList.add("if (" + string2 + " == null || !this.getClass().equals(" + string2 + ".getClass())) {");
        } else {
            arrayList.add("if (!super.equals(" + string2 + ")) {");
        }
        arrayList.add("    return false;");
        arrayList.add("}");
        string = ImplHelper.getClassName(string);
        arrayList.add(string + " oid = (" + string + ")" + string2 + ";");
        int n = 0;
        while (n < stringArray.length) {
            if (ImplHelper.isPrimitiveClass(stringArray2[n])) {
                arrayList.add("if (this." + stringArray[n] + " != oid." + stringArray[n] + ") return false;");
            } else {
                arrayList.add("if (this." + stringArray[n] + " != oid." + stringArray[n] + " && (this." + stringArray[n] + " == null || " + "!this." + stringArray[n] + ".equals(oid." + stringArray[n] + "))) return false;");
            }
            ++n;
        }
        arrayList.add("return true;");
        String[] stringArray3 = new String[arrayList.size()];
        return arrayList.toArray(stringArray3);
    }

    static String normalizeClassName(String string) {
        if (string == null) {
            return null;
        }
        return string.replace('/', '.').replace('$', '.');
    }

    static String getPackageName(String string) {
        if (string == null) {
            return null;
        }
        return JavaTypeHelper.getPackageName(string.replace('/', '.'));
    }

    static String getClassName(String string) {
        return JavaTypeHelper.getShortClassName(ImplHelper.normalizeClassName(string));
    }

    static {
        typeNameConversion.put(Integer.TYPE.getName(), "Int");
        typeNameConversion.put(Long.TYPE.getName(), "Long");
        typeNameConversion.put(Byte.TYPE.getName(), "Byte");
        typeNameConversion.put(Character.TYPE.getName(), "Char");
        typeNameConversion.put(Boolean.TYPE.getName(), "Boolean");
        typeNameConversion.put(Short.TYPE.getName(), "Short");
        typeNameConversion.put(Float.TYPE.getName(), "Float");
        typeNameConversion.put(Double.TYPE.getName(), "Double");
        typeNameConversion.put("String", "String");
    }
}

