/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.classfile;

import com.sun.jdo.api.persistence.enhancer.classfile.InsnError;
import com.sun.jdo.api.persistence.enhancer.classfile.VMConstants;
import java.util.Map;
import java.util.Stack;

public class Descriptor
implements VMConstants {
    public static int countMethodArgWords(String string) {
        if (string.charAt(0) != '(') {
            throw new InsnError("not a method signature");
        }
        int n = 0;
        int n2 = 1;
        while (string.charAt(n2) != ')') {
            switch (string.charAt(n2)) {
                case 'B': 
                case 'C': 
                case 'F': 
                case 'I': 
                case 'S': 
                case 'Z': {
                    ++n;
                    break;
                }
                case 'D': 
                case 'J': {
                    n += 2;
                    break;
                }
                case 'L': {
                    ++n;
                    n2 = string.indexOf(59, n2);
                    break;
                }
                case '[': {
                    ++n;
                    while (string.charAt(n2) == '[' || string.charAt(n2) == ']') {
                        ++n2;
                    }
                    if (string.charAt(n2) != 'L') break;
                    n2 = string.indexOf(59, n2);
                    break;
                }
                default: {
                    throw new InsnError("missing case");
                }
            }
            ++n2;
        }
        return n;
    }

    public static int countMethodReturnWords(String string) {
        int n = string.lastIndexOf(41) + 1;
        if (n == 0) {
            throw new InsnError("not a method signature");
        }
        switch (string.charAt(n)) {
            case 'D': 
            case 'J': {
                return 2;
            }
            case 'B': 
            case 'C': 
            case 'F': 
            case 'I': 
            case 'L': 
            case 'S': 
            case 'Z': 
            case '[': {
                return 1;
            }
            case 'V': {
                return 0;
            }
        }
        throw new InsnError("missing case");
    }

    public static String extractResultSig(String string) {
        return string.substring(string.indexOf(41) + 1);
    }

    public static String extractArgSig(String string) {
        return string.substring(1, string.indexOf(41));
    }

    public static String extractReversedArgSig(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Descriptor.reverseArgSig(stringBuffer, string, 1);
        return stringBuffer.toString();
    }

    private static void reverseArgSig(StringBuffer stringBuffer, String string, int n) {
        char c = string.charAt(n);
        if (c == ')') {
            return;
        }
        int n2 = n++;
        switch (c) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                break;
            }
            case '[': {
                while (string.charAt(n) == '[' || string.charAt(n) == ']') {
                    ++n;
                }
                if (string.charAt(n) != 'L') {
                    ++n;
                    break;
                }
            }
            case 'L': {
                n = string.indexOf(59, n) + 1;
                break;
            }
            default: {
                throw new InsnError("bad signature char");
            }
        }
        Descriptor.reverseArgSig(stringBuffer, string, n);
        while (n2 < n) {
            stringBuffer.append(string.charAt(n2++));
        }
    }

    public static int countFieldWords(String string) {
        if (string == null || string.length() < 1) {
            throw new InsnError("not a field signature");
        }
        switch (string.charAt(0)) {
            case 'D': 
            case 'J': {
                return 2;
            }
            case 'B': 
            case 'C': 
            case 'F': 
            case 'I': 
            case 'L': 
            case 'S': 
            case 'Z': 
            case '[': {
                return 1;
            }
        }
        throw new InsnError("missing case");
    }

    public static int elementType(String string) {
        if (string == null || string.length() < 1) {
            throw new InsnError("not a value signature");
        }
        switch (string.charAt(0)) {
            case 'B': {
                return 4;
            }
            case 'C': {
                return 5;
            }
            case 'Z': {
                return 8;
            }
            case 'S': {
                return 9;
            }
            case 'I': {
                return 10;
            }
            case 'J': {
                return 11;
            }
            case 'F': {
                return 6;
            }
            case 'D': {
                return 7;
            }
            case '[': {
                return 12;
            }
            case 'L': {
                return 12;
            }
        }
        throw new InsnError("bad signature char");
    }

    public static String elementSig(int n) {
        switch (n) {
            case 8: {
                return "B";
            }
            case 5: {
                return "C";
            }
            case 4: {
                return "Z";
            }
            case 9: {
                return "S";
            }
            case 10: {
                return "I";
            }
            case 11: {
                return "J";
            }
            case 6: {
                return "F";
            }
            case 7: {
                return "D";
            }
            case 12: {
                return "Ljava/lang/Object;";
            }
        }
        throw new InsnError("bad element type");
    }

    public static int elementSize(int n) {
        switch (n) {
            case 7: 
            case 11: 
            case 17: {
                return 2;
            }
        }
        return 1;
    }

    public static void computeStackTypes(String string, Stack stack) {
        int n = 0;
        while (n < string.length()) {
            int n2 = 0;
            switch (string.charAt(n)) {
                case 'B': 
                case 'C': 
                case 'I': 
                case 'S': 
                case 'Z': {
                    n2 = 10;
                    break;
                }
                case 'F': {
                    n2 = 6;
                    break;
                }
                case 'J': {
                    n2 = 11;
                    break;
                }
                case 'D': {
                    n2 = 7;
                    break;
                }
                case '?': {
                    n2 = 15;
                    break;
                }
                case 'W': {
                    n2 = 16;
                    break;
                }
                case 'X': {
                    n2 = 17;
                    break;
                }
                case 'A': {
                    n2 = 12;
                    break;
                }
                case '[': {
                    n2 = 12;
                    while (string.charAt(n) == '[' || string.charAt(n) == ']') {
                        ++n;
                    }
                    if (string.charAt(n) != 'L') break;
                }
                case 'L': {
                    n2 = 12;
                    n = string.indexOf(59, n);
                    break;
                }
                default: {
                    throw new InsnError("bad signature char");
                }
            }
            stack.push(new Integer(n2));
            ++n;
        }
    }

    public static int nextSigElement(String string, int n) {
        switch (string.charAt(n)) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                break;
            }
            case '[': {
                while (string.charAt(n) == '[' || string.charAt(n) == ']') {
                    ++n;
                }
                if (string.charAt(n) != 'L') break;
            }
            case 'L': {
                n = string.indexOf(59, n);
                break;
            }
            default: {
                throw new InsnError("bad signature char");
            }
        }
        return ++n;
    }

    public static String remapTypes(String string, Map map) {
        StringBuffer stringBuffer = null;
        int n = 0;
        while (n < string.length()) {
            int n2 = string.charAt(n);
            switch (n2) {
                case 91: {
                    while ((n2 = string.charAt(n)) == 91 || n2 == 93) {
                        ++n;
                        if (stringBuffer == null) continue;
                        stringBuffer.append((char)n2);
                    }
                    if (string.charAt(n) != 'L') break;
                }
                case 76: {
                    int n3 = string.indexOf(59, ++n);
                    String string2 = string.substring(n, n3);
                    String string3 = (String)map.get(string2);
                    if (string3 != null) {
                        if (stringBuffer == null) {
                            stringBuffer = new StringBuffer(string.length() + 20);
                            stringBuffer.append(string.substring(0, n - 1));
                        }
                        string2 = string3;
                    }
                    if (stringBuffer != null) {
                        stringBuffer.append('L');
                        stringBuffer.append(string2);
                    }
                    n = n3;
                    n2 = 59;
                }
            }
            if (stringBuffer != null) {
                stringBuffer.append((char)n2);
            }
            ++n;
        }
        return stringBuffer == null ? string : stringBuffer.toString();
    }

    public static String translateClass(String string, Map map) {
        if (string.charAt(0) == '[') {
            return Descriptor.remapTypes(string, map);
        }
        String string2 = (String)map.get(string);
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    public static String userFieldSig(String string) {
        return Descriptor.userFieldSig(string, 0);
    }

    public static String userFieldSig(String string, int n) {
        String string2 = "";
        int n2 = 0;
        boolean bl = true;
        while (bl) {
            bl = false;
            char c = string.charAt(n);
            switch (c) {
                case 'B': {
                    string2 = "byte";
                    break;
                }
                case 'C': {
                    string2 = "char";
                    break;
                }
                case 'Z': {
                    string2 = "boolean";
                    break;
                }
                case 'S': {
                    string2 = "short";
                    break;
                }
                case 'I': {
                    string2 = "int";
                    break;
                }
                case 'F': {
                    string2 = "float";
                    break;
                }
                case 'J': {
                    string2 = "long";
                    break;
                }
                case 'D': {
                    string2 = "double";
                    break;
                }
                case 'V': {
                    string2 = "void";
                    break;
                }
                case '[': {
                    ++n;
                    ++n2;
                    bl = true;
                    break;
                }
                case 'L': {
                    int n3 = string.indexOf(59, n);
                    string2 = string.substring(n + 1, n3).replace('/', '.');
                    break;
                }
                default: {
                    throw new InsnError("bad signature char");
                }
            }
        }
        if (n2 == 0) {
            return string2;
        }
        StringBuffer stringBuffer = new StringBuffer(string2.length() + 2 * n2);
        stringBuffer.append(string2);
        while (n2-- > 0) {
            stringBuffer.append("[]");
        }
        return stringBuffer.toString();
    }

    public static String userMethodArgs(String string) {
        if (string.charAt(0) != '(') {
            throw new InsnError("Invalid method signature");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        int n = 1;
        boolean bl = true;
        while (string.charAt(n) != ')') {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(", ");
            }
            stringBuffer.append(Descriptor.userFieldSig(string, n));
            n = Descriptor.nextSigElement(string, n);
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

