/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.classfile;

import com.sun.jdo.api.persistence.enhancer.classfile.AttributeVector;
import com.sun.jdo.api.persistence.enhancer.classfile.ClassAttribute;
import com.sun.jdo.api.persistence.enhancer.classfile.CodeEnv;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstantPool;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class AttributeVector {
    private ClassAttribute[] attributes = null;

    private ClassAttribute attrAt(int n) {
        return this.attributes[n];
    }

    public void addElement(ClassAttribute classAttribute) {
        if (this.attributes == null) {
            this.attributes = new ClassAttribute[1];
        } else {
            ClassAttribute[] classAttributeArray = new ClassAttribute[this.attributes.length + 1];
            System.arraycopy(this.attributes, 0, classAttributeArray, 0, this.attributes.length);
            this.attributes = classAttributeArray;
        }
        this.attributes[this.attributes.length - 1] = classAttribute;
    }

    public Enumeration elements() {
        class AttributeVectorEnumeration
        implements Enumeration {
            private ClassAttribute[] attributes;
            private int current;
            private final /* synthetic */ AttributeVector this$0;

            AttributeVectorEnumeration(AttributeVector attributeVector, ClassAttribute[] classAttributeArray) {
                this.this$0 = attributeVector;
                this.current = 0;
                this.attributes = classAttributeArray;
            }

            public boolean hasMoreElements() {
                return this.attributes != null && this.current < this.attributes.length;
            }

            public Object nextElement() {
                if (!this.hasMoreElements()) {
                    throw new NoSuchElementException();
                }
                return this.attributes[this.current++];
            }
        }
        return new AttributeVectorEnumeration(this, this.attributes);
    }

    public ClassAttribute findAttribute(String string) {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            ClassAttribute classAttribute = (ClassAttribute)enumeration.nextElement();
            if (!classAttribute.attrName().asString().equals(string)) continue;
            return classAttribute;
        }
        return null;
    }

    static AttributeVector readAttributes(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        AttributeVector attributeVector = new AttributeVector();
        int n = dataInputStream.readUnsignedShort();
        while (n-- > 0) {
            attributeVector.addElement(ClassAttribute.read(dataInputStream, constantPool));
        }
        return attributeVector;
    }

    static AttributeVector readAttributes(DataInputStream dataInputStream, CodeEnv codeEnv) throws IOException {
        AttributeVector attributeVector = new AttributeVector();
        int n = dataInputStream.readUnsignedShort();
        while (n-- > 0) {
            attributeVector.addElement(ClassAttribute.read(dataInputStream, codeEnv));
        }
        return attributeVector;
    }

    void write(DataOutputStream dataOutputStream) throws IOException {
        if (this.attributes == null) {
            dataOutputStream.writeShort(0);
        } else {
            dataOutputStream.writeShort(this.attributes.length);
            int n = 0;
            while (n < this.attributes.length) {
                this.attributes[n].write(dataOutputStream);
                ++n;
            }
        }
    }

    void print(PrintStream printStream, int n) {
        if (this.attributes != null) {
            int n2 = 0;
            while (n2 < this.attributes.length) {
                this.attributes[n2].print(printStream, n);
                ++n2;
            }
        }
    }

    void summarize() {
        System.out.println((this.attributes == null ? 0 : this.attributes.length) + " attributes");
    }
}

