/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer;

import com.sun.jdo.api.persistence.enhancer.ByteCodeEnhancer;
import com.sun.jdo.api.persistence.enhancer.ByteCodeEnhancerTimer;
import com.sun.jdo.api.persistence.enhancer.EnhancerFatalError;
import com.sun.jdo.api.persistence.enhancer.EnhancerUserException;
import com.sun.jdo.api.persistence.enhancer.FilterEnhancer;
import com.sun.jdo.api.persistence.enhancer.meta.JDOMetaData;
import com.sun.jdo.api.persistence.enhancer.meta.JDOMetaDataModelImpl;
import com.sun.jdo.api.persistence.enhancer.meta.JDOMetaDataTimer;
import com.sun.jdo.api.persistence.enhancer.util.Support;
import com.sun.jdo.api.persistence.model.Model;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import sun.misc.Resource;
import sun.misc.URLClassPath;

public class EnhancerClassLoader
extends URLClassLoader {
    public static final String DO_SIMPLE_TIMING = "ByteCodeEnhancer.doSimpleTiming";
    public static final String VERBOSE_LEVEL = "ByteCodeEnhancer.verboseLevel";
    public static final String VERBOSE_LEVEL_QUIET = "quiet";
    public static final String VERBOSE_LEVEL_WARN = "warn";
    public static final String VERBOSE_LEVEL_VERBOSE = "verbose";
    public static final String VERBOSE_LEVEL_DEBUG = "debug";
    private boolean debug = true;
    private boolean doTiming = false;
    private PrintWriter out = new PrintWriter(System.out, true);
    private ByteCodeEnhancer enhancer;
    private JDOMetaData metaData;
    private Properties settings;
    private WeakReference outByteCodeRef;
    private final URLClassPath ucp;
    private final AccessControlContext acc = AccessController.getContext();

    public static URL[] pathToURLs(String string) {
        return URLClassPath.pathToURLs((String)string);
    }

    private final void message() {
        if (this.debug) {
            this.out.println();
        }
    }

    private final void message(String string) {
        if (this.debug) {
            this.out.println(string);
        }
    }

    private final void message(Exception exception) {
        if (this.debug) {
            String string = "Exception caught: " + exception;
            this.out.println(string);
            exception.printStackTrace(this.out);
        }
    }

    protected EnhancerClassLoader(URL[] uRLArray) {
        super(uRLArray);
        this.ucp = new URLClassPath(uRLArray);
        this.checkUCP(uRLArray);
    }

    protected EnhancerClassLoader(URL[] uRLArray, ClassLoader classLoader) {
        super(uRLArray, classLoader);
        this.ucp = new URLClassPath(uRLArray);
        this.checkUCP(uRLArray);
    }

    public EnhancerClassLoader(String string, Properties properties, PrintWriter printWriter) {
        this(EnhancerClassLoader.pathToURLs(string));
        JDOMetaDataModelImpl jDOMetaDataModelImpl = new JDOMetaDataModelImpl(Model.ENHANCER, printWriter);
        this.init(jDOMetaDataModelImpl, properties, printWriter);
    }

    public EnhancerClassLoader(URL[] uRLArray, Properties properties, PrintWriter printWriter) {
        this(uRLArray);
        JDOMetaDataModelImpl jDOMetaDataModelImpl = new JDOMetaDataModelImpl(Model.ENHANCER, printWriter);
        this.init(jDOMetaDataModelImpl, properties, printWriter);
    }

    public EnhancerClassLoader(String string, JDOMetaData jDOMetaData, Properties properties, PrintWriter printWriter) {
        this(EnhancerClassLoader.pathToURLs(string));
        this.init(jDOMetaData, properties, printWriter);
    }

    public EnhancerClassLoader(URL[] uRLArray, JDOMetaData jDOMetaData, Properties properties, PrintWriter printWriter) {
        this(uRLArray);
        this.init(jDOMetaData, properties, printWriter);
    }

    protected void addURL(URL uRL) {
        throw new UnsupportedOperationException("Not implemented yet: EnhancerClassLoader.addURL(URL)");
    }

    private void checkUCP(URL[] uRLArray) {
        if (null == uRLArray) {
            throw new IllegalArgumentException("urls == null");
        }
        if (uRLArray.length == 0) {
            throw new IllegalArgumentException("urls.length == 0");
        }
        int n = 0;
        while (n < uRLArray.length) {
            super.addURL(uRLArray[n]);
            ++n;
        }
    }

    private void init(JDOMetaData jDOMetaData, Properties properties, PrintWriter printWriter) {
        URL[] uRLArray;
        this.out = printWriter;
        String string = properties == null ? null : properties.getProperty(VERBOSE_LEVEL);
        this.debug = VERBOSE_LEVEL_DEBUG.equals(string);
        this.settings = properties;
        this.metaData = jDOMetaData;
        this.enhancer = null;
        if (properties != null) {
            uRLArray = properties.getProperty(DO_SIMPLE_TIMING);
            this.doTiming = Boolean.valueOf((String)uRLArray);
        }
        if (this.doTiming) {
            this.metaData = new JDOMetaDataTimer(jDOMetaData);
        }
        this.message("EnhancerClassLoader: UCP = {");
        uRLArray = this.getURLs();
        int n = 0;
        while (n < uRLArray.length) {
            this.message("    " + uRLArray[n]);
            ++n;
        }
        this.message("}");
        this.message("EnhancerClassLoader: jdoMetaData = " + jDOMetaData);
    }

    public synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        this.message();
        this.message("EnhancerClassLoader: loading class: " + string);
        try {
            Class clazz = null;
            String string2 = string.replace('.', '/');
            if (string2.startsWith("java/") || string2.startsWith("javax/sql/") || string2.startsWith("javax/transaction/") || string2.startsWith("com/sun/jdo/")) {
                this.message("EnhancerClassLoader: bootstrap class, using parent loader for class: " + string);
                return super.loadClass(string, bl);
            }
            if (clazz == null && (clazz = this.findLoadedClass(string)) != null) {
                this.message("EnhancerClassLoader: class already loaded: " + string);
            }
            if (clazz == null) {
                clazz = this.findAndEnhanceClass(string);
            }
            if (clazz == null) {
                this.message("EnhancerClassLoader: class not found, using parent loader for class: " + string);
                return super.loadClass(string, bl);
            }
            this.message();
            this.message("EnhancerClassLoader: loaded class: " + string);
            if (bl) {
                this.resolveClass(clazz);
            }
            this.message();
            this.message("EnhancerClassLoader: loaded+resolved class: " + string);
            return clazz;
        }
        catch (RuntimeException runtimeException) {
            this.message();
            this.message("EnhancerClassLoader: EXCEPTION SEEN: " + runtimeException);
            throw runtimeException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.message();
            this.message("EnhancerClassLoader: EXCEPTION SEEN: " + classNotFoundException);
            throw classNotFoundException;
        }
    }

    private Class findAndEnhanceClass(final String string) throws ClassNotFoundException {
        try {
            if (this.doTiming) {
                Support.timer.push("EnhancerClassLoader.findAndEnhanceClass(String)", "EnhancerClassLoader.findAndEnhanceClass(" + string + ")");
            }
            Class clazz = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    String string3 = string.replace('.', '/').concat(".class");
                    Resource resource = EnhancerClassLoader.this.ucp.getResource(string3, false);
                    if (resource != null) {
                        try {
                            return EnhancerClassLoader.this.defineClass(string, resource);
                        }
                        catch (IOException iOException) {
                            String string2 = "Exception caught while loading class '" + string + "' : " + iOException;
                            throw new ClassNotFoundException(string2, iOException);
                        }
                    }
                    return null;
                }
            }, this.acc);
            Object var4_4 = null;
            if (this.doTiming) {
                Support.timer.pop();
            }
            return clazz;
        }
        catch (PrivilegedActionException privilegedActionException) {
            try {
                throw (ClassNotFoundException)privilegedActionException.getException();
            }
            catch (Throwable throwable) {
                block6: {
                    Object var4_5 = null;
                    if (!this.doTiming) break block6;
                    Support.timer.pop();
                }
                throw throwable;
            }
        }
    }

    private Class defineClass(String string, Resource resource) throws IOException, ClassNotFoundException {
        Object object;
        Certificate[] certificateArray;
        Object object2;
        int n = string.lastIndexOf(46);
        URL uRL = resource.getCodeSourceURL();
        if (n != -1) {
            object2 = string.substring(0, n);
            certificateArray = this.getPackage((String)object2);
            object = resource.getManifest();
            if (certificateArray != null) {
                boolean bl;
                if (certificateArray.isSealed()) {
                    bl = certificateArray.isSealed(uRL);
                } else {
                    boolean bl2 = bl = object == null || !this.isSealed((String)object2, (Manifest)object);
                }
                if (!bl) {
                    throw new SecurityException("sealing violation");
                }
            } else if (object != null) {
                this.definePackage((String)object2, (Manifest)object, uRL);
            } else {
                this.definePackage((String)object2, null, null, null, null, null, null, null);
            }
        }
        object2 = resource.getBytes();
        certificateArray = resource.getCertificates();
        object = new CodeSource(uRL, certificateArray);
        String string2 = string.replace('.', '/');
        if (!this.metaData.isTransientClass(string2)) {
            object2 = this.enhance(string, (byte[])object2, 0, ((byte[])object2).length);
        }
        return this.defineClass(string, (byte[])object2, 0, ((byte[])object2).length, (CodeSource)object);
    }

    private byte[] enhance(String string, byte[] byArray, int n, int n2) throws ClassNotFoundException {
        byte[] byArray2;
        try {
            ByteArrayOutputStream byteArrayOutputStream;
            if (null == this.enhancer) {
                this.enhancer = new FilterEnhancer(this.metaData, this.settings, this.out, null);
                if (this.doTiming) {
                    this.enhancer = new ByteCodeEnhancerTimer(this.enhancer);
                }
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n, n2);
            ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream = null == this.outByteCodeRef ? null : (ByteArrayOutputStream)this.outByteCodeRef.get();
            if (null == byteArrayOutputStream) {
                byteArrayOutputStream = new ByteArrayOutputStream(10000);
                this.outByteCodeRef = new WeakReference<ByteArrayOutputStream>(byteArrayOutputStream);
            }
            byteArrayOutputStream.reset();
            boolean bl = this.enhancer.enhanceClassFile((InputStream)byteArrayInputStream, byteArrayOutputStream);
            byArray2 = bl ? byteArrayOutputStream.toByteArray() : byArray;
        }
        catch (EnhancerUserException enhancerUserException) {
            this.message(enhancerUserException);
            String string2 = "Exception caught while loading class '" + string + "' : " + enhancerUserException;
            throw new ClassNotFoundException(string2, enhancerUserException);
        }
        catch (EnhancerFatalError enhancerFatalError) {
            this.message(enhancerFatalError);
            String string3 = "Exception caught while loading class '" + string + "' : " + enhancerFatalError;
            this.enhancer = null;
            throw new ClassNotFoundException(string3, enhancerFatalError);
        }
        return byArray2;
    }

    private boolean isSealed(String string, Manifest manifest) {
        String string2 = string.replace('.', '/').concat("/");
        Attributes attributes = manifest.getAttributes(string2);
        String string3 = null;
        if (attributes != null) {
            string3 = attributes.getValue(Attributes.Name.SEALED);
        }
        if (string3 == null && (attributes = manifest.getMainAttributes()) != null) {
            string3 = attributes.getValue(Attributes.Name.SEALED);
        }
        return "true".equalsIgnoreCase(string3);
    }
}

