/*
 * Decompiled with CFR 0.152.
 */
package com.sun.forte4j.modules.dbmodel;

import com.sun.forte4j.modules.dbmodel.ColumnElement;
import com.sun.forte4j.modules.dbmodel.ColumnElementHolder;
import com.sun.forte4j.modules.dbmodel.DBException;
import com.sun.forte4j.modules.dbmodel.DBIdentifier;
import com.sun.forte4j.modules.dbmodel.DBMemberElement;
import com.sun.forte4j.modules.dbmodel.DBMemoryCollection;
import com.sun.forte4j.modules.dbmodel.TableElement;

public abstract class KeyElement
extends DBMemberElement
implements ColumnElementHolder {
    public KeyElement() {
        this(new Memory(), null);
    }

    public KeyElement(Impl impl, TableElement tableElement) {
        super(impl, tableElement);
    }

    final Impl getKeyImpl() {
        return (Impl)this.getElementImpl();
    }

    public void addColumn(ColumnElement columnElement) throws DBException {
        this.addColumns(new ColumnElement[]{columnElement});
    }

    public void addColumns(ColumnElement[] columnElementArray) throws DBException {
        int n = 0;
        while (n < columnElementArray.length) {
            if (this.getColumn(columnElementArray[n].getName()) != null) {
                this.throwAddException("FMT_EXC_AddColumn", columnElementArray[n]);
            }
            ++n;
        }
        this.getKeyImpl().changeColumns(columnElementArray, 1);
    }

    public void removeColumn(ColumnElement columnElement) throws DBException {
        this.removeColumns(new ColumnElement[]{columnElement});
    }

    public void removeColumns(ColumnElement[] columnElementArray) throws DBException {
        this.getKeyImpl().changeColumns(columnElementArray, -1);
    }

    public void setColumns(ColumnElement[] columnElementArray) throws DBException {
        this.getKeyImpl().changeColumns(columnElementArray, 0);
    }

    public ColumnElement[] getColumns() {
        return this.getKeyImpl().getColumns();
    }

    public ColumnElement getColumn(DBIdentifier dBIdentifier) {
        return this.getKeyImpl().getColumn(dBIdentifier);
    }

    private void throwAddException(String string, ColumnElement columnElement) throws DBException {
        String string2 = columnElement.getName().getName();
        throw new DBException(string2);
    }

    static class Memory
    extends DBMemberElement.Memory
    implements Impl {
        private DBMemoryCollection.Column columns;

        Memory() {
        }

        Memory(KeyElement keyElement) {
            super(keyElement);
        }

        public synchronized void changeColumns(ColumnElement[] columnElementArray, int n) {
            this.initColumns();
            this.columns.change(columnElementArray, n);
        }

        public synchronized ColumnElement[] getColumns() {
            this.initColumns();
            return (ColumnElement[])this.columns.getElements();
        }

        public synchronized ColumnElement getColumn(DBIdentifier dBIdentifier) {
            this.initColumns();
            return (ColumnElement)this.columns.getElement(dBIdentifier);
        }

        void initColumns() {
            if (this.columns == null) {
                this.columns = new DBMemoryCollection.Column(this);
            }
        }
    }

    public static interface Impl
    extends DBMemberElement.Impl {
        public void changeColumns(ColumnElement[] var1, int var2) throws DBException;

        public ColumnElement[] getColumns();

        public ColumnElement getColumn(DBIdentifier var1);
    }
}

