/*
 * Decompiled with CFR 0.152.
 */
package com.sun.forte4j.modules.dbmodel;

import com.sun.forte4j.modules.dbmodel.ColumnElement;
import com.sun.forte4j.modules.dbmodel.ColumnElementHolder;
import com.sun.forte4j.modules.dbmodel.DBElement;
import com.sun.forte4j.modules.dbmodel.DBException;
import com.sun.forte4j.modules.dbmodel.DBIdentifier;
import com.sun.forte4j.modules.dbmodel.DBMemberElement;
import com.sun.forte4j.modules.dbmodel.DBMemoryCollection;
import com.sun.forte4j.modules.dbmodel.TableElement;

public final class IndexElement
extends DBMemberElement
implements ColumnElementHolder {
    public IndexElement() {
        this(new Memory(), null);
    }

    public IndexElement(Impl impl, TableElement tableElement) {
        super(impl, tableElement);
    }

    final Impl getIndexImpl() {
        return (Impl)this.getElementImpl();
    }

    public boolean isUnique() {
        return this.getIndexImpl().isUnique();
    }

    public void setUnique(boolean bl) throws DBException {
        this.getIndexImpl().setUnique(bl);
    }

    public void addColumn(ColumnElement columnElement) throws DBException {
        this.addColumns(new ColumnElement[]{columnElement});
    }

    public void addColumns(ColumnElement[] columnElementArray) throws DBException {
        int n = 0;
        while (n < columnElementArray.length) {
            if (this.getColumn(columnElementArray[n].getName()) != null) {
                this.throwAddException("FMT_EXC_AddColumn", columnElementArray[n]);
            }
            ++n;
        }
        this.getIndexImpl().changeColumns(columnElementArray, 1);
    }

    public void removeColumn(ColumnElement columnElement) throws DBException {
        this.removeColumns(new ColumnElement[]{columnElement});
    }

    public void removeColumns(ColumnElement[] columnElementArray) throws DBException {
        this.getIndexImpl().changeColumns(columnElementArray, -1);
    }

    public void setColumns(ColumnElement[] columnElementArray) throws DBException {
        if (columnElementArray == null) {
            throw new NullPointerException(DBElement.bundle.getString("NulIndexes"));
        }
        this.getIndexImpl().changeColumns(columnElementArray, 0);
    }

    public ColumnElement[] getColumns() {
        return this.getIndexImpl().getColumns();
    }

    public ColumnElement getColumn(DBIdentifier dBIdentifier) {
        return this.getIndexImpl().getColumn(dBIdentifier);
    }

    private void throwAddException(String string, ColumnElement columnElement) throws DBException {
        String string2 = columnElement.getName().getName();
        throw new DBException(string2);
    }

    static class Memory
    extends DBMemberElement.Memory
    implements Impl {
        private boolean _unique;
        private DBMemoryCollection.Column columns;

        Memory() {
            this._unique = true;
        }

        Memory(IndexElement indexElement) {
            super(indexElement);
            this._unique = indexElement.isUnique();
        }

        public boolean isUnique() {
            return this._unique;
        }

        public void setUnique(boolean bl) {
            boolean bl2 = this._unique;
            this._unique = bl;
            this.firePropertyChange("unique", new Boolean(bl2), new Boolean(bl));
        }

        public synchronized void changeColumns(ColumnElement[] columnElementArray, int n) {
            this.initColumns();
            this.columns.change(columnElementArray, n);
        }

        public synchronized ColumnElement[] getColumns() {
            this.initColumns();
            return (ColumnElement[])this.columns.getElements();
        }

        public synchronized ColumnElement getColumn(DBIdentifier dBIdentifier) {
            this.initColumns();
            return (ColumnElement)this.columns.getElement(dBIdentifier);
        }

        void initColumns() {
            if (this.columns == null) {
                this.columns = new DBMemoryCollection.Column(this);
            }
        }
    }

    public static interface Impl
    extends DBMemberElement.Impl {
        public boolean isUnique();

        public void setUnique(boolean var1) throws DBException;

        public void changeColumns(ColumnElement[] var1, int var2) throws DBException;

        public ColumnElement[] getColumns();

        public ColumnElement getColumn(DBIdentifier var1);
    }
}

