/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.forte.editors;

import com.iplanet.ias.tools.common.util.diagnostics.Reporter;
import java.awt.Component;
import java.beans.PropertyEditorSupport;
import java.io.File;
import javax.swing.JFileChooser;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;

public class ChooseDirEditor
extends PropertyEditorSupport {
    private String pathname = "";

    public ChooseDirEditor(String path) {
        this.pathname = path;
    }

    public String getAsText() {
        Reporter.info(this.pathname);
        return this.pathname;
    }

    public void setAsText(String val) throws IllegalArgumentException {
        Reporter.info(val);
        this.pathname = val;
        this.firePropertyChange();
    }

    public void setValue(Object val) {
        Reporter.info(val);
        if (!(val instanceof String)) {
            throw new IllegalArgumentException();
        }
        this.pathname = (String)val;
        super.setValue(this.pathname);
        this.firePropertyChange();
    }

    public Object getValue() {
        Reporter.info(this.pathname);
        return this.pathname;
    }

    public String getJavaInitializationString() {
        return this.getAsText();
    }

    public Component getCustomEditor() {
        Reporter.info(this.pathname);
        if (this.pathname == null || this.pathname.length() == 0) {
            return new DirChooser();
        }
        return new DirChooser(this.pathname);
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    class DirChooser
    extends JFileChooser
    implements EnhancedCustomPropertyEditor {
        String dir = "";

        public DirChooser() {
            this.setFileSelectionMode(1);
            this.setControlButtonsAreShown(false);
        }

        public DirChooser(String path) {
            super(new File(path));
            this.setFileSelectionMode(1);
            this.setControlButtonsAreShown(false);
            this.dir = path;
        }

        public Object getPropertyValue() throws IllegalStateException {
            this.approveSelection();
            if (this.getSelectedFile() != null) {
                this.dir = this.getSelectedFile().getAbsolutePath();
            }
            Reporter.info(this.dir);
            return this.dir;
        }
    }
}

