/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.forte.common;

import com.iplanet.ias.tools.common.util.diagnostics.Reporter;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import org.openide.DialogDescriptor;
import org.openide.TopManager;
import org.openide.util.NbBundle;

public class IASExportStubsPanel
extends JPanel {
    private static final ResourceBundle bundle = NbBundle.getBundle((Class)(class$com$iplanet$ias$tools$forte$common$IASExportStubsPanel == null ? (class$com$iplanet$ias$tools$forte$common$IASExportStubsPanel = IASExportStubsPanel.class$("com.iplanet.ias.tools.forte.common.IASExportStubsPanel")) : class$com$iplanet$ias$tools$forte$common$IASExportStubsPanel));
    private JFileChooser fc;
    private Dialog dialog;
    private boolean done;
    private File prevLocation;
    private File fileToReturn = null;
    static /* synthetic */ Class class$com$iplanet$ias$tools$forte$common$IASExportStubsPanel;

    public IASExportStubsPanel(File prevLocation) {
        this.prevLocation = prevLocation;
        this.init();
    }

    private void init() {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints gc = new GridBagConstraints();
        this.setLayout(gridbag);
        gc.gridx = 0;
        gc.gridy = 0;
        gc.gridwidth = 2;
        gc.insets = new Insets(0, 5, 3, 5);
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.fill = 1;
        this.fc = new JFileChooser();
        this.fc.setDialogType(2);
        gridbag.setConstraints(this.fc, gc);
        this.fc.setApproveButtonText(bundle.getString("LBL_Export"));
        this.fc.setApproveButtonMnemonic(bundle.getString("LBL_Export_Mnemonic").charAt(0));
        this.add(this.fc);
    }

    public File getSelectedFile() {
        ActionListener actListener = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Reporter.verbose("event : " + evt);
                if (evt.getActionCommand().equals("ApproveSelection")) {
                    IASExportStubsPanel.this.handleSelection();
                    if (IASExportStubsPanel.this.done) {
                        IASExportStubsPanel.this.dialog.hide();
                    }
                } else if (evt.getActionCommand().equals("CancelSelection")) {
                    IASExportStubsPanel.this.fileToReturn = null;
                    IASExportStubsPanel.this.done = true;
                    IASExportStubsPanel.this.dialog.hide();
                }
            }
        };
        this.fc.addActionListener(actListener);
        this.fc.setCurrentDirectory(this.prevLocation);
        this.fc.setDialogTitle(bundle.getString("LBL_ExportStubsTitle"));
        this.fc.setFileSelectionMode(1);
        DialogDescriptor dd = new DialogDescriptor((Object)this, bundle.getString("LBL_ExportStubsTitle"));
        JButton invisibleButton = new JButton();
        invisibleButton.setVisible(false);
        Object[] dummy = new Object[]{invisibleButton};
        dd.setOptions(dummy);
        this.dialog = TopManager.getDefault().createDialog(dd);
        this.dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent wEvt) {
                IASExportStubsPanel.this.fileToReturn = null;
                IASExportStubsPanel.this.done = true;
            }
        });
        this.done = false;
        while (!this.done) {
            this.dialog.show();
        }
        return this.fileToReturn;
    }

    private void handleSelection() {
        File currDir = this.fc.getCurrentDirectory();
        File selFile = this.fc.getSelectedFile();
        Reporter.verbose("selected directory : " + currDir.getAbsolutePath());
        File tempFile = new File(currDir.getAbsolutePath() + File.separator + selFile.getName());
        String jarFileName = tempFile.getAbsolutePath();
        Reporter.verbose("selected file : " + jarFileName);
        this.fileToReturn = new File(jarFileName);
        if (!this.fileToReturn.isDirectory()) {
            return;
        }
        this.done = true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class JarFilter
    extends FileFilter {
        private JarFilter() {
        }

        public boolean accept(File f) {
            return f.isDirectory();
        }

        public String getDescription() {
            return "";
        }
    }
}

