/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.comm;

import com.iplanet.ias.admin.comm.AFConnectionException;
import com.iplanet.ias.admin.comm.ConnectionFactory;
import com.iplanet.ias.admin.comm.ConnectorClient;
import com.iplanet.ias.admin.comm.HttpConnectorAddress;
import com.iplanet.ias.admin.comm.IConnection;
import com.iplanet.ias.admin.common.AdminRequest;
import com.iplanet.ias.admin.common.AdminRequestConfigurator;
import com.iplanet.ias.admin.common.AdminResponse;
import com.iplanet.ias.admin.common.AdminResponseConfigurator;
import com.iplanet.ias.admin.common.exception.AFRuntimeException;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.admin.util.ExceptionUtil;
import java.io.IOException;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;

public class AdminConnectorClient
implements ConnectorClient {
    private final HttpConnectorAddress connectorAddress;
    private static final String ADMIN_CLIENT_VERSION = "1.1";

    public AdminConnectorClient(HttpConnectorAddress address) {
        this.connectorAddress = address;
        Debug.println("AdminConnectorClient.<init> : host = " + address.getHost() + " port = " + address.getPort() + " user = " + address.getAuthenticationInfo().getUser());
    }

    public String getClientVersion() {
        return ADMIN_CLIENT_VERSION;
    }

    public Object invoke(ObjectName mbeanName, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        Object returnValue = null;
        AdminRequest request = new AdminRequest("invoke");
        AdminRequestConfigurator reqConfigurator = new AdminRequestConfigurator(request);
        reqConfigurator.setObjectName(mbeanName);
        reqConfigurator.setOperationName(operationName);
        reqConfigurator.setOperationParams(params);
        reqConfigurator.setOperationSignature(signature);
        reqConfigurator.setClientVersion(ADMIN_CLIENT_VERSION);
        AdminResponse response = this.sendRequest(request);
        AdminResponseConfigurator resConfigurator = new AdminResponseConfigurator(response);
        if (resConfigurator.hasException()) {
            Throwable t = resConfigurator.getException();
            if (t instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)t;
            }
            if (t instanceof MBeanException) {
                throw (MBeanException)t;
            }
            if (t instanceof ReflectionException) {
                throw (ReflectionException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw new RuntimeErrorException((Error)t);
            }
        } else {
            returnValue = resConfigurator.getReturnValue();
        }
        return returnValue;
    }

    public Object getAttribute(ObjectName mbeanName, String attributeName) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        Object returnValue = null;
        AdminRequest request = new AdminRequest("getAttribute");
        AdminRequestConfigurator reqConfigurator = new AdminRequestConfigurator(request);
        reqConfigurator.setObjectName(mbeanName);
        reqConfigurator.setAttributeName(attributeName);
        reqConfigurator.setClientVersion(ADMIN_CLIENT_VERSION);
        AdminResponse response = this.sendRequest(request);
        AdminResponseConfigurator resConfigurator = new AdminResponseConfigurator(response);
        if (resConfigurator.hasException()) {
            Throwable t = resConfigurator.getException();
            if (t instanceof AttributeNotFoundException) {
                throw (AttributeNotFoundException)t;
            }
            if (t instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)t;
            }
            if (t instanceof MBeanException) {
                throw (MBeanException)t;
            }
            if (t instanceof ReflectionException) {
                throw (ReflectionException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw new RuntimeErrorException((Error)t);
            }
        } else {
            returnValue = resConfigurator.getReturnValue();
        }
        return returnValue;
    }

    public void setAttribute(ObjectName mbeanName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        AdminRequest request = new AdminRequest("setAttribute");
        AdminRequestConfigurator reqConfigurator = new AdminRequestConfigurator(request);
        reqConfigurator.setObjectName(mbeanName);
        reqConfigurator.setAttribute(attribute);
        reqConfigurator.setClientVersion(ADMIN_CLIENT_VERSION);
        AdminResponse response = this.sendRequest(request);
        AdminResponseConfigurator resConfigurator = new AdminResponseConfigurator(response);
        if (resConfigurator.hasException()) {
            Throwable t = resConfigurator.getException();
            if (t instanceof AttributeNotFoundException) {
                throw (AttributeNotFoundException)t;
            }
            if (t instanceof InvalidAttributeValueException) {
                throw (InvalidAttributeValueException)t;
            }
            if (t instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)t;
            }
            if (t instanceof MBeanException) {
                throw (MBeanException)t;
            }
            if (t instanceof ReflectionException) {
                throw (ReflectionException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw new RuntimeErrorException((Error)t);
            }
        }
    }

    public AttributeList getAttributes(ObjectName mbeanName, String[] attributes) throws InstanceNotFoundException, ReflectionException {
        AttributeList values = null;
        AdminRequest request = new AdminRequest("getAttributes");
        AdminRequestConfigurator reqConfigurator = new AdminRequestConfigurator(request);
        reqConfigurator.setObjectName(mbeanName);
        reqConfigurator.setAttributeNames(attributes);
        reqConfigurator.setClientVersion(ADMIN_CLIENT_VERSION);
        AdminResponse response = this.sendRequest(request);
        AdminResponseConfigurator resConfigurator = new AdminResponseConfigurator(response);
        if (resConfigurator.hasException()) {
            Throwable t = resConfigurator.getException();
            if (t instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)t;
            }
            if (t instanceof ReflectionException) {
                throw (ReflectionException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw new RuntimeErrorException((Error)t);
            }
        } else {
            values = (AttributeList)resConfigurator.getReturnValue();
        }
        return values;
    }

    public AttributeList setAttributes(ObjectName mbeanName, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        AttributeList values = null;
        AdminRequest request = new AdminRequest("setAttributes");
        AdminRequestConfigurator reqConfigurator = new AdminRequestConfigurator(request);
        reqConfigurator.setObjectName(mbeanName);
        reqConfigurator.setAttributeList(attributes);
        reqConfigurator.setClientVersion(ADMIN_CLIENT_VERSION);
        AdminResponse response = this.sendRequest(request);
        AdminResponseConfigurator resConfigurator = new AdminResponseConfigurator(response);
        if (resConfigurator.hasException()) {
            Throwable t = resConfigurator.getException();
            if (t instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)t;
            }
            if (t instanceof ReflectionException) {
                throw (ReflectionException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw new RuntimeErrorException((Error)t);
            }
        } else {
            values = (AttributeList)resConfigurator.getReturnValue();
        }
        return values;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private AdminResponse sendRequest(AdminRequest request) throws AFConnectionException, AFRuntimeException {
        AdminResponse response = null;
        IConnection connection = null;
        connection = ConnectionFactory.createConnection(this.connectorAddress);
        connection.send(request);
        response = (AdminResponse)connection.receive();
        Object var8_4 = null;
        if (connection == null) return response;
        try {
            connection.close();
            return response;
        }
        catch (Exception e) {
            ExceptionUtil.ignoreException(e);
        }
        return response;
        {
            catch (IOException e) {
                Debug.printStackTrace(e);
                throw new AFConnectionException(e.getMessage());
            }
            catch (ClassNotFoundException cnfe) {
                throw new AFRuntimeException(cnfe.toString());
            }
            catch (Exception e) {
                throw new AFRuntimeException(e.getLocalizedMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_5 = null;
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (Exception e) {
                ExceptionUtil.ignoreException(e);
            }
            throw throwable;
        }
    }
}

