/*
 * Decompiled with CFR 0.152.
 */
package javax.management.relation;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.management.ObjectName;
import javax.management.relation.RoleStatus;

public class RoleUnresolved
implements Serializable {
    private String myRoleName = null;
    private ArrayList myRoleValue = null;
    private int myPbType;

    public RoleUnresolved(String string, List list, int n) throws IllegalArgumentException {
        if (string == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        this.setRoleName(string);
        this.setRoleValue(list);
        this.setProblemType(n);
    }

    public Object clone() {
        try {
            return new RoleUnresolved(this.myRoleName, this.myRoleValue, this.myPbType);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public int getProblemType() {
        return this.myPbType;
    }

    public String getRoleName() {
        return this.myRoleName;
    }

    public List getRoleValue() {
        return this.myRoleValue;
    }

    public void setProblemType(int n) throws IllegalArgumentException {
        if (!RoleStatus.isRoleStatus(n)) {
            String string = "Incorrect problem type.";
            throw new IllegalArgumentException(string);
        }
        this.myPbType = n;
    }

    public void setRoleName(String string) throws IllegalArgumentException {
        if (string == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        this.myRoleName = new String(string);
    }

    public void setRoleValue(List list) {
        if (list != null) {
            this.myRoleValue = new ArrayList();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ObjectName objectName = (ObjectName)iterator.next();
                this.myRoleValue.add(objectName);
            }
        } else {
            this.myRoleValue = null;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("role name: " + this.myRoleName);
        if (this.myRoleValue != null) {
            stringBuffer.append("; value: ");
            Iterator iterator = ((AbstractList)this.myRoleValue).iterator();
            while (iterator.hasNext()) {
                ObjectName objectName = (ObjectName)iterator.next();
                stringBuffer.append(objectName.toString());
                if (!iterator.hasNext()) continue;
                stringBuffer.append(", ");
            }
        }
        stringBuffer.append("; problem type: " + this.myPbType);
        return stringBuffer.toString();
    }
}

