/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j2ee.blueprints.smarticket.ejb.customer;

import com.sun.j2ee.blueprints.smarticket.ejb.customer.CustomerInformation;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.naming.InitialContext;
import javax.sql.DataSource;

public class CustomerEJB
implements EntityBean {
    protected static final String CUSTOMER_DB = "java:comp/env/jdbc/CustomerDataSource";
    protected EntityContext entityContext;
    protected DataSource dataSource;
    protected CustomerInformation information;

    public void setEntityContext(EntityContext entityContext) {
        this.entityContext = entityContext;
        try {
            InitialContext initialContext = new InitialContext();
            this.dataSource = (DataSource)initialContext.lookup(CUSTOMER_DB);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new EJBException(exception);
        }
    }

    public void unsetEntityContext() {
        this.dataSource = null;
        this.entityContext = null;
    }

    public String ejbCreate(String string, String string2, String string3, String string4) throws EJBException, DuplicateKeyException, CreateException {
        String string5 = this.dbInsertCustomer(string, string2, string3, string4);
        if (string5 != null) {
            return string5;
        }
        throw new CreateException(string);
    }

    public void ejbLoad() {
        this.dbLoadCustomer();
    }

    public String ejbFindByPrimaryKey(String string) throws FinderException {
        String string2 = this.dbFindCustomer(string);
        if (string2 != null) {
            return string2;
        }
        throw new ObjectNotFoundException(string);
    }

    public void ejbPostCreate(String string, String string2, String string3, String string4) throws EJBException, DuplicateKeyException, CreateException {
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }

    public void ejbStore() {
    }

    public void ejbRemove() {
    }

    public CustomerInformation getInformation() {
        return this.information;
    }

    String dbInsertCustomer(String string, String string2, String string3, String string4) throws DuplicateKeyException {
        if (this.dbFindCustomer(string) != null) {
            throw new DuplicateKeyException();
        }
        try {
            Connection connection = this.dataSource.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement("insert into userprefs (username, password, zipcode, creditcard) values (?, ?, ?, ?)");
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            preparedStatement.setString(3, string3);
            preparedStatement.setString(4, string4);
            preparedStatement.executeUpdate();
            preparedStatement.close();
            connection.close();
            return string;
        }
        catch (SQLException sQLException) {
            throw new EJBException((Exception)sQLException);
        }
    }

    void dbLoadCustomer() {
        try {
            Connection connection = null;
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            connection = this.dataSource.getConnection();
            preparedStatement = connection.prepareStatement("select u.username, u.password, u.zipcode, u.creditcard from userprefs u where username = ?");
            String string = (String)this.entityContext.getPrimaryKey();
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                this.information = new CustomerInformation(resultSet.getString(1), resultSet.getString(2), resultSet.getString(3), resultSet.getString(4));
            }
            resultSet.close();
            preparedStatement.close();
            connection.close();
        }
        catch (SQLException sQLException) {
            throw new EJBException((Exception)sQLException);
        }
    }

    String dbFindCustomer(String string) {
        try {
            Connection connection = null;
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            connection = this.dataSource.getConnection();
            preparedStatement = connection.prepareStatement("select username from userprefs where username = ?");
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            String string2 = resultSet.next() ? string : null;
            resultSet.close();
            preparedStatement.close();
            connection.close();
            return string2;
        }
        catch (SQLException sQLException) {
            throw new EJBException((Exception)sQLException);
        }
    }
}

