/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.provider;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.SignatureAlgorithm;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.crypto.TokenSupplierManager;

public class Signature {
    org.mozilla.jss.crypto.Signature sig;

    public void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom, SignatureAlgorithm signatureAlgorithm) throws InvalidKeyException {
        this.engineInitSign(privateKey, signatureAlgorithm);
    }

    public void engineInitSign(PrivateKey privateKey, SignatureAlgorithm signatureAlgorithm) throws InvalidKeyException {
        try {
            this.sig = Signature.getSigContext(privateKey, signatureAlgorithm);
            this.sig.initSign((org.mozilla.jss.crypto.PrivateKey)privateKey);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InvalidKeyException("Algorithm not supported");
        }
        catch (TokenException tokenException) {
            throw new InvalidKeyException("Token exception occurred");
        }
    }

    public void engineInitVerify(PublicKey publicKey, SignatureAlgorithm signatureAlgorithm) throws InvalidKeyException {
        try {
            CryptoToken cryptoToken = TokenSupplierManager.getTokenSupplier().getInternalCryptoToken();
            this.sig = cryptoToken.getSignatureContext(signatureAlgorithm);
            this.sig.initVerify(publicKey);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InvalidKeyException("Algorithm not supported");
        }
        catch (TokenException tokenException) {
            throw new InvalidKeyException("Token exception occurred");
        }
    }

    public void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        try {
            this.sig.setParameter(algorithmParameterSpec);
        }
        catch (TokenException tokenException) {
            throw new InvalidAlgorithmParameterException("TokenException: " + tokenException.toString());
        }
    }

    public byte[] engineSign() throws SignatureException {
        try {
            return this.sig.sign();
        }
        catch (TokenException tokenException) {
            throw new SignatureException("TokenException: " + tokenException.toString());
        }
    }

    public int engineSign(byte[] byArray, int n, int n2) throws SignatureException {
        try {
            return this.sig.sign(byArray, n, n2);
        }
        catch (TokenException tokenException) {
            throw new SignatureException("TokenException: " + tokenException.toString());
        }
    }

    public void engineUpdate(byte by) throws SignatureException {
        try {
            this.sig.update(by);
        }
        catch (TokenException tokenException) {
            throw new SignatureException("TokenException: " + tokenException.toString());
        }
    }

    public void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        try {
            this.sig.update(byArray, n, n2);
        }
        catch (TokenException tokenException) {
            throw new SignatureException("TokenException: " + tokenException.toString());
        }
    }

    public boolean engineVerify(byte[] byArray) throws SignatureException {
        try {
            return this.sig.verify(byArray);
        }
        catch (TokenException tokenException) {
            throw new SignatureException("TokenException: " + tokenException.toString());
        }
    }

    protected static org.mozilla.jss.crypto.Signature getSigContext(PrivateKey privateKey, SignatureAlgorithm signatureAlgorithm) throws NoSuchAlgorithmException, InvalidKeyException, TokenException {
        if (!(privateKey instanceof org.mozilla.jss.crypto.PrivateKey)) {
            throw new InvalidKeyException();
        }
        org.mozilla.jss.crypto.PrivateKey privateKey2 = (org.mozilla.jss.crypto.PrivateKey)privateKey;
        CryptoToken cryptoToken = privateKey2.getOwningToken();
        return cryptoToken.getSignatureContext(signatureAlgorithm);
    }
}

