/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.factory;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.apache.naming.EjbRef;

public class EjbFactory
implements ObjectFactory {
    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws Exception {
        if (object instanceof EjbRef) {
            Reference reference = (Reference)object;
            RefAddr refAddr = reference.get("link");
            if (refAddr != null) {
                String string = refAddr.getContent().toString();
                Object object2 = new InitialContext().lookup(string);
                return object2;
            }
            ObjectFactory objectFactory = null;
            RefAddr refAddr2 = reference.get("factory");
            if (refAddr2 != null) {
                String string = refAddr2.getContent().toString();
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                Class<?> clazz = null;
                if (classLoader != null) {
                    try {
                        clazz = classLoader.loadClass(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                } else {
                    try {
                        clazz = Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                if (clazz != null) {
                    try {
                        objectFactory = (ObjectFactory)clazz.newInstance();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            if (objectFactory != null) {
                return objectFactory.getObjectInstance(object, name, context, hashtable);
            }
            throw new NamingException("Cannot create resource instance");
        }
        return null;
    }
}

