/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.logging;

import java.io.IOException;
import javax.servlet.ServletContext;
import org.apache.jasper.logging.Logger;

public class DefaultLogger
extends Logger {
    private static char[] newline;
    protected ServletContext servletContext;

    public DefaultLogger() {
    }

    public DefaultLogger(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    protected void realLog(String string) {
        if (this.servletContext != null) {
            this.servletContext.log(string);
            return;
        }
        try {
            Logger.defaultSink.write(string);
            Logger.defaultSink.write(newline);
            this.flush();
        }
        catch (IOException iOException) {
            this.bad(iOException, string, null);
        }
    }

    protected void realLog(String string, Throwable throwable) {
        if (this.servletContext != null) {
            this.servletContext.log(string, throwable);
            return;
        }
        try {
            Logger.defaultSink.write(string);
            Logger.defaultSink.write(newline);
            Logger.defaultSink.write(Logger.throwableToString(throwable));
            Logger.defaultSink.write(newline);
            this.flush();
        }
        catch (IOException iOException) {
            this.bad(iOException, string, throwable);
        }
    }

    private void bad(Throwable throwable, String string, Throwable throwable2) {
        System.err.println("Default sink is unwritable! Reason:");
        if (throwable != null) {
            throwable.printStackTrace();
        }
        if (string != null) {
            System.err.println(string);
        }
        if (throwable2 != null) {
            throwable2.printStackTrace();
        }
    }

    public void flush() {
        try {
            Logger.defaultSink.flush();
        }
        catch (IOException iOException) {}
    }

    static {
        String string = System.getProperty("line.separator", "\n");
        newline = string.toCharArray();
    }
}

