/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.Logger;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;

public class ErrorReportValve
extends ValveBase {
    private int debug = 0;
    private static final String info = "org.apache.catalina.valves.ErrorReportValve/1.0";
    protected static StringManager sm = StringManager.getManager("org.apache.catalina.valves");

    public String getInfo() {
        return info;
    }

    public int invoke(Request request, Response response) throws IOException, ServletException {
        return 1;
    }

    public void postInvoke(Request request, Response response) throws IOException, ServletException {
        ServletResponse servletResponse = (ServletResponse)response;
        if (servletResponse.isCommitted()) {
            return;
        }
        ServletRequest servletRequest = (ServletRequest)request;
        Throwable throwable = (Throwable)servletRequest.getAttribute("javax.servlet.error.exception");
        if (throwable != null) {
            response.setError();
            try {
                servletResponse.reset();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            ServletResponse servletResponse2 = (ServletResponse)response;
            if (servletResponse2 instanceof HttpServletResponse) {
                ((HttpServletResponse)servletResponse2).sendError(500);
            }
        }
        response.setSuspended(false);
        try {
            this.report(request, response, throwable);
        }
        catch (Throwable throwable2) {
            throwable2.printStackTrace();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("ErrorReportValve[");
        stringBuffer.append(this.container.getName());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    protected void report(Request request, Response response, Throwable throwable) throws IOException {
        block18: {
            Writer writer;
            String string;
            if (!(response instanceof HttpResponse)) {
                return;
            }
            HttpResponse httpResponse = (HttpResponse)response;
            if (!(response instanceof HttpServletResponse)) {
                return;
            }
            HttpServletResponse httpServletResponse = (HttpServletResponse)response;
            int n = httpResponse.getStatus();
            if (n < 300) {
                return;
            }
            if (n == 304) {
                return;
            }
            Throwable throwable2 = null;
            if (throwable != null && throwable instanceof ServletException) {
                throwable2 = ((ServletException)throwable).getRootCause();
            }
            if ((string = RequestUtil.filter(httpResponse.getMessage())) == null) {
                string = "";
            }
            String string2 = null;
            try {
                string2 = sm.getString("http." + n, string);
            }
            catch (Throwable throwable3) {
                // empty catch block
            }
            if (string2 == null) {
                return;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<html><head>\n<title>\n");
            stringBuffer.append("Sun ONE Application Server").append(" - ");
            stringBuffer.append(sm.getString("errorReportValve.errorReport", String.valueOf(n)) + "\n");
            stringBuffer.append("</title>\n");
            stringBuffer.append("<STYLE><!--\n");
            stringBuffer.append("BODY{font-family : verdana, geneva, helvetica, arial, sans-serif; color : black;background-color : white;}\n");
            stringBuffer.append(".default-body{font-family : verdana, geneva, helvetica, arial, sans-serif;}\n");
            stringBuffer.append("--></STYLE>\n");
            stringBuffer.append("</head>\n");
            stringBuffer.append("<body leftmargin=\"0\" topmargin=\"0\" marginwidth=\"0\" margingheight=\"0\">\n");
            stringBuffer.append("<table cellspacing=\"10\" cellpadding=\"0\" border=\"0\">\n");
            stringBuffer.append("<tr>\n<td>\n");
            stringBuffer.append("<table width=\"100%\" border =\"0\" cellspacing=\"0\" cellpadding=\"6\">\n");
            stringBuffer.append("<tr bgcolor=\"#5A4DBD\" valign=\"bottom\">\n");
            stringBuffer.append("<td class=\"default-body\" height=\"60\" bgcolor=\"#5A4DBD\"><font color=\"#FFFFFF\">\n");
            stringBuffer.append("<b>");
            stringBuffer.append("Sun ONE Application Server").append(" - ");
            stringBuffer.append(sm.getString("errorReportValve.errorReport", String.valueOf(n)));
            stringBuffer.append("</b>\n");
            stringBuffer.append("</td>\n</tr>\n");
            stringBuffer.append("<tr>\n<td class=\"default-body\">\n");
            stringBuffer.append(string2);
            stringBuffer.append("</td>\n</tr>\n");
            stringBuffer.append("</table>\n");
            stringBuffer.append("</td>\n</tr>\n");
            stringBuffer.append("<tr bgcolor=\"#e4e4e4\">\n");
            stringBuffer.append("<td>\n");
            stringBuffer.append("<table cellspacing=\"10\" cellpadding=\"0\" border=\"0\" bgcolor=\"#e4e4e4\">\n");
            stringBuffer.append("<tr>\n<td class=\"default-body\"><b>Type: ");
            stringBuffer.append("</b>\n");
            if (throwable != null) {
                stringBuffer.append(sm.getString("errorReportValve.exceptionReport"));
            } else {
                stringBuffer.append(sm.getString("errorReportValve.statusReport"));
            }
            stringBuffer.append("<br><br>\n");
            stringBuffer.append("<b>");
            stringBuffer.append(sm.getString("errorReportValve.message")).append(": ");
            stringBuffer.append("</b>");
            stringBuffer.append(string);
            stringBuffer.append("<br>\n");
            if (throwable != null) {
                writer = new StringWriter();
                throwable.printStackTrace(new PrintWriter(writer));
                stringBuffer.append("<p>\n<b>");
                stringBuffer.append(sm.getString("errorReportValve.exception"));
                stringBuffer.append("</b>\n<pre>");
                stringBuffer.append(((StringWriter)writer).toString());
                stringBuffer.append("</pre>\n</p>\n");
                stringBuffer.append("<br>\n");
                if (throwable2 != null) {
                    writer = new StringWriter();
                    throwable2.printStackTrace(new PrintWriter(writer));
                    stringBuffer.append("\n<b>");
                    stringBuffer.append(sm.getString("errorReportValve.rootCause"));
                    stringBuffer.append("</b>\n<pre>");
                    stringBuffer.append(((StringWriter)writer).toString());
                    stringBuffer.append("</pre>\n</p>\n");
                    stringBuffer.append("<br>\n");
                }
            }
            stringBuffer.append("</td>\n</tr>\n");
            stringBuffer.append("</table>\n");
            stringBuffer.append("</td>\n</tr>\n");
            stringBuffer.append("</table>\n");
            stringBuffer.append("</body></html>\n");
            try {
                block19: {
                    writer = response.getReporter();
                    if (writer == null) break block18;
                    try {
                        httpServletResponse.setContentType("text/html");
                    }
                    catch (Throwable throwable4) {
                        if (this.debug < 1) break block19;
                        this.log("status.setContentType", throwable4);
                    }
                }
                writer.write(stringBuffer.toString());
                writer.flush();
            }
            catch (IOException iOException) {
            }
            catch (IllegalStateException illegalStateException) {}
        }
    }

    protected void log(String string) {
        Logger logger = this.container.getLogger();
        if (logger != null) {
            logger.log(this.toString() + ": " + string);
        } else {
            System.out.println(this.toString() + ": " + string);
        }
    }

    protected void log(String string, Throwable throwable) {
        Logger logger = this.container.getLogger();
        if (logger != null) {
            logger.log(this.toString() + ": " + string, throwable);
        } else {
            System.out.println(this.toString() + ": " + string);
            throwable.printStackTrace(System.out);
        }
    }
}

