/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.session;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Session;
import org.apache.catalina.Store;
import org.apache.catalina.session.ManagerBase;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.util.LifecycleSupport;

public abstract class PersistentManagerBase
extends ManagerBase
implements Lifecycle,
PropertyChangeListener,
Runnable {
    private int checkInterval = 60;
    private static final String info = "PersistentManagerBase/1.0";
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    private int maxActiveSessions = -1;
    protected static String name = "PersistentManagerBase";
    private boolean started = false;
    private Thread thread = null;
    protected boolean threadDone = false;
    private String threadName = "PersistentManagerBase";
    private Store store = null;
    private boolean saveOnRestart = true;
    private int maxIdleBackup = -1;
    private int minIdleSwap = -1;
    private int maxIdleSwap = -1;

    public int getCheckInterval() {
        return this.checkInterval;
    }

    public void setCheckInterval(int n) {
        int n2 = this.checkInterval;
        this.checkInterval = n;
        this.support.firePropertyChange("checkInterval", new Integer(n2), new Integer(this.checkInterval));
    }

    public int getMaxIdleBackup() {
        return this.maxIdleBackup;
    }

    public void setMaxIdleBackup(int n) {
        if (n == this.maxIdleBackup) {
            return;
        }
        int n2 = this.maxIdleBackup;
        this.maxIdleBackup = n;
        this.support.firePropertyChange("maxIdleBackup", new Integer(n2), new Integer(this.maxIdleBackup));
    }

    public int getMaxIdleSwap() {
        return this.maxIdleSwap;
    }

    public void setMaxIdleSwap(int n) {
        if (n == this.maxIdleSwap) {
            return;
        }
        int n2 = this.maxIdleSwap;
        this.maxIdleSwap = n;
        this.support.firePropertyChange("maxIdleSwap", new Integer(n2), new Integer(this.maxIdleSwap));
    }

    public int getMinIdleSwap() {
        return this.minIdleSwap;
    }

    public void setMinIdleSwap(int n) {
        if (this.minIdleSwap == n) {
            return;
        }
        int n2 = this.minIdleSwap;
        this.minIdleSwap = n;
        this.support.firePropertyChange("minIdleSwap", new Integer(n2), new Integer(this.minIdleSwap));
    }

    public void setContainer(Container container) {
        if (this.container != null && this.container instanceof Context) {
            ((Context)this.container).removePropertyChangeListener(this);
        }
        super.setContainer(container);
        if (this.container != null && this.container instanceof Context) {
            this.setMaxInactiveInterval(((Context)this.container).getSessionTimeout() * 60);
            ((Context)this.container).addPropertyChangeListener(this);
        }
    }

    public String getInfo() {
        return info;
    }

    public int getMaxActiveSessions() {
        return this.maxActiveSessions;
    }

    public void setMaxActiveSessions(int n) {
        int n2 = this.maxActiveSessions;
        this.maxActiveSessions = n;
        this.support.firePropertyChange("maxActiveSessions", new Integer(n2), new Integer(this.maxActiveSessions));
    }

    public String getName() {
        return name;
    }

    protected boolean isStarted() {
        return this.started;
    }

    protected void setStarted(boolean bl) {
        this.started = bl;
    }

    public void setStore(Store store) {
        this.store = store;
        store.setManager(this);
    }

    public Store getStore() {
        return this.store;
    }

    public boolean getSaveOnRestart() {
        return this.saveOnRestart;
    }

    public void setSaveOnRestart(boolean bl) {
        if (bl == this.saveOnRestart) {
            return;
        }
        boolean bl2 = this.saveOnRestart;
        this.saveOnRestart = bl;
        this.support.firePropertyChange("saveOnRestart", new Boolean(bl2), new Boolean(this.saveOnRestart));
    }

    public void clearStore() {
        if (this.store == null) {
            return;
        }
        try {
            this.store.clear();
        }
        catch (IOException iOException) {
            this.log("Exception clearing the Store: " + iOException);
            iOException.printStackTrace();
        }
    }

    public void processPersistenceChecks() {
        this.processMaxIdleSwaps();
        this.processMaxActiveSwaps();
        this.processMaxIdleBackups();
    }

    public Session createSession() {
        if (this.maxActiveSessions >= 0 && this.sessions.size() >= this.maxActiveSessions) {
            throw new IllegalStateException(ManagerBase.sm.getString("standardManager.createSession.ise"));
        }
        return super.createSession();
    }

    public Session findSession(String string) throws IOException {
        Session session = super.findSession(string);
        if (session != null) {
            return session;
        }
        session = this.swapIn(string);
        return session;
    }

    public void load() {
        this.recycled.clear();
        this.sessions.clear();
        if (this.store == null) {
            return;
        }
        String[] stringArray = null;
        try {
            stringArray = this.store.keys();
        }
        catch (IOException iOException) {
            this.log("Can't load sessions from store, " + iOException.getMessage(), iOException);
            return;
        }
        int n = stringArray.length;
        if (n == 0) {
            return;
        }
        if (this.debug >= 1) {
            this.log(ManagerBase.sm.getString("persistentManager.loading", String.valueOf(n)));
        }
        int n2 = 0;
        while (n2 < n) {
            try {
                this.swapIn(stringArray[n2]);
            }
            catch (IOException iOException) {
                this.log("Failed load session from store, " + iOException.getMessage(), iOException);
            }
            ++n2;
        }
    }

    public void remove(Session session) {
        block2: {
            super.remove(session);
            if (this.store == null) break block2;
            try {
                this.store.remove(session.getId());
            }
            catch (IOException iOException) {
                this.log("Exception removing session  " + iOException.getMessage());
                iOException.printStackTrace();
            }
        }
    }

    public void unload() {
        if (this.store == null) {
            return;
        }
        Session[] sessionArray = this.findSessions();
        int n = sessionArray.length;
        if (n == 0) {
            return;
        }
        if (this.debug >= 1) {
            this.log(ManagerBase.sm.getString("persistentManager.unloading", String.valueOf(n)));
        }
        int n2 = 0;
        while (n2 < n) {
            try {
                this.swapOut(sessionArray[n2]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++n2;
        }
    }

    protected Session swapIn(String string) throws IOException {
        if (this.store == null) {
            return null;
        }
        Session session = null;
        try {
            session = this.store.load(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.log(ManagerBase.sm.getString("persistentManager.deserializeError", string, classNotFoundException));
            throw new IllegalStateException(ManagerBase.sm.getString("persistentManager.deserializeError", string, classNotFoundException));
        }
        if (session == null) {
            return null;
        }
        if (!session.isValid()) {
            this.log("session swapped in is invalid or expired");
            session.expire();
            this.store.remove(string);
            return null;
        }
        if (this.debug > 2) {
            this.log(ManagerBase.sm.getString("persistentManager.swapIn", string));
        }
        session.setManager(this);
        this.add(session);
        ((StandardSession)session).activate();
        return session;
    }

    protected void swapOut(Session session) throws IOException {
        if (this.store == null || !session.isValid()) {
            return;
        }
        ((StandardSession)session).passivate();
        this.writeSession(session);
        super.remove(session);
        session.recycle();
    }

    protected void writeSession(Session session) throws IOException {
        if (this.store == null || !session.isValid()) {
            return;
        }
        try {
            this.store.save(session);
        }
        catch (IOException iOException) {
            this.log(ManagerBase.sm.getString("persistentManager.serializeError", session.getId(), iOException));
            throw iOException;
        }
    }

    public void addLifecycleListener(LifecycleListener lifecycleListener) {
        this.lifecycle.addLifecycleListener(lifecycleListener);
    }

    public void removeLifecycleListener(LifecycleListener lifecycleListener) {
        this.lifecycle.removeLifecycleListener(lifecycleListener);
    }

    public void start() throws LifecycleException {
        if (this.debug >= 1) {
            this.log("Starting");
        }
        if (this.started) {
            throw new LifecycleException(ManagerBase.sm.getString("standardManager.alreadyStarted"));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        if (this.debug >= 1) {
            this.log("Force random number initialization starting");
        }
        String string = this.generateSessionId();
        if (this.debug >= 1) {
            this.log("Force random number initialization completed");
        }
        if (this.store == null) {
            this.log("No Store configured, persistence disabled");
        } else if (this.store instanceof Lifecycle) {
            ((Lifecycle)((Object)this.store)).start();
        }
        this.threadStart();
    }

    public void stop() throws LifecycleException {
        if (this.debug >= 1) {
            this.log("Stopping");
        }
        if (!this.isStarted()) {
            throw new LifecycleException(ManagerBase.sm.getString("standardManager.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.setStarted(false);
        this.threadStop();
        if (this.getStore() != null && this.saveOnRestart) {
            this.unload();
        } else {
            Session[] sessionArray = this.findSessions();
            int n = 0;
            while (n < sessionArray.length) {
                StandardSession standardSession = (StandardSession)sessionArray[n];
                if (standardSession.isValid()) {
                    standardSession.expire();
                }
                ++n;
            }
        }
        if (this.getStore() != null && this.getStore() instanceof Lifecycle) {
            ((Lifecycle)((Object)this.getStore())).stop();
        }
        this.random = null;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        block3: {
            if (!(propertyChangeEvent.getSource() instanceof Context)) {
                return;
            }
            Context context = (Context)propertyChangeEvent.getSource();
            if (!propertyChangeEvent.getPropertyName().equals("sessionTimeout")) break block3;
            try {
                this.setMaxInactiveInterval((Integer)propertyChangeEvent.getNewValue() * 60);
            }
            catch (NumberFormatException numberFormatException) {
                this.log(ManagerBase.sm.getString("standardManager.sessionTimeout", propertyChangeEvent.getNewValue().toString()));
            }
        }
    }

    protected void processExpires() {
        if (!this.started) {
            return;
        }
        long l = System.currentTimeMillis();
        Session[] sessionArray = this.findSessions();
        int n = 0;
        while (n < sessionArray.length) {
            StandardSession standardSession = (StandardSession)sessionArray[n];
            if (!standardSession.isValid()) {
                standardSession.expire();
            }
            ++n;
        }
    }

    protected void processMaxIdleSwaps() {
        if (!this.isStarted() || this.maxIdleSwap < 0) {
            return;
        }
        Session[] sessionArray = this.findSessions();
        long l = System.currentTimeMillis();
        if (this.maxIdleSwap >= 0) {
            int n = 0;
            while (n < sessionArray.length) {
                int n2;
                StandardSession standardSession = (StandardSession)sessionArray[n];
                if (standardSession.isValid() && (n2 = (int)((l - standardSession.getLastAccessedTime()) / 1000L)) > this.maxIdleSwap && n2 > this.minIdleSwap) {
                    if (this.debug > 1) {
                        this.log(ManagerBase.sm.getString("persistentManager.swapMaxIdle", standardSession.getId(), new Integer(n2)));
                    }
                    try {
                        this.swapOut(standardSession);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                ++n;
            }
        }
    }

    protected void processMaxActiveSwaps() {
        if (!this.isStarted() || this.getMaxActiveSessions() < 0) {
            return;
        }
        Session[] sessionArray = this.findSessions();
        if (this.getMaxActiveSessions() >= sessionArray.length) {
            return;
        }
        if (this.debug > 0) {
            this.log(ManagerBase.sm.getString("persistentManager.tooManyActive", new Integer(sessionArray.length)));
        }
        int n = sessionArray.length - this.getMaxActiveSessions();
        long l = System.currentTimeMillis();
        int n2 = 0;
        while (n2 < sessionArray.length && n > 0) {
            int n3 = (int)((l - sessionArray[n2].getLastAccessedTime()) / 1000L);
            if (n3 > this.minIdleSwap) {
                if (this.debug > 1) {
                    this.log(ManagerBase.sm.getString("persistentManager.swapTooManyActive", sessionArray[n2].getId(), new Integer(n3)));
                }
                try {
                    this.swapOut(sessionArray[n2]);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                --n;
            }
            ++n2;
        }
    }

    protected void processMaxIdleBackups() {
        if (!this.isStarted() || this.maxIdleBackup < 0) {
            return;
        }
        Session[] sessionArray = this.findSessions();
        long l = System.currentTimeMillis();
        if (this.maxIdleBackup >= 0) {
            int n = 0;
            while (n < sessionArray.length) {
                int n2;
                StandardSession standardSession = (StandardSession)sessionArray[n];
                if (standardSession.isValid() && (n2 = (int)((l - standardSession.getLastAccessedTime()) / 1000L)) > this.maxIdleBackup) {
                    if (this.debug > 1) {
                        this.log(ManagerBase.sm.getString("persistentManager.backupMaxIdle", standardSession.getId(), new Integer(n2)));
                    }
                    try {
                        this.writeSession(standardSession);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                ++n;
            }
        }
    }

    protected void threadSleep() {
        try {
            Thread.sleep((long)this.checkInterval * 1000L);
        }
        catch (InterruptedException interruptedException) {}
    }

    protected void threadStart() {
        if (this.thread != null) {
            return;
        }
        this.threadDone = false;
        this.threadName = "StandardManager[" + this.container.getName() + "]";
        this.thread = new Thread((Runnable)this, this.threadName);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    protected void threadStop() {
        if (this.thread == null) {
            return;
        }
        this.threadDone = true;
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.thread = null;
    }

    public void run() {
        while (!this.threadDone) {
            this.threadSleep();
            this.processExpires();
            this.processPersistenceChecks();
        }
    }
}

