/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.catalina.Contained;
import org.apache.catalina.Container;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Logger;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Valve;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;

public class StandardPipeline
implements Pipeline,
Contained,
Lifecycle {
    protected Valve basic = null;
    protected Container container = null;
    protected int debug = 0;
    protected String info = "org.apache.catalina.core.StandardPipeline/1.0";
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    protected static StringManager sm = StringManager.getManager("org.apache.catalina.core");
    protected boolean started = false;
    protected Valve[] valves = new Valve[0];

    public StandardPipeline() {
        this(null);
    }

    public StandardPipeline(Container container) {
        this.setContainer(container);
    }

    public String getInfo() {
        return this.info;
    }

    public Container getContainer() {
        return this.container;
    }

    public void setContainer(Container container) {
        this.container = container;
    }

    public void addLifecycleListener(LifecycleListener lifecycleListener) {
        this.lifecycle.addLifecycleListener(lifecycleListener);
    }

    public void removeLifecycleListener(LifecycleListener lifecycleListener) {
        this.lifecycle.removeLifecycleListener(lifecycleListener);
    }

    public synchronized void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(sm.getString("standardPipeline.alreadyStarted"));
        }
        this.started = true;
        int n = 0;
        while (n < this.valves.length) {
            if (this.valves[n] instanceof Lifecycle) {
                ((Lifecycle)((Object)this.valves[n])).start();
            }
            ++n;
        }
        if (this.basic != null && this.basic instanceof Lifecycle) {
            ((Lifecycle)((Object)this.basic)).start();
        }
        this.lifecycle.fireLifecycleEvent("start", null);
    }

    public synchronized void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(sm.getString("standardPipeline.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        if (this.basic != null && this.basic instanceof Lifecycle) {
            ((Lifecycle)((Object)this.basic)).stop();
        }
        int n = 0;
        while (n < this.valves.length) {
            if (this.valves[n] instanceof Lifecycle) {
                ((Lifecycle)((Object)this.valves[n])).stop();
            }
            ++n;
        }
    }

    public Valve getBasic() {
        return this.basic;
    }

    public void setBasic(Valve valve) {
        Valve valve2 = this.basic;
        if (valve2 == valve) {
            return;
        }
        if (valve2 != null) {
            if (this.started && valve2 instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)valve2)).stop();
                }
                catch (LifecycleException lifecycleException) {
                    this.log("StandardPipeline.setBasic: stop", lifecycleException);
                }
            }
            if (valve2 instanceof Contained) {
                try {
                    ((Contained)((Object)valve2)).setContainer(null);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        if (valve == null) {
            return;
        }
        if (valve instanceof Contained) {
            ((Contained)((Object)valve)).setContainer(this.container);
        }
        if (valve instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)valve)).start();
            }
            catch (LifecycleException lifecycleException) {
                this.log("StandardPipeline.setBasic: start", lifecycleException);
                return;
            }
        }
        this.basic = valve;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addValve(Valve valve) {
        if (valve instanceof Contained) {
            ((Contained)((Object)valve)).setContainer(this.container);
        }
        if (this.started && valve instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)valve)).start();
            }
            catch (LifecycleException lifecycleException) {
                this.log("StandardPipeline.addValve: start: ", lifecycleException);
            }
        }
        Valve[] valveArray = this.valves;
        synchronized (this.valves) {
            Valve[] valveArray2 = new Valve[this.valves.length + 1];
            System.arraycopy(this.valves, 0, valveArray2, 0, this.valves.length);
            valveArray2[this.valves.length] = valve;
            this.valves = valveArray2;
            // ** MonitorExit[var2_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Valve[] getValves() {
        if (this.basic == null) {
            return this.valves;
        }
        Valve[] valveArray = this.valves;
        synchronized (this.valves) {
            Valve[] valveArray2 = new Valve[this.valves.length + 1];
            System.arraycopy(this.valves, 0, valveArray2, 0, this.valves.length);
            valveArray2[this.valves.length] = this.basic;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return valveArray2;
        }
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        if (this.valves.length > 0 || this.basic != null) {
            int n = 1;
            int n2 = 0;
            while (n2 < this.valves.length) {
                n = this.valves[n2].invoke(request, response);
                if (n != 1) break;
                ++n2;
            }
            if (n == 1 && this.basic != null) {
                this.basic.invoke(request, response);
                this.basic.postInvoke(request, response);
            }
            int n3 = n2 - 1;
            while (n3 >= 0) {
                this.valves[n3].postInvoke(request, response);
                --n3;
            }
        } else {
            throw new ServletException(sm.getString("standardPipeline.noValve"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeValve(Valve valve) {
        Valve[] valveArray = this.valves;
        synchronized (this.valves) {
            block13: {
                int n = -1;
                int n2 = 0;
                while (n2 < this.valves.length) {
                    if (valve == this.valves[n2]) {
                        n = n2;
                        break;
                    }
                    ++n2;
                }
                if (n < 0) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
                Valve[] valveArray2 = new Valve[this.valves.length - 1];
                int n3 = 0;
                int n4 = 0;
                while (n4 < this.valves.length) {
                    if (n4 != n) {
                        valveArray2[n3++] = this.valves[n4];
                    }
                    ++n4;
                }
                this.valves = valveArray2;
                try {
                    if (valve instanceof Contained) {
                        ((Contained)((Object)valve)).setContainer(null);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (!this.started || !(valve instanceof Lifecycle)) break block13;
                try {
                    ((Lifecycle)((Object)valve)).stop();
                }
                catch (LifecycleException lifecycleException) {
                    this.log("StandardPipeline.removeValve: stop: ", lifecycleException);
                }
            }
            return;
        }
    }

    protected void log(String string) {
        Logger logger = null;
        if (this.container != null) {
            logger = this.container.getLogger();
        }
        if (logger != null) {
            logger.log("StandardPipeline[" + this.container.getName() + "]: " + string);
        } else {
            System.out.println("StandardPipeline[" + this.container.getName() + "]: " + string);
        }
    }

    protected void log(String string, Throwable throwable) {
        Logger logger = null;
        if (this.container != null) {
            logger = this.container.getLogger();
        }
        if (logger != null) {
            logger.log("StandardPipeline[" + this.container.getName() + "]: " + string, throwable);
        } else {
            System.out.println("StandardPipeline[" + this.container.getName() + "]: " + string);
            throwable.printStackTrace(System.out);
        }
    }
}

