/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.catalina.util.Enumerator;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.StringManager;

class ApplicationHttpRequest
extends HttpServletRequestWrapper {
    protected static final String[] specials = new String[]{"javax.servlet.include.request_uri", "javax.servlet.include.context_path", "javax.servlet.include.servlet_path", "javax.servlet.include.path_info", "javax.servlet.include.query_string"};
    protected HashMap attributes = new HashMap();
    protected String contextPath = null;
    protected static final String info = "org.apache.catalina.core.ApplicationHttpRequest/1.0";
    protected Map parameters = new HashMap();
    protected String queryParamString = null;
    protected boolean parsed = false;
    protected String pathInfo = null;
    protected String queryString = null;
    protected String requestURI = null;
    protected String servletPath = null;
    protected static StringManager sm = StringManager.getManager("org.apache.catalina.core");

    public ApplicationHttpRequest(HttpServletRequest httpServletRequest) {
        super(httpServletRequest);
        this.setRequest(httpServletRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String string) {
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            return this.attributes.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getAttributeNames() {
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            return new Enumerator(new ArrayList(this.attributes.keySet()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String string) {
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            this.attributes.remove(string);
            if (!this.isSpecial(string)) {
                this.getRequest().removeAttribute(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String string, Object object) {
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            this.attributes.put(string, object);
            if (!this.isSpecial(string)) {
                this.getRequest().setAttribute(string, object);
            }
        }
    }

    public String getContextPath() {
        return this.contextPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getParameter(String string) {
        this.parseParameters();
        Map map = this.parameters;
        synchronized (map) {
            Object v = this.parameters.get(string);
            if (v == null) {
                return null;
            }
            if (v instanceof String[]) {
                return ((String[])v)[0];
            }
            if (v instanceof String) {
                return (String)v;
            }
            return v.toString();
        }
    }

    public Map getParameterMap() {
        this.parseParameters();
        return this.parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getParameterNames() {
        this.parseParameters();
        Map map = this.parameters;
        synchronized (map) {
            return new Enumerator(new ArrayList(this.parameters.keySet()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getParameterValues(String string) {
        this.parseParameters();
        Map map = this.parameters;
        synchronized (map) {
            Object v = this.parameters.get(string);
            if (v == null) {
                return null;
            }
            if (v instanceof String[]) {
                return (String[])v;
            }
            if (v instanceof String) {
                String[] stringArray = new String[]{(String)v};
                return stringArray;
            }
            String[] stringArray = new String[]{v.toString()};
            return stringArray;
        }
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public String getInfo() {
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map copyMap(Map map) {
        if (map == null) {
            return new HashMap();
        }
        HashMap hashMap = new HashMap();
        Map map2 = map;
        synchronized (map2) {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                hashMap.put(string, map.get(string));
            }
        }
        return hashMap;
    }

    void setQueryParams(String string) {
        this.queryParamString = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mergeParameters() {
        if (this.queryParamString == null || this.queryParamString.length() < 1) {
            return;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String string = this.getCharacterEncoding();
        if (string == null) {
            string = "ISO-8859-1";
        }
        try {
            RequestUtil.parseParameters(hashMap, this.queryParamString, string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Map map = this.parameters;
        synchronized (map) {
            Iterator iterator = this.parameters.keySet().iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                Object v = hashMap.get(string2);
                if (v == null) {
                    hashMap.put(string2, this.parameters.get(string2));
                    continue;
                }
                hashMap.put(string2, this.mergeValues(v, this.parameters.get(string2)));
            }
            this.parameters = hashMap;
        }
    }

    void setContextPath(String string) {
        this.contextPath = string;
    }

    void setPathInfo(String string) {
        this.pathInfo = string;
    }

    void setQueryString(String string) {
        this.queryString = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setRequest(HttpServletRequest httpServletRequest) {
        super.setRequest((ServletRequest)httpServletRequest);
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            this.attributes.clear();
            Enumeration enumeration = httpServletRequest.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (this.isSpecial(string)) continue;
                Object object = httpServletRequest.getAttribute(string);
                this.attributes.put(string, object);
            }
        }
        this.contextPath = httpServletRequest.getContextPath();
        this.pathInfo = httpServletRequest.getPathInfo();
        this.queryString = httpServletRequest.getQueryString();
        this.requestURI = httpServletRequest.getRequestURI();
        this.servletPath = httpServletRequest.getServletPath();
    }

    void setRequestURI(String string) {
        this.requestURI = string;
    }

    void setServletPath(String string) {
        this.servletPath = string;
    }

    protected boolean isSpecial(String string) {
        int n = 0;
        while (n < specials.length) {
            if (specials[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected String[] mergeValues(Object object, Object object2) {
        int n;
        String[] stringArray;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (object != null) {
            if (object instanceof String) {
                arrayList.add(object);
            } else if (object instanceof String[]) {
                stringArray = (String[])object;
                n = 0;
                while (n < stringArray.length) {
                    arrayList.add(stringArray[n]);
                    ++n;
                }
            } else {
                arrayList.add(object.toString());
            }
        }
        if (object2 != null) {
            if (object2 instanceof String) {
                arrayList.add(object2);
            } else if (object2 instanceof String[]) {
                stringArray = (String[])object2;
                n = 0;
                while (n < stringArray.length) {
                    arrayList.add(stringArray[n]);
                    ++n;
                }
            } else {
                arrayList.add(object2.toString());
            }
        }
        stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseParameters() {
        if (this.parsed) {
            return;
        }
        Map map = this.parameters;
        synchronized (map) {
            this.parameters = this.copyMap(this.getRequest().getParameterMap());
        }
        this.mergeParameters();
        this.parsed = true;
    }
}

