/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.CosTransactions;

import com.sun.jts.CosTransactions.CoordinatorImpl;
import com.sun.jts.CosTransactions.CoordinatorLog;
import com.sun.jts.CosTransactions.GlobalTID;
import com.sun.jts.CosTransactions.RecoveryManager;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.RecoveryCoordinator;
import org.omg.CosTransactions.RecoveryCoordinatorHelper;
import org.omg.CosTransactions.SubtransactionAwareResource;
import org.omg.CosTransactions.SubtransactionAwareResourceHelper;

class SuperiorInfo {
    Long localTID = null;
    GlobalTID globalTID = null;
    Coordinator superior = null;
    RecoveryCoordinator recovery = null;
    SubtransactionAwareResource resource = null;
    private CoordinatorLog logRecord = null;
    private java.lang.Object logSection = null;
    private int resyncRetries = 0;
    private static final String LOG_SECTION_NAME = "SI";

    SuperiorInfo() {
    }

    SuperiorInfo(Long l, GlobalTID globalTID, Coordinator coordinator, CoordinatorLog coordinatorLog) {
        this.localTID = l;
        this.globalTID = globalTID;
        this.superior = coordinator;
        this.recovery = null;
        this.resource = null;
        this.logRecord = coordinatorLog;
        this.resyncRetries = 0;
        if (coordinatorLog != null) {
            this.logSection = coordinatorLog.createSection(LOG_SECTION_NAME);
            coordinatorLog.addData(this.logSection, globalTID.toBytes());
        }
    }

    public void finalize() {
        if (this.superior != null) {
            this.superior._release();
        }
        if (this.recovery != null) {
            this.recovery._release();
        }
        this.localTID = null;
        this.globalTID = null;
        this.superior = null;
        this.recovery = null;
        this.resource = null;
    }

    void reconstruct(CoordinatorLog coordinatorLog, CoordinatorImpl coordinatorImpl) {
        block5: {
            this.superior = null;
            this.logSection = coordinatorLog.createSection(LOG_SECTION_NAME);
            byte[][] byArray = coordinatorLog.getData(this.logSection);
            this.globalTID = new GlobalTID(byArray[0]);
            this.localTID = coordinatorLog.localTID;
            this.logRecord = coordinatorLog;
            this.resyncRetries = 0;
            RecoveryManager.addCoordinator(this.globalTID, this.localTID, coordinatorImpl, 0);
            java.lang.Object[] objectArray = coordinatorLog.getObjects(this.logSection);
            try {
                if (objectArray.length > 1) {
                    if (((Object)objectArray[0])._is_a(RecoveryCoordinatorHelper.id())) {
                        ObjectImpl objectImpl = (ObjectImpl)objectArray[0];
                        String[] stringArray = objectImpl._ids();
                        ObjectImpl objectImpl2 = (ObjectImpl)objectArray[1];
                        stringArray = objectImpl2._ids();
                        this.recovery = RecoveryCoordinatorHelper.narrow((Object)objectArray[0]);
                        this.resource = SubtransactionAwareResourceHelper.narrow((Object)objectArray[1]);
                    } else {
                        this.recovery = RecoveryCoordinatorHelper.narrow((Object)objectArray[1]);
                        this.resource = SubtransactionAwareResourceHelper.narrow((Object)objectArray[0]);
                    }
                    break block5;
                }
                this.recovery = null;
                this.resource = null;
            }
            catch (Throwable throwable) {}
        }
    }

    void setRecovery(RecoveryCoordinator recoveryCoordinator) {
        if (this.recovery == null) {
            this.recovery = recoveryCoordinator;
            if (this.logRecord != null) {
                this.logRecord.addObject(this.logSection, recoveryCoordinator);
            }
        }
    }

    void setResource(SubtransactionAwareResource subtransactionAwareResource) {
        if (this.resource == null) {
            this.resource = subtransactionAwareResource;
            if (this.logRecord != null) {
                this.logRecord.addObject(this.logSection, subtransactionAwareResource);
            }
        }
    }

    int resyncRetries() {
        int n = this.resyncRetries++;
        return n;
    }
}

