/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.CosTransactions;

import com.sun.jts.CosTransactions.Configuration;
import com.sun.jts.CosTransactions.CoordinatorImpl;
import com.sun.jts.CosTransactions.GlobalTID;
import com.sun.jts.CosTransactions.OrphanRollbackThread;
import com.sun.jts.CosTransactions.RecoveryManager;
import com.sun.jts.utils.LogFormatter;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CosTransactions.HeuristicCommit;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.NotPrepared;
import org.omg.CosTransactions.RecoveryCoordinator;
import org.omg.CosTransactions.RecoveryCoordinatorHelper;
import org.omg.CosTransactions.RecoveryCoordinatorPOA;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.Status;
import org.omg.PortableServer.POA;

class RecoveryCoordinatorImpl
extends RecoveryCoordinatorPOA {
    private static boolean recoverable = false;
    private static POA poa = null;
    private RecoveryCoordinator thisRef = null;
    private int internalSeq = 0;
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.transaction");
    GlobalTID globalTID = null;

    RecoveryCoordinatorImpl(GlobalTID globalTID, int n) {
        this.globalTID = globalTID;
        this.internalSeq = n;
    }

    public void finalize() {
        this.globalTID = null;
        this.internalSeq = 0;
    }

    public Status replay_completion(Resource resource) throws NotPrepared {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.logp(Level.FINE, "RecoveryCoordinatorImpl", "replay_completion()", "replay_completion on Resource:" + resource);
        }
        Status status = Status.StatusRolledBack;
        CoordinatorImpl coordinatorImpl = RecoveryManager.getCoordinator(this.globalTID);
        if (coordinatorImpl != null) {
            try {
                status = coordinatorImpl.get_status();
            }
            catch (SystemException systemException) {
                // empty catch block
            }
        }
        switch (status.value()) {
            case 0: 
            case 1: {
                try {
                    coordinatorImpl.rollback_only();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw new NotPrepared();
            }
            case 2: {
                status = Status.StatusUnknown;
                break;
            }
            case 8: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                if (coordinatorImpl != null) break;
                if (!Configuration.getProxyChecker().isProxy(resource)) {
                    this.rollbackOrphan(resource);
                    break;
                }
                try {
                    OrphanRollbackThread orphanRollbackThread = new OrphanRollbackThread(this, (Resource)resource._duplicate());
                    orphanRollbackThread.start();
                }
                catch (SystemException systemException) {}
                break;
            }
            default: {
                status = Status.StatusRolledBack;
            }
        }
        return status;
    }

    void rollbackOrphan(Resource resource) {
        block2: {
            try {
                resource.rollback();
            }
            catch (Throwable throwable) {
                if (!(throwable instanceof HeuristicCommit) && !(throwable instanceof HeuristicMixed) && !(throwable instanceof HeuristicHazard)) break block2;
                _logger.log(Level.WARNING, "jts.heuristic_exception", throwable.toString());
            }
        }
        resource._release();
    }

    RecoveryCoordinatorImpl(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length - 4];
        System.arraycopy(byArray, 4, byArray2, 0, byArray2.length);
        this.globalTID = new GlobalTID(byArray2);
        RecoveryManager.waitForRecovery();
    }

    final synchronized RecoveryCoordinator object() {
        if (this.thisRef == null) {
            if (poa == null) {
                poa = Configuration.getPOA("RecoveryCoordinator");
                recoverable = Configuration.isRecoverable();
            }
            try {
                if (recoverable && this.globalTID != null) {
                    byte[] byArray = this.globalTID.toBytes();
                    byte[] byArray2 = new byte[byArray.length + 4];
                    System.arraycopy(byArray, 0, byArray2, 4, byArray.length);
                    byArray2[0] = (byte)this.internalSeq;
                    byArray2[1] = (byte)(this.internalSeq >> 8);
                    byArray2[2] = (byte)(this.internalSeq >> 16);
                    byArray2[3] = (byte)(this.internalSeq >> 24);
                    poa.activate_object_with_id(byArray2, this);
                    Object object = poa.create_reference_with_id(byArray2, RecoveryCoordinatorHelper.id());
                    this.thisRef = RecoveryCoordinatorHelper.narrow(object);
                } else {
                    poa.activate_object(this);
                    Object object = poa.servant_to_reference(this);
                    this.thisRef = RecoveryCoordinatorHelper.narrow(object);
                }
            }
            catch (Exception exception) {
                _logger.log(Level.SEVERE, "jts.create_recoverycoordinator_error");
                String string = LogFormatter.getLocalizedMessage(_logger, "jts.create_recoverycoordinator_error");
                throw new INTERNAL(string);
            }
        }
        return this.thisRef;
    }

    final synchronized void destroy() {
        try {
            if (poa != null && this.thisRef != null) {
                poa.deactivate_object(poa.reference_to_id(this.thisRef));
                this.thisRef = null;
            } else {
                POA pOA = null;
                pOA = poa == null ? Configuration.getPOA("RecoveryCoordinator") : poa;
                if (this.thisRef == null) {
                    pOA.deactivate_object(pOA.servant_to_id(this));
                } else {
                    pOA.deactivate_object(pOA.reference_to_id(this.thisRef));
                    this.thisRef = null;
                }
            }
        }
        catch (Exception exception) {
            _logger.log(Level.WARNING, "jts.object_destroy_error", "RecoveryCoordinator");
        }
        this.finalize();
    }
}

