/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbAbstractDescriptor;
import com.sun.enterprise.deployment.EjbExternalDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.JmsDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.MailConfiguration;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.xml.ApplicationClientNode;
import com.sun.enterprise.deployment.xml.ApplicationClientRuntimeDescriptorNode;
import com.sun.enterprise.deployment.xml.XMLUtils;
import com.sun.enterprise.resource.ResourcePrincipal;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.NiceProperties;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.crimson.tree.XmlDocument;
import org.w3c.dom.Document;

public class ApplicationClientPropertiesFileConverter {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.util");
    private static String APPLICATION_CLIENT = "appclient";
    private static String NAME = ".name";
    private static String DESCRIPTION = ".description";
    private static String CALLBACK_HANDLER = ".callbackHandler";
    private static String SMALL_ICON = ".smallIcon";
    private static String LARGE_ICON = ".largeIcon";
    private static String ENVIRONMENT_PROPERTIES = ".#environmentProperties";
    private static String ENVIRONMENT_PROPERTY = "environmentProperty";
    private static String VALUE = ".value";
    private static String TYPE = ".type";
    private static String IS_EJB_REFERENCE = ".isEjbReference";
    private static String EJB_NAME = ".ejbName";
    private static String EJB_LINK = ".ejbLink";
    private static String IS_EJB_LINK = ".isEjbLink";
    private static String EJB_HOME = ".homeInterface";
    private static String EJB_REMOTE = ".remoteInterface";
    private static String IS_RESOURCE_REFERENCE = ".isResourceReference";
    private static String IS_JMS_DESTINATION_REF = ".isJmsDestinationReference";
    private static String IS_RESOURCE_ENV_REF = ".isResourceEnvReference";
    private static String AUTHORIZATION = ".authorization";
    private static String DEFAULT_DB_ACCOUNT = ".defaultDBAccount";
    private static String MAIL_CONFIGURATION = ".mailConfiguration";
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$util$ApplicationClientPropertiesFileConverter == null ? (class$com$sun$enterprise$util$ApplicationClientPropertiesFileConverter = ApplicationClientPropertiesFileConverter.class$("com.sun.enterprise.util.ApplicationClientPropertiesFileConverter")) : class$com$sun$enterprise$util$ApplicationClientPropertiesFileConverter);
    static /* synthetic */ Class class$com$sun$enterprise$util$ApplicationClientPropertiesFileConverter;

    public void convert(Properties properties, File file, File file2) throws IOException {
        ApplicationClientDescriptor applicationClientDescriptor = new ApplicationClientDescriptor();
        XmlDocument xmlDocument = null;
        Object var6_6 = null;
        applicationClientDescriptor.setName(properties.getProperty(APPLICATION_CLIENT + NAME));
        applicationClientDescriptor.setDescription(properties.getProperty(APPLICATION_CLIENT + DESCRIPTION));
        applicationClientDescriptor.setCallbackHandler(properties.getProperty(APPLICATION_CLIENT + CALLBACK_HANDLER));
        int n = Integer.parseInt(properties.getProperty(APPLICATION_CLIENT + ENVIRONMENT_PROPERTIES));
        int n2 = 0;
        while (n2 < n) {
            Object object;
            Descriptor descriptor;
            String string = properties.getProperty(ENVIRONMENT_PROPERTY + n2 + NAME);
            String string2 = properties.getProperty(ENVIRONMENT_PROPERTY + n2 + VALUE);
            if (string == null) {
                throw new IOException("Bad envProps count or envProps key");
            }
            if ("true".equals(properties.getProperty(ENVIRONMENT_PROPERTY + n2 + IS_RESOURCE_REFERENCE))) {
                descriptor = new ResourceReferenceDescriptor(string, "", properties.getProperty(ENVIRONMENT_PROPERTY + n2 + TYPE));
                ((ResourceReferenceDescriptor)descriptor).setJndiName(string2);
                object = properties.getProperty(ENVIRONMENT_PROPERTY + n2 + AUTHORIZATION);
                ((ResourceReferenceDescriptor)descriptor).setAuthorization((String)object);
                if (ResourceReferenceDescriptor.CONTAINER_AUTHORIZATION.equals(object)) {
                    Serializable serializable;
                    StringTokenizer stringTokenizer;
                    if (properties.getProperty(ENVIRONMENT_PROPERTY + n2 + DEFAULT_DB_ACCOUNT) != null) {
                        stringTokenizer = new StringTokenizer(properties.getProperty(ENVIRONMENT_PROPERTY + n2 + DEFAULT_DB_ACCOUNT), ",");
                        serializable = new ResourcePrincipal(stringTokenizer.nextToken(), stringTokenizer.nextToken());
                        ((ResourceReferenceDescriptor)descriptor).setResourcePrincipal((ResourcePrincipal)serializable);
                    }
                    if (properties.getProperty(ENVIRONMENT_PROPERTY + n2 + MAIL_CONFIGURATION) != null) {
                        stringTokenizer = new StringTokenizer(properties.getProperty(ENVIRONMENT_PROPERTY + n2 + MAIL_CONFIGURATION), ",");
                        serializable = new MailConfiguration(stringTokenizer.nextToken(), stringTokenizer.nextToken(), stringTokenizer.nextToken());
                        ((ResourceReferenceDescriptor)descriptor).setMailConfiguration((MailConfiguration)serializable);
                    }
                }
                applicationClientDescriptor.addResourceReferenceDescriptor((ResourceReferenceDescriptor)descriptor);
            } else if ("true".equals(properties.getProperty(ENVIRONMENT_PROPERTY + n2 + IS_EJB_REFERENCE))) {
                descriptor = new EjbExternalDescriptor();
                descriptor.setName(properties.getProperty(ENVIRONMENT_PROPERTY + n2 + EJB_NAME));
                ((EjbAbstractDescriptor)descriptor).setHomeClassName(properties.getProperty(ENVIRONMENT_PROPERTY + n2 + EJB_HOME));
                ((EjbAbstractDescriptor)descriptor).setRemoteClassName(properties.getProperty(ENVIRONMENT_PROPERTY + n2 + EJB_REMOTE));
                ((EjbExternalDescriptor)descriptor).setType(properties.getProperty(ENVIRONMENT_PROPERTY + n2 + TYPE));
                if ("true".equals(properties.getProperty(ENVIRONMENT_PROPERTY + n2 + IS_EJB_LINK))) {
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "Adding internal UNRESOLVED reference ");
                    }
                    ((EjbExternalDescriptor)descriptor).setLinkName(properties.getProperty(ENVIRONMENT_PROPERTY + n2 + EJB_LINK));
                }
                object = new EjbReferenceDescriptor(string, "", (EjbAbstractDescriptor)descriptor);
                ((EjbReferenceDescriptor)object).setJndiName(string2);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "adding ejb reference descriptor " + object);
                }
                applicationClientDescriptor.addEjbReferenceDescriptor((EjbReferenceDescriptor)object);
            } else if ("true".equals(properties.getProperty(ENVIRONMENT_PROPERTY + n2 + IS_JMS_DESTINATION_REF)) || "true".equals(properties.getProperty(ENVIRONMENT_PROPERTY + n2 + IS_RESOURCE_ENV_REF))) {
                if ("true".equals(properties.getProperty(ENVIRONMENT_PROPERTY + n2 + IS_JMS_DESTINATION_REF))) {
                    _logger.log(Level.WARNING, "enterprise_util.isjmsdestinationreference_deprec");
                }
                descriptor = new JmsDestinationReferenceDescriptor(string, "", properties.getProperty(ENVIRONMENT_PROPERTY + n2 + TYPE));
                ((JmsDestinationReferenceDescriptor)descriptor).setJndiName(string2);
                applicationClientDescriptor.addJmsDestinationReferenceDescriptor((JmsDestinationReferenceDescriptor)descriptor);
            } else {
                descriptor = new EnvironmentProperty(string, string2, "", properties.getProperty(ENVIRONMENT_PROPERTY + n2 + TYPE));
                applicationClientDescriptor.addEnvironmentProperty((EnvironmentProperty)descriptor);
            }
            ++n2;
        }
        xmlDocument = ApplicationClientNode.getDocument(applicationClientDescriptor);
        XMLUtils.writeDocumentToFile((Document)xmlDocument, file);
        xmlDocument = ApplicationClientRuntimeDescriptorNode.getDocument(applicationClientDescriptor);
        XMLUtils.writeDocumentToFile((Document)xmlDocument, file2);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 3) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, localStrings.getLocalString("appclient.prop.converter.usage", ""));
            }
            System.exit(1);
        }
        File file = new File(stringArray[0]);
        File file2 = new File(stringArray[1]);
        File file3 = new File(stringArray[2]);
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            NiceProperties niceProperties = new NiceProperties();
            niceProperties.load(fileInputStream);
            ApplicationClientPropertiesFileConverter applicationClientPropertiesFileConverter = new ApplicationClientPropertiesFileConverter();
            applicationClientPropertiesFileConverter.convert(niceProperties, file2, file3);
        }
        catch (Exception exception) {
            System.exit(1);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

