/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.distributedtx;

import com.sun.enterprise.distributedtx.J2EETransactionManagerOpt;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.util.Utility;
import com.sun.logging.LogDomains;
import java.util.Vector;
import java.util.logging.Logger;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public final class J2EETransaction
implements Transaction {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.jta");
    protected static final boolean debug = false;
    private static long txIdCounter = 1L;
    private long txId;
    private J2EEXid xid;
    private J2EETransactionManagerOpt j2eeTM;
    private Transaction jtsTx;
    private ResourceHandle nonXAResource;
    private int localTxStatus;
    private Vector syncs = new Vector();
    private boolean commitStarted = false;
    private long startTime;
    private static final byte[] bqual = new byte[]{0};

    J2EETransaction(J2EETransactionManagerOpt j2EETransactionManagerOpt) {
        this.txId = J2EETransaction.getNewTxId();
        this.xid = new J2EEXid(this.txId);
        this.j2eeTM = j2EETransactionManagerOpt;
        this.localTxStatus = 0;
        this.startTime = System.currentTimeMillis();
    }

    J2EETransaction(J2EETransactionManagerOpt j2EETransactionManagerOpt, Transaction transaction) {
        this(j2EETransactionManagerOpt);
        this.jtsTx = transaction;
    }

    private static synchronized long getNewTxId() {
        long l = txIdCounter++;
        return l;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof J2EETransaction) {
            J2EETransaction j2EETransaction = (J2EETransaction)object;
            return this.txId == j2EETransaction.txId;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.txId;
    }

    Xid getLocalXid() {
        return this.xid;
    }

    ResourceHandle getNonXAResource() {
        return this.nonXAResource;
    }

    void setNonXAResource(ResourceHandle resourceHandle) {
        this.nonXAResource = resourceHandle;
    }

    boolean isLocalTx() {
        return this.jtsTx == null;
    }

    void setJTSTx(Transaction transaction) throws RollbackException, SystemException {
        this.jtsTx = transaction;
        if (!this.commitStarted) {
            int n = 0;
            while (n < this.syncs.size()) {
                transaction.registerSynchronization((Synchronization)this.syncs.elementAt(n));
                ++n;
            }
        }
    }

    Transaction getJTSTx() {
        return this.jtsTx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        this.commitStarted = true;
        if (this.jtsTx != null) {
            try {
                this.jtsTx.commit();
                var2_1 = null;
                this.j2eeTM.clearThreadTx();
            }
            catch (Throwable var1_7) {
                var2_2 = null;
                this.j2eeTM.clearThreadTx();
                throw var1_7;
            }
        }
        try {
            if (this.isRollbackOnly()) {
                if (this.nonXAResource != null) {
                    this.nonXAResource.getXAResource().rollback(this.xid);
                }
                this.localTxStatus = 4;
                throw new RollbackException("Transaction marked for rollback");
            }
            var1_8 = 0;
            while (var1_8 < this.syncs.size()) {
                try {
                    var2_3 = (Synchronization)this.syncs.elementAt(var1_8);
                    var2_3.beforeCompletion();
                }
                catch (Exception var2_4) {
                    // empty catch block
                }
                ++var1_8;
            }
            if (this.isRollbackOnly()) {
                if (this.nonXAResource != null) {
                    this.nonXAResource.getXAResource().rollback(this.xid);
                }
                this.localTxStatus = 4;
                throw new RollbackException("Transaction marked for rollback");
            }
            if (this.jtsTx != null) {
                this.jtsTx.commit();
                this.localTxStatus = 3;
            }
            if (this.nonXAResource != null) {
                this.nonXAResource.getXAResource().commit(this.xid, true);
            }
            this.localTxStatus = 3;
        }
        catch (RollbackException var1_9) {
            this.localTxStatus = 4;
            throw var1_9;
        }
        catch (SystemException var2_6) {
            this.localTxStatus = 4;
            throw var2_6;
        }
        catch (Exception var3_10) {
            this.localTxStatus = 4;
            throw new SystemException(var3_10.toString());
        }
        finally {
            this.j2eeTM.clearThreadTx();
            var5_12 = 0;
            ** while (var5_12 < this.syncs.size())
        }
lbl-1000:
        // 1 sources

        {
            try {
                var6_13 = (Synchronization)this.syncs.elementAt(var5_12);
                var6_13.afterCompletion(this.localTxStatus);
            }
            catch (Exception var6_14) {
                // empty catch block
            }
            ++var5_12;
            continue;
        }
lbl63:
        // 1 sources

        throw var4_11;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void rollback() throws IllegalStateException, SystemException {
        try {
            if (this.jtsTx != null) {
                this.jtsTx.rollback();
            }
            if (this.nonXAResource != null) {
                this.nonXAResource.getXAResource().rollback(this.xid);
            }
            this.localTxStatus = 4;
        }
        catch (Exception var1_2) {
            this.localTxStatus = 4;
        }
        finally {
            this.j2eeTM.clearThreadTx();
            if (this.jtsTx != null) return;
            var2_5 = 0;
            ** while (var2_5 < this.syncs.size())
        }
lbl-1000:
        // 1 sources

        {
            try {
                var3_6 = (Synchronization)this.syncs.elementAt(var2_5);
                var3_6.afterCompletion(4);
            }
            catch (Exception var3_7) {
                // empty catch block
            }
            ++var2_5;
            continue;
        }
lbl23:
        // 1 sources

    }

    public boolean delistResource(XAResource xAResource, int n) throws IllegalStateException, SystemException {
        if (this.jtsTx != null) {
            return this.jtsTx.delistResource(xAResource, n);
        }
        throw new IllegalStateException("J2EETransaction.delistResource called for local tx");
    }

    public boolean enlistResource(XAResource xAResource) throws RollbackException, IllegalStateException, SystemException {
        if (this.jtsTx != null) {
            return this.jtsTx.enlistResource(xAResource);
        }
        if (this.nonXAResource != null) {
            throw new IllegalStateException("Local transaction already has 1 non-XA Resource: cannot add more resources");
        }
        this.j2eeTM.startJTSTx(this);
        return this.jtsTx.enlistResource(xAResource);
    }

    public int getStatus() throws SystemException {
        if (this.jtsTx != null) {
            return this.jtsTx.getStatus();
        }
        return this.localTxStatus;
    }

    public void registerSynchronization(Synchronization synchronization) throws RollbackException, IllegalStateException, SystemException {
        if (this.jtsTx != null) {
            this.jtsTx.registerSynchronization(synchronization);
        } else {
            this.syncs.add(synchronization);
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        if (this.jtsTx != null) {
            this.jtsTx.setRollbackOnly();
        } else {
            this.localTxStatus = 1;
        }
    }

    private boolean isRollbackOnly() throws IllegalStateException, SystemException {
        int n = this.jtsTx != null ? this.jtsTx.getStatus() : this.localTxStatus;
        return n == 1;
    }

    public String toString() {
        return "J2EETransaction: txId=" + this.txId + " nonXAResource=" + this.nonXAResource + " jtsTx=" + this.jtsTx + " localTxStatus=" + this.localTxStatus + " syncs=" + this.syncs;
    }

    public String getTransactionId() {
        return this.xid.toString();
    }

    public long getStartTime() {
        return this.startTime;
    }

    private class J2EEXid
    implements Xid {
        private static final int formatId = 987654321;
        private byte[] gtrId = new byte[8];
        private String stringForm = null;

        J2EEXid(long l) {
            Utility.longToBytes(l, this.gtrId, 0);
        }

        public int getFormatId() {
            return 987654321;
        }

        public byte[] getGlobalTransactionId() {
            return this.gtrId;
        }

        public byte[] getBranchQualifier() {
            return bqual;
        }

        public String toString() {
            int n;
            int n2;
            if (this.stringForm != null) {
                return this.stringForm;
            }
            char[] cArray = new char[this.gtrId.length * 2 + 3];
            int n3 = 0;
            int n4 = this.gtrId.length;
            int n5 = 0;
            while (n5 < n4) {
                n2 = (this.gtrId[n5] & 0xF0) >> 4;
                n = this.gtrId[n5] & 0xF;
                cArray[n3++] = (char)(n2 + (n2 > 9 ? 55 : 48));
                cArray[n3++] = (char)(n + (n > 9 ? 55 : 48));
                ++n5;
            }
            cArray[n3++] = 95;
            n2 = 0;
            n = 0;
            cArray[n3++] = (char)(n2 + (n2 > 9 ? 55 : 48));
            cArray[n3++] = (char)(n + (n > 9 ? 55 : 48));
            this.stringForm = new String(cArray);
            return this.stringForm;
        }
    }
}

