/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.JarClassLoader;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class FileContentsDescriptor {
    private static final char ClassSeparatorChar = '.';
    private static final String ArchSeparator = "/";
    private static final char ArchSeparatorChar = '/';
    private static final String FileSeparator = File.separator;
    private static final char FileSeparatorChar = File.separatorChar;
    private Hashtable rawFileDirectoryMap = new Hashtable();
    private Hashtable fileDirectoryMap = new Hashtable();
    private Set libraryJars = new HashSet();

    public FileContentsDescriptor() {
    }

    public FileContentsDescriptor(String string, Vector vector) {
        File file = new File(string);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (e instanceof File) {
                this.fileDirectoryMap.put(e, file);
                continue;
            }
            File file2 = new File((String)e);
            this.fileDirectoryMap.put(file2, file);
        }
    }

    public FileContentsDescriptor(FileContentsDescriptor fileContentsDescriptor) {
        this.addAll(fileContentsDescriptor);
    }

    public void addLibraryJar(File file) {
        this.getLibraryJars().add(new File(file.getAbsolutePath()));
    }

    public void removeLibraryJar(File file) {
        this.getLibraryJars().remove(new File(file.getAbsolutePath()));
    }

    public Set getLibraryJars() {
        if (this.libraryJars == null) {
            this.libraryJars = new HashSet();
        }
        return this.libraryJars;
    }

    public void removeFile(File file) {
        this.fileDirectoryMap.remove(file);
    }

    public void removeEntry(String string) {
        this.rawFileDirectoryMap.remove(string);
        this.removeFile(FileContentsDescriptor.FileEntry(string));
    }

    public void add(File file, File file2) {
        this.fileDirectoryMap.put(file, file2);
    }

    public void addEntry(String string, File file) {
        this.rawFileDirectoryMap.put(string, file);
    }

    public void addEntries(Hashtable hashtable) {
        if (hashtable != null) {
            this.rawFileDirectoryMap.putAll(hashtable);
        }
    }

    public void addAll(FileContentsDescriptor fileContentsDescriptor) {
        this.addFiles(fileContentsDescriptor);
        this.libraryJars.addAll(fileContentsDescriptor.libraryJars);
    }

    public void addFiles(FileContentsDescriptor fileContentsDescriptor) {
        this.fileDirectoryMap.putAll(fileContentsDescriptor.fileDirectoryMap);
        this.rawFileDirectoryMap.putAll(fileContentsDescriptor.rawFileDirectoryMap);
    }

    public Enumeration getFiles() {
        return this.fileDirectoryMap.keys();
    }

    public Enumeration getEntries() {
        return this.rawFileDirectoryMap.keys();
    }

    public Set getFilesSet() {
        Object object;
        HashSet<Object> hashSet = new HashSet<Object>();
        Enumeration enumeration = this.getFiles();
        while (enumeration.hasMoreElements()) {
            object = (File)enumeration.nextElement();
            hashSet.add(object);
        }
        object = this.getEntries();
        while (object.hasMoreElements()) {
            String string = (String)object.nextElement();
            hashSet.add(FileContentsDescriptor.FileEntry(string));
        }
        return hashSet;
    }

    public Set getClassNamesSet() {
        Object object;
        HashSet<String> hashSet = new HashSet<String>();
        Enumeration enumeration = this.getFiles();
        while (enumeration.hasMoreElements()) {
            object = (File)enumeration.nextElement();
            if (!((File)object).toString().endsWith(".class")) continue;
            hashSet.add(FileUtil.classNameFromFile((File)object));
        }
        object = this.getEntries();
        while (object.hasMoreElements()) {
            String string = (String)object.nextElement();
            if (!string.endsWith(".class")) continue;
            String string2 = string.replace('/', '.');
            hashSet.add(string2.substring(0, string2.lastIndexOf(".class")));
        }
        return hashSet;
    }

    public Iterator getDirectories() {
        HashSet<Object> hashSet = new HashSet<Object>();
        Enumeration enumeration = this.fileDirectoryMap.elements();
        while (enumeration.hasMoreElements()) {
            hashSet.add(enumeration.nextElement());
        }
        Enumeration enumeration2 = this.getEntries();
        while (enumeration2.hasMoreElements()) {
            String string = (String)enumeration2.nextElement();
            File file = this.getDirectoryFor(string);
            if (hashSet.contains(file)) continue;
            hashSet.add(file);
        }
        return hashSet.iterator();
    }

    public File getDirectoryFor(File file) {
        Object v = this.fileDirectoryMap.get(file);
        if (v == null) {
            return null;
        }
        return (File)v;
    }

    public File getDirectoryFor(String string) {
        File file = (File)this.rawFileDirectoryMap.get(string);
        if (file == null) {
            return this.getDirectoryFor(FileContentsDescriptor.FileEntry(string));
        }
        String string2 = file.toString();
        if (string2.endsWith(string.replace('/', FileSeparatorChar))) {
            String string3 = string2.substring(0, string2.length() - string.length());
            if (string3.endsWith(FileSeparator)) {
                string3 = string3.substring(0, string3.length() - 1);
            }
            return new File(string3);
        }
        return file.getParentFile();
    }

    public File getFullFileFor(File file) {
        Object v = this.fileDirectoryMap.get(file);
        if (v == null) {
            return null;
        }
        if (((File)v).toString().equals("")) {
            return new File(file.toString());
        }
        return new File((File)v, file.toString());
    }

    public File getFileFor(String string) {
        File file = (File)this.rawFileDirectoryMap.get(string);
        if (file == null) {
            file = this.getFullFileFor(FileContentsDescriptor.FileEntry(string));
        }
        return file;
    }

    protected JarClassLoader getClassLoaderInstance() {
        return new JarClassLoader();
    }

    public ClassLoader getClassLoader() throws IOException {
        Object object;
        Object object2;
        Serializable serializable;
        JarClassLoader jarClassLoader = this.getClassLoaderInstance();
        Iterator iterator = this.getDirectories();
        while (iterator.hasNext()) {
            serializable = (File)iterator.next();
            jarClassLoader.addJar(((File)serializable).getAbsolutePath());
        }
        serializable = new HashSet(this.getLibraryJars());
        Iterator iterator2 = this.getFilesSet().iterator();
        while (iterator2.hasNext()) {
            object2 = (File)iterator2.next();
            object = ((File)object2).toString();
            if (!((String)object).toLowerCase().endsWith(".jar")) continue;
            ((HashSet)serializable).add(this.getFileFor((String)object));
        }
        object2 = ((HashSet)serializable).iterator();
        while (object2.hasNext()) {
            object = (File)object2.next();
            jarClassLoader.addJar(((File)object).getAbsolutePath());
        }
        return jarClassLoader;
    }

    public Hashtable getEntryNameMap() {
        Hashtable<String, File> hashtable = new Hashtable<String, File>();
        Enumeration enumeration = this.getFiles();
        while (enumeration.hasMoreElements()) {
            File file = (File)enumeration.nextElement();
            hashtable.put(FileContentsDescriptor.StringEntry(file), this.getFullFileFor(file));
        }
        hashtable.putAll(this.rawFileDirectoryMap);
        return hashtable;
    }

    public String toString() {
        return this.fileDirectoryMap.toString();
    }

    private static File FileEntry(String string) {
        return new File(string.replace('/', FileSeparatorChar));
    }

    private static String StringEntry(File file) {
        return file.toString().replace(FileSeparatorChar, '/');
    }
}

