/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.Archivist;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.JmsDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.NamedReferencePair;
import com.sun.enterprise.deployment.OrderedSet;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.Roles;
import com.sun.enterprise.security.acl.Role;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public abstract class BundleDescriptor
extends Descriptor
implements Roles {
    private Application application;
    private transient Archivist archivist;
    private Set roles;

    public void setApplication(Application application) {
        this.application = application;
    }

    public Archivist getArchivist() {
        if (this.archivist == null) {
            this.archivist = this.getDefaultArchivist();
        }
        return this.archivist;
    }

    public void setArchivist(Archivist archivist) {
        this.archivist = archivist;
    }

    protected abstract Archivist getDefaultArchivist();

    void addBundleDescriptor(BundleDescriptor bundleDescriptor) {
        this.getRoles().addAll(bundleDescriptor.getRoles());
        this.changed();
    }

    public Application getApplication() {
        return this.application;
    }

    public Set getRoles() {
        if (this.roles == null) {
            this.roles = new OrderedSet();
        }
        return this.roles;
    }

    public void addRole(Role role) {
        this.getRoles().add(role);
        this.changed();
    }

    public void removeRole(Role role) {
        this.getRoles().remove(role);
        this.changed();
    }

    protected Collection getNamedDescriptorsFrom(JndiNameEnvironment jndiNameEnvironment) {
        Object object;
        Object object2;
        Vector<Object> vector = new Vector<Object>();
        Iterator iterator = jndiNameEnvironment.getResourceReferenceDescriptors().iterator();
        while (iterator.hasNext()) {
            object2 = (ResourceReferenceDescriptor)iterator.next();
            vector.add(object2);
        }
        object2 = jndiNameEnvironment.getEjbReferenceDescriptors().iterator();
        while (object2.hasNext()) {
            object = (EjbReferenceDescriptor)object2.next();
            vector.add(object);
        }
        object = jndiNameEnvironment.getJmsDestinationReferenceDescriptors().iterator();
        while (object.hasNext()) {
            JmsDestinationReferenceDescriptor jmsDestinationReferenceDescriptor = (JmsDestinationReferenceDescriptor)object.next();
            vector.add(jmsDestinationReferenceDescriptor);
        }
        return vector;
    }

    protected Vector getNamedReferencePairsFrom(JndiNameEnvironment jndiNameEnvironment) {
        Object object;
        Object object2;
        Vector<NamedReferencePair> vector = new Vector<NamedReferencePair>();
        Iterator iterator = jndiNameEnvironment.getResourceReferenceDescriptors().iterator();
        while (iterator.hasNext()) {
            object2 = (ResourceReferenceDescriptor)iterator.next();
            vector.add(NamedReferencePair.createResourceRefPair((Descriptor)((Object)jndiNameEnvironment), (ResourceReferenceDescriptor)object2));
        }
        object2 = jndiNameEnvironment.getEjbReferenceDescriptors().iterator();
        while (object2.hasNext()) {
            object = (EjbReferenceDescriptor)object2.next();
            vector.add(NamedReferencePair.createEjbRefPair((Descriptor)((Object)jndiNameEnvironment), (EjbReferenceDescriptor)object));
        }
        object = jndiNameEnvironment.getJmsDestinationReferenceDescriptors().iterator();
        while (object.hasNext()) {
            JmsDestinationReferenceDescriptor jmsDestinationReferenceDescriptor = (JmsDestinationReferenceDescriptor)object.next();
            vector.add(NamedReferencePair.createResourceEnvRefPair((Descriptor)((Object)jndiNameEnvironment), jmsDestinationReferenceDescriptor));
        }
        return vector;
    }

    public String toString() {
        String string = "Bundle Descriptor";
        string = string + "\n" + super.toString();
        string = string + "\n " + this.roles;
        return string;
    }
}

