/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers.util.pool;

import com.sun.ejb.containers.ContainerFactoryImpl;
import com.sun.ejb.containers.util.pool.ObjectFactory;
import com.sun.ejb.containers.util.pool.Pool;
import com.sun.ejb.containers.util.pool.PoolException;
import com.sun.logging.LogDomains;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractPool
implements Pool {
    protected static Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.ejb");
    protected ArrayList list;
    protected ObjectFactory factory = null;
    protected int waitCount = 0;
    protected int createdCount = 0;
    protected int steadyPoolSize;
    protected int resizeQuantity = 1;
    protected int maxPoolSize = Integer.MAX_VALUE;
    protected long maxWaitTimeInMillis;
    protected int idleTimeoutInSeconds;
    private AbstractPoolTimerTask poolTimerTask;
    protected ClassLoader containerClassLoader;
    protected int destroyedCount = 0;
    protected int poolSuccess = 0;
    protected String poolName;
    protected int poolReturned = 0;

    protected AbstractPool() {
    }

    protected AbstractPool(ObjectFactory objectFactory, int n, int n2, int n3, long l, int n4) {
        this.initializePool(objectFactory, n, n2, n3, l, n4);
    }

    protected void initializePool(ObjectFactory objectFactory, int n, int n2, int n3, long l, int n4) {
        block4: {
            this.list = new ArrayList();
            this.factory = objectFactory;
            this.steadyPoolSize = n;
            this.resizeQuantity = n2;
            this.maxPoolSize = n3;
            this.maxWaitTimeInMillis = l;
            this.idleTimeoutInSeconds = n4;
            if (n > 0) {
                int n5 = 0;
                while (n5 < n) {
                    this.list.add(objectFactory.create(null));
                    ++this.createdCount;
                    ++n5;
                }
            }
            this.containerClassLoader = this.getClass().getClassLoader();
            if (this.idleTimeoutInSeconds <= 0) break block4;
            try {
                this.poolTimerTask = new AbstractPoolTimerTask();
                ContainerFactoryImpl.getTimer().scheduleAtFixedRate((TimerTask)this.poolTimerTask, n4 * 1000, (long)(n4 * 1000));
            }
            catch (Throwable throwable) {
                _logger.log(Level.WARNING, "[AbstractPool]: Could not add AbstractPoolTimerTask ... Continuing anyway...");
            }
        }
    }

    public void setContainerClassLoader(ClassLoader classLoader) {
        this.containerClassLoader = classLoader;
    }

    public Object getObject(boolean bl, Object object) throws PoolException {
        return this.getObject(object);
    }

    public Object getObject(long l, Object object) throws PoolException {
        return this.getObject(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(Object object) throws PoolException {
        long l = 0L;
        long l2 = 0L;
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            block13: {
                block14: {
                    do {
                        int n;
                        if ((n = this.list.size()) > 0) {
                            ++this.poolSuccess;
                            return this.list.remove(n - 1);
                        }
                        if (this.createdCount - this.destroyedCount < this.maxPoolSize) {
                            ++this.createdCount;
                            break block13;
                        }
                        if (this.maxWaitTimeInMillis < 0L) break block14;
                        ++this.waitCount;
                        l = System.currentTimeMillis();
                        try {
                            _logger.log(Level.INFO, "[AbstractPool]: Waiting on the pool to get a bean instance...");
                            this.list.wait(this.maxWaitTimeInMillis);
                        }
                        catch (InterruptedException interruptedException) {
                            throw new PoolException("Thread interrupted.", interruptedException);
                        }
                        --this.waitCount;
                        l2 += System.currentTimeMillis() - l;
                        n = this.list.size();
                        if (n <= 0) continue;
                        ++this.poolSuccess;
                        return this.list.remove(n - 1);
                    } while (this.maxWaitTimeInMillis == 0L || l2 < this.maxWaitTimeInMillis);
                    throw new PoolException("Pool Instance not obtained within given time interval.");
                }
                throw new PoolException("Pool Instance not obtained within given time interval.");
            }
        }
        try {
            return this.factory.create(object);
        }
        catch (Exception exception) {
            ArrayList arrayList2 = this.list;
            synchronized (arrayList2) {
                --this.createdCount;
            }
            throw new RuntimeException("Caught Exception when trying to create pool Object ", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnObject(Object object) {
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            this.list.add(object);
            ++this.poolReturned;
            if (this.waitCount > 0) {
                this.list.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyObject(Object object) {
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            ++this.destroyedCount;
            if (this.waitCount > 0) {
                this.list.notify();
            }
        }
        try {
            this.factory.destroy(object);
        }
        catch (Exception exception) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void preload(int n) {
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            int n2 = 0;
            while (n2 < n) {
                try {
                    this.list.add(this.factory.create(null));
                    ++this.createdCount;
                }
                catch (PoolException poolException) {
                    _logger.log(Level.FINE, "Exception in preload()", poolException);
                }
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            if (this.poolTimerTask != null) {
                try {
                    this.poolTimerTask.cancel();
                    _logger.log(Level.WARNING, "[AbstractPool]: Cancelled pool timer task  at: " + new Date());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            _logger.log(Level.FINE, "[AbstractPool]: Destroying " + this.list.size() + " beans from the pool...");
            Object[] objectArray = this.list.toArray();
            int n = 0;
            while (n < objectArray.length) {
                try {
                    ++this.destroyedCount;
                    try {
                        this.factory.destroy(objectArray[n]);
                    }
                    catch (Throwable throwable) {}
                }
                catch (Throwable throwable) {
                    _logger.log(Level.WARNING, "[AbstractPool]: Error while destroying: " + throwable);
                }
                ++n;
            }
            _logger.log(Level.FINE, "[AbstractPool]: Pool closed....");
            this.list = new ArrayList();
        }
        this.list = null;
        this.factory = null;
        this.poolTimerTask = null;
        this.containerClassLoader = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(int n) {
        int n2;
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = this.list;
        synchronized (arrayList2) {
            n2 = this.list.size();
            int n3 = 0;
            while (n3 < n && n2 > 0) {
                arrayList.add(this.list.remove(--n2));
                ++this.destroyedCount;
                ++n3;
            }
            this.list.notifyAll();
        }
        n2 = arrayList.size() - 1;
        while (n2 >= 0) {
            this.factory.destroy(arrayList.remove(n2));
            try {
                this.factory.destroy(arrayList.remove(n2));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            --n2;
        }
    }

    protected abstract void removeIdleObjects();

    public int getCreatedCount() {
        return this.createdCount;
    }

    public int getDestroyedCount() {
        return this.destroyedCount;
    }

    public int getPoolSuccess() {
        return this.poolSuccess;
    }

    public int getSize() {
        return this.list.size();
    }

    public int getWaitCount() {
        return this.waitCount;
    }

    public int getSteadyPoolSize() {
        return this.steadyPoolSize;
    }

    public int getResizeQuantity() {
        return this.resizeQuantity;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public long getMaxWaitTimeInMillis() {
        return this.maxWaitTimeInMillis;
    }

    public int getIdleTimeoutInSeconds() {
        return this.idleTimeoutInSeconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAllMonitoredAttrbuteValues() {
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            stringBuffer.append("createdCount=").append(this.createdCount).append(";").append("destroyedCount=").append(this.destroyedCount).append(";").append("waitCount=").append(this.waitCount).append(";").append("size=").append(this.list.size()).append(";");
        }
        stringBuffer.append("maxPoolSize=").append(this.maxPoolSize).append(";");
        return stringBuffer.toString();
    }

    public String getAllAttrValues() {
        StringBuffer stringBuffer = new StringBuffer();
        if (null != this.poolName) {
            stringBuffer.append(":").append(this.poolName);
        } else {
            stringBuffer.append(":POOL");
        }
        stringBuffer.append("[FP=").append(this.poolSuccess).append(",").append("TC=").append(this.createdCount).append(",").append("TD=").append(this.destroyedCount).append(",").append("PR=").append(this.poolReturned).append(",").append("TW=").append(this.waitCount).append(",").append("CS=").append(this.list.size()).append(",").append("MS=").append(this.maxPoolSize);
        return stringBuffer.toString();
    }

    private class AbstractPoolTimerTask
    extends TimerTask {
        Object lock;

        AbstractPoolTimerTask() {
        }

        AbstractPoolTimerTask(Object object) {
            this.lock = object;
        }

        public void run() {
            Thread thread = Thread.currentThread();
            ClassLoader classLoader = thread.getContextClassLoader();
            ClassLoader classLoader2 = AbstractPool.this.containerClassLoader;
            try {
                AccessController.doPrivileged(new PrivilegedAction(this, thread, classLoader2){
                    private final /* synthetic */ Thread val$currentThread;
                    private final /* synthetic */ ClassLoader val$ctxClassLoader;
                    private final /* synthetic */ AbstractPoolTimerTask this$1;
                    {
                        this.this$1 = abstractPoolTimerTask;
                        this.val$currentThread = thread;
                        this.val$ctxClassLoader = classLoader;
                    }

                    public Object run() {
                        this.val$currentThread.setContextClassLoader(this.val$ctxClassLoader);
                        return null;
                    }
                });
                try {
                    if (AbstractPool.this.list.size() > AbstractPool.this.steadyPoolSize) {
                        _logger.log(Level.FINE, "[AbstractPool]: Removing idle  objects from pool. Current Size: " + AbstractPool.this.list.size() + "/" + AbstractPool.this.steadyPoolSize + ". Time: " + new Date());
                        AbstractPool.this.removeIdleObjects();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                AccessController.doPrivileged(new PrivilegedAction(this, thread, classLoader){
                    private final /* synthetic */ Thread val$currentThread;
                    private final /* synthetic */ ClassLoader val$previousClassLoader;
                    private final /* synthetic */ AbstractPoolTimerTask this$1;
                    {
                        this.this$1 = abstractPoolTimerTask;
                        this.val$currentThread = thread;
                        this.val$previousClassLoader = classLoader;
                    }

                    public Object run() {
                        this.val$currentThread.setContextClassLoader(this.val$previousClassLoader);
                        return null;
                    }
                });
            }
            catch (Throwable throwable) {}
        }
    }
}

