/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.containers.util.cache.AbstractBeanCache;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public class UnboundedCache
extends AbstractBeanCache {
    protected static final int DEFAULT_CAPACITY = 128;
    protected static final float DEFAULT_LOAD_FACTOR = 0.75f;
    protected static final int MAXIMUM_CAPACITY = 0x100000;
    protected transient Entry[] table;
    protected float loadFactor;
    protected transient int size;
    protected int bucketmask;
    protected int capacity;
    protected int threshold;

    public UnboundedCache() {
        this(128, 0.75f);
    }

    public UnboundedCache(int n) {
        this(n, 0.75f);
    }

    public UnboundedCache(int n, float f) {
        if (n > 0x100000) {
            n = 0x100000;
        }
        if (f <= 0.0f || Float.isNaN(f)) {
            throw new IllegalArgumentException("Illegal load factor: " + f);
        }
        this.capacity = n;
        this.loadFactor = f;
        while (this.capacity < n && this.capacity < 0x100000) {
            this.capacity <<= 1;
        }
        this.threshold = (int)((float)this.capacity * f);
        this.table = new Entry[this.capacity];
        this.bucketmask = this.capacity - 1;
    }

    public boolean contains(Object object) {
        int n = object.hashCode();
        Entry entry = this.table[n & this.bucketmask];
        while (entry != null) {
            if (entry.keyHashCode == n && entry.key.equals(object)) {
                ++this.cacheHits;
                return true;
            }
            entry = entry.next;
        }
        ++this.cacheMisses;
        return false;
    }

    public Object get(Object object) {
        int n = object.hashCode();
        Entry entry = this.table[n & this.bucketmask];
        while (entry != null) {
            if (entry.keyHashCode == n && entry.key.equals(object)) {
                ++this.cacheHits;
                return entry.value;
            }
            entry = entry.next;
        }
        ++this.cacheMisses;
        return null;
    }

    public Object put(Object object, Object object2) {
        int n = object.hashCode();
        int n2 = n & this.bucketmask;
        Entry entry = this.table[n2];
        while (entry != null) {
            if (entry.keyHashCode == n && entry.key.equals(object)) {
                Object object3 = entry.value;
                entry.value = object2;
                return object3;
            }
            entry = entry.next;
        }
        this.table[n2] = new Entry(object, n, object2, this.table[n2]);
        if (this.size++ >= this.threshold) {
            int n3 = 2 * this.capacity;
            Entry[] entryArray = new Entry[n3];
            this.transfer(entryArray);
            this.table = entryArray;
            this.capacity = n3;
            this.threshold = (int)((float)n3 * this.loadFactor);
            this.bucketmask = this.capacity - 1;
        }
        return null;
    }

    protected void transfer(Entry[] entryArray) {
        Entry[] entryArray2 = this.table;
        int n = entryArray.length;
        int n2 = n - 1;
        int n3 = 0;
        while (n3 < entryArray2.length) {
            Entry entry = entryArray2[n3];
            if (entry != null) {
                Entry entry2;
                entryArray2[n3] = null;
                do {
                    entry2 = entry.next;
                    int n4 = entry.keyHashCode & n2;
                    entry.next = entryArray[n4];
                    entryArray[n4] = entry;
                } while ((entry = entry2) != null);
            }
            ++n3;
        }
    }

    public Object remove(Object object) {
        Entry entry;
        int n = object.hashCode();
        int n2 = n & this.bucketmask;
        Entry entry2 = entry = this.table[n2];
        while (entry2 != null) {
            if (entry2.keyHashCode == n && entry2.key.equals(object)) {
                --this.size;
                if (entry == entry2) {
                    this.table[n2] = entry2.next;
                } else {
                    entry.next = entry2.next;
                }
                ++this.cacheHits;
                return entry2.value;
            }
            entry = entry2;
            entry2 = entry2.next;
        }
        ++this.cacheMisses;
        return null;
    }

    public Enumeration elements() {
        Vector<Object> vector = new Vector<Object>();
        int n = 0;
        while (n < this.capacity) {
            Entry entry = this.table[n];
            while (entry != null) {
                vector.addElement(entry.value);
                entry = entry.next;
            }
            ++n;
        }
        return vector.elements();
    }

    public Iterator values() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n < this.capacity) {
            Entry entry = this.table[n];
            while (entry != null) {
                arrayList.add(entry.value);
                entry = entry.next;
            }
            ++n;
        }
        return arrayList.iterator();
    }

    public Iterator keys() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n < this.capacity) {
            Entry entry = this.table[n];
            while (entry != null) {
                arrayList.add(entry.key);
                entry = entry.next;
            }
            ++n;
        }
        return arrayList.iterator();
    }

    public int size() {
        return this.size;
    }

    public void clear() {
    }

    public int getMaxCacheSize() {
        return this.capacity;
    }

    public int getResizeQuantity() {
        return this.numberOfVictimsToSelect;
    }

    public boolean isCacheOverflowAllowed() {
        return this.cacheOverflowTolerated;
    }

    public int getIdleTimeoutInSeconds() {
        return this.idleInCacheTimeoutInSeconds;
    }

    public int getRemovalTimeoutInSeconds() {
        return 0;
    }

    public String getVictimSelectionPolicy() {
        return "nru";
    }

    public int getCacheHits() {
        return this.cacheSuccess;
    }

    public int getCacheMisses() {
        return this.cacheFailures;
    }

    public int getVictimCount() {
        return this.victimCount;
    }

    public void selectVictims() {
    }

    public void passivateIdleBeans() {
    }

    static class Entry {
        public Object key;
        public Object value;
        public int keyHashCode;
        public Entry next;

        public Entry(Object object, Object object2, Entry entry) {
            this.key = object;
            this.keyHashCode = object.hashCode();
            this.value = object2;
            this.next = entry;
        }

        public Entry(Object object, int n, Object object2, Entry entry) {
            this.key = object;
            this.keyHashCode = n;
            this.value = object2;
            this.next = entry;
        }

        public Entry initialize(Object object, Object object2, Entry entry) {
            this.key = object;
            this.keyHashCode = object.hashCode();
            this.value = object2;
            this.next = entry;
            return this;
        }

        public Entry initialize(Object object, int n, Object object2, Entry entry) {
            this.key = object;
            this.keyHashCode = n;
            this.value = object2;
            this.next = entry;
            return this;
        }

        public int hashCode() {
            return this.keyHashCode;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

