/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.containers.StatefulSessionStore;
import com.sun.logging.LogDomains;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SessionFileCacheStore {
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.ejb");
    private File dir;
    private int passivationTimeoutInSeconds;
    private boolean debug = false;
    private Object[] locks;
    private int maxLocks;
    protected ClassLoader containerClassLoader;
    protected StatefulSessionStore sessionStore;

    private void removeFile(File file, boolean bl) {
        final File file2 = file;
        final boolean bl2 = bl;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (bl2) {
                    file2.deleteOnExit();
                } else {
                    file2.delete();
                }
                return null;
            }
        });
    }

    public void undeploy() {
        this.dir = null;
        this.locks = null;
        this.containerClassLoader = null;
        this.sessionStore = null;
    }

    public SessionFileCacheStore(String string, int n) {
        try {
            this.passivationTimeoutInSeconds = n;
            this.dir = new File(string);
            this.dir.mkdirs();
            this.maxLocks = 64;
            this.locks = new Object[this.maxLocks];
            int n2 = 0;
            while (n2 < this.maxLocks) {
                this.locks[n2] = new Object();
                ++n2;
            }
            this.containerClassLoader = this.getClass().getClassLoader();
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "ejb.sessionfile_cachestore_exception", exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] loadState(Long l) throws Exception {
        byte[] byArray2;
        String string = "" + l;
        File file = new File(this.dir, string);
        if (!file.exists()) return null;
        int n = (int)file.length();
        byte[] byArray = new byte[n];
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            int n2 = 0;
            int n3 = n;
            while (true) {
                if (n3 <= 0) {
                    try {
                        bufferedInputStream.close();
                        bufferedInputStream = null;
                    }
                    catch (Exception exception) {
                        _logger.log(Level.WARNING, "[SessionFileCacheStore] loadState(): Exception - ", exception);
                    }
                    break;
                }
                int n4 = bufferedInputStream.read(byArray, n2, n3);
                n2 += n4;
                n3 -= n4;
            }
            this.removeFile(file, false);
            byArray2 = byArray;
            Object var11_13 = null;
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            try {
                if (bufferedInputStream == null) throw throwable;
                bufferedInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {
            // empty catch block
            return byArray2;
        }
        if (bufferedInputStream == null) return byArray2;
        bufferedInputStream.close();
        return byArray2;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveState(Long var1_1, byte[] var2_2) throws Exception {
        var3_3 = null;
        var4_4 = null;
        var5_5 = "" + var1_1;
        try {
            var3_3 = new File(this.dir, var5_5);
            if (var3_3.getName().equals("null")) {
                return;
            }
            if (true) ** GOTO lbl39
        }
        catch (Exception var6_9) {
            try {
                if (var3_3 == null) throw var6_9;
                this.removeFile(var3_3, false);
                throw var6_9;
            }
            catch (Exception var7_10) {
                SessionFileCacheStore._logger.log(Level.WARNING, "[SessionFileCacheStore] saveState(): Exception when deleting file from disk - ", var7_10);
            }
            throw var6_9;
        }
        finally {
            try {
                if (var4_4 != null) {
                    var4_4.close();
                }
            }
            catch (IOException var9_12) {
                SessionFileCacheStore._logger.log(Level.WARNING, "[SessionFileCacheStore] saveState(): Exception on closing file - ", var9_12);
            }
        }
        do {
            try {
                var4_4 = new BufferedOutputStream(new FileOutputStream(var3_3));
            }
            catch (FileNotFoundException var6_7) {
                var4_4 = null;
                if (SessionFileCacheStore._logger.isLoggable(Level.FINE)) {
                    SessionFileCacheStore._logger.log(Level.FINE, "[SessionFileCacheStore] saveState(): BufferedOutputStream equals NULL, retrying.");
                }
                if (SessionFileCacheStore._logger.isLoggable(Level.FINEST)) {
                    SessionFileCacheStore._logger.log(Level.FINEST, "[SessionFileCacheStore] saveState(): BufferedOutputStream equals NULL, Exception: = ", var6_7);
                }
                Thread.sleep(1000L);
            }
lbl39:
            // 3 sources

        } while (var4_4 == null);
        var4_4.write(var2_2, 0, var2_2.length);
        try {
            if (var4_4 == null) return;
            var4_4.close();
            return;
        }
        catch (IOException var6_8) {
            SessionFileCacheStore._logger.log(Level.WARNING, "[SessionFileCacheStore] saveState(): Exception on closing file - ", var6_8);
            return;
        }
    }

    public void cancelTimerTasks() {
    }

    public void removeState(Long l) {
        try {
            this.removeFile(new File(this.dir, "" + l), false);
        }
        catch (Exception exception) {
            _logger.log(Level.WARNING, "[SessionFileCacheStore] removeState(): Exception when deleting file from disk - ", exception);
        }
    }

    protected void setSessionStore(StatefulSessionStore statefulSessionStore) {
        this.sessionStore = statefulSessionStore;
    }
}

