/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.server;

import com.iplanet.ias.config.serverbeans.Applications;
import com.iplanet.ias.config.serverbeans.ElementProperty;
import com.iplanet.ias.config.serverbeans.LifecycleModule;
import com.iplanet.ias.config.serverbeans.ServerBeansFactory;
import com.iplanet.ias.server.ServerContext;
import com.sun.appserv.server.LifecycleListener;
import com.sun.appserv.server.ServerLifecycle;
import com.sun.appserv.server.ServerLifecycleException;
import com.sun.appserv.server.ServerLifecycleModule;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.web.security.RealmAdapter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.catalina.Context;
import org.apache.catalina.core.StandardContext;

public final class LifecycleModuleService
implements ServerLifecycle {
    private ArrayList listeners = new ArrayList();
    private Context invocationContext;

    public synchronized void onInitialization(ServerContext serverContext) throws ServerLifecycleException {
        try {
            Applications applications = ServerBeansFactory.getServerBean(serverContext.getConfigContext()).getApplications();
            LifecycleModule[] lifecycleModuleArray = applications.getLifecycleModule();
            if (lifecycleModuleArray == null) {
                return;
            }
            HashSet<ServerLifecycleModule> hashSet = new HashSet<ServerLifecycleModule>();
            int n = 0;
            while (n < lifecycleModuleArray.length) {
                LifecycleModule lifecycleModule = lifecycleModuleArray[n];
                boolean bl = lifecycleModule.isEnabled();
                if (bl) {
                    int n2 = Integer.MAX_VALUE;
                    String string = lifecycleModule.getLoadOrder();
                    if (string != null) {
                        try {
                            n2 = Integer.parseInt(string);
                        }
                        catch (NumberFormatException numberFormatException) {
                            numberFormatException.printStackTrace();
                        }
                    }
                    ServerLifecycleModule serverLifecycleModule = new ServerLifecycleModule(serverContext, lifecycleModule.getName(), lifecycleModule.getClassName());
                    serverLifecycleModule.setLoadOrder(n2);
                    serverLifecycleModule.setClasspath(lifecycleModule.getClasspath());
                    serverLifecycleModule.setIsFatal(lifecycleModule.isIsFailureFatal());
                    ElementProperty[] elementPropertyArray = lifecycleModule.getElementProperty();
                    if (elementPropertyArray != null) {
                        int n3 = 0;
                        while (n3 < elementPropertyArray.length) {
                            ElementProperty elementProperty = elementPropertyArray[n3];
                            serverLifecycleModule.setProperty(elementProperty.getName(), elementProperty.getValue());
                            ++n3;
                        }
                    }
                    LifecycleListener lifecycleListener = serverLifecycleModule.loadServerLifecycle();
                    hashSet.add(serverLifecycleModule);
                }
                ++n;
            }
            this.sortModules(hashSet);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.initialize(serverContext);
    }

    private void resetClassLoader(final ClassLoader classLoader) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread.currentThread().setContextClassLoader(classLoader);
                return null;
            }
        });
    }

    private void sortModules(HashSet hashSet) {
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            ServerLifecycleModule serverLifecycleModule = (ServerLifecycleModule)iterator.next();
            int n = serverLifecycleModule.getLoadOrder();
            int n2 = 0;
            while (n2 < this.listeners.size()) {
                if (((ServerLifecycleModule)this.listeners.get(n2)).getLoadOrder() > n) break;
                ++n2;
            }
            this.listeners.add(n2, serverLifecycleModule);
        }
    }

    private void initialize(ServerContext serverContext) throws ServerLifecycleException {
        if (this.listeners.isEmpty()) {
            return;
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ServerLifecycleModule serverLifecycleModule = (ServerLifecycleModule)iterator.next();
            serverLifecycleModule.onInitialization(serverContext);
        }
        this.resetClassLoader(classLoader);
    }

    public void onStartup(ServerContext serverContext) throws ServerLifecycleException {
        if (this.listeners.isEmpty()) {
            return;
        }
        this.invocationContext = new StandardContext();
        WebBundleDescriptor webBundleDescriptor = new WebBundleDescriptor();
        webBundleDescriptor.setApplication(new Application());
        this.invocationContext.setRealm(new RealmAdapter(webBundleDescriptor));
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ServerLifecycleModule serverLifecycleModule = (ServerLifecycleModule)iterator.next();
            serverLifecycleModule.onStartup(serverContext, this.invocationContext);
        }
        this.resetClassLoader(classLoader);
    }

    public void onReady(ServerContext serverContext) throws ServerLifecycleException {
        if (this.listeners.isEmpty()) {
            return;
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ServerLifecycleModule serverLifecycleModule = (ServerLifecycleModule)iterator.next();
            serverLifecycleModule.onReady(serverContext);
        }
        this.resetClassLoader(classLoader);
    }

    public void onShutdown() throws ServerLifecycleException {
        if (this.listeners.isEmpty()) {
            return;
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ServerLifecycleModule serverLifecycleModule = (ServerLifecycleModule)iterator.next();
            serverLifecycleModule.onShutdown();
        }
        this.resetClassLoader(classLoader);
    }

    public void onTermination() throws ServerLifecycleException {
        if (this.listeners.isEmpty()) {
            return;
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ServerLifecycleModule serverLifecycleModule = (ServerLifecycleModule)iterator.next();
            serverLifecycleModule.onTermination();
        }
        this.resetClassLoader(classLoader);
    }
}

