/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.web.logger;

import com.iplanet.ias.util.logging.IASLevel;
import com.iplanet.ias.web.logger.LoggerBase;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class IASLogger
extends LoggerBase {
    Logger _logger = null;
    private String _classname;
    private String _methodname;
    protected static final String info = "com.iplanet.ias.web.logger.IASLogger/1.0";

    private IASLogger() {
    }

    public IASLogger(Logger logger) {
        this._logger = logger;
    }

    protected void write(String string, int n) {
        if (this._logger == null) {
            return;
        }
        Level level = Level.INFO;
        if (n == Integer.MIN_VALUE) {
            level = IASLevel.FATAL;
        } else if (n == 1) {
            level = Level.SEVERE;
        } else if (n == 2) {
            level = Level.WARNING;
        } else if (n == 3) {
            level = Level.FINE;
        } else if (n == 4) {
            level = Level.FINER;
        }
        this.inferCaller();
        this._logger.logp(level, this._classname, this._methodname, string);
    }

    private void inferCaller() {
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        this._classname = "";
        this._methodname = "";
        int n = 0;
        while (n < stackTraceElementArray.length) {
            StackTraceElement stackTraceElement = stackTraceElementArray[n];
            this._classname = stackTraceElement.getClassName();
            if (!this._classname.startsWith("com.iplanet.ias.web.logger")) {
                this._methodname = stackTraceElement.getMethodName();
                return;
            }
            ++n;
        }
    }
}

