/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.web;

import com.iplanet.ias.config.ConfigBean;
import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.config.serverbeans.Applications;
import com.iplanet.ias.config.serverbeans.ElementProperty;
import com.iplanet.ias.config.serverbeans.HttpService;
import com.iplanet.ias.config.serverbeans.J2eeApplication;
import com.iplanet.ias.config.serverbeans.LogService;
import com.iplanet.ias.config.serverbeans.Server;
import com.iplanet.ias.config.serverbeans.VirtualServerClass;
import com.iplanet.ias.instance.InstanceEnvironment;
import com.iplanet.ias.server.ApplicationRegistry;
import com.iplanet.ias.server.ServerContext;
import com.iplanet.ias.server.StandaloneWebModulesManager;
import com.iplanet.ias.tools.common.dd.webapp.CookieProperties;
import com.iplanet.ias.tools.common.dd.webapp.SessionConfig;
import com.iplanet.ias.tools.common.dd.webapp.SessionManager;
import com.iplanet.ias.tools.common.dd.webapp.SessionProperties;
import com.iplanet.ias.tools.common.dd.webapp.StoreProperties;
import com.iplanet.ias.tools.common.dd.webapp.SunWebApp;
import com.iplanet.ias.tools.common.dd.webapp.WebProperty;
import com.iplanet.ias.util.StringUtils;
import com.iplanet.ias.util.io.FileUtils;
import com.iplanet.ias.web.EmbeddedWebContainer;
import com.iplanet.ias.web.VirtualServer;
import com.iplanet.ias.web.WebModule;
import com.iplanet.ias.web.WebModuleConfig;
import com.iplanet.ias.web.connector.nsapi.NSAPIConnector;
import com.iplanet.ias.web.connector.nsapi.NSAPIProcessor;
import com.iplanet.ias.web.logger.IASLogger;
import com.iplanet.ias.web.session.PersistenceType;
import com.iplanet.ias.web.session.SessionCookieConfig;
import com.sun.appserv.server.ServerLifecycleException;
import com.sun.enterprise.Switch;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.logging.LogDomains;
import com.sun.web.security.RealmAdapter;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Manager;
import org.apache.catalina.Store;
import org.apache.catalina.Valve;
import org.apache.catalina.authenticator.SingleSignOn;
import org.apache.catalina.connector.RequestBase;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.loader.WebappLoader;
import org.apache.catalina.session.FileStore;
import org.apache.catalina.session.PersistentManager;
import org.apache.catalina.session.PersistentManagerBase;
import org.apache.catalina.session.StandardManager;
import org.apache.catalina.session.StoreBase;
import org.apache.catalina.util.LifecycleSupport;

public final class WebContainer
implements Lifecycle {
    public static final String SSO_ENABLED = "sso-enabled";
    public static final String SSO_MAX_IDLE = "sso-max-inactive-seconds";
    public static final String SSO_REAP_INTERVAL = "sso-reap-interval-seconds";
    public static final String DISPATCHER_MAX_DEPTH = "dispatcher-max-depth";
    private EmbeddedWebContainer _embedded;
    private Engine _engine;
    private ServerContext _serverContext;
    private Server _serverBean;
    private String _id;
    private static Logger _logger = null;
    private static ResourceBundle _rb = null;
    private Level _logLevel;
    private int _debug;
    private String _modulesWorkRoot;
    private String _modulesRoot;
    private String _appsWorkRoot;
    private boolean _reloadingEnabled;
    private int _pollInterval;
    private StandaloneWebModulesManager _reloadManager;
    private LifecycleSupport _lifecycle;
    private boolean _started;
    private static Hashtable _instances = new Hashtable();

    private WebContainer(String string, ServerContext serverContext) {
        block17: {
            this._embedded = null;
            this._engine = null;
            this._serverContext = null;
            this._serverBean = null;
            this._id = null;
            this._logLevel = null;
            this._debug = 0;
            this._modulesWorkRoot = null;
            this._modulesRoot = null;
            this._appsWorkRoot = null;
            this._reloadingEnabled = false;
            this._pollInterval = 2;
            this._reloadManager = null;
            this._lifecycle = new LifecycleSupport(this);
            this._started = false;
            this._id = string;
            this._serverContext = serverContext;
            String string2 = this._serverContext.getInstallRoot();
            String string3 = this._serverContext.getInstanceName();
            InstanceEnvironment instanceEnvironment = new InstanceEnvironment(string2, string3);
            this._modulesWorkRoot = instanceEnvironment.getWebModuleCompileJspPath();
            this._appsWorkRoot = instanceEnvironment.getApplicationCompileJspPath();
            this._modulesRoot = instanceEnvironment.getModuleRepositoryPath();
            if (_logger == null) {
                _logger = LogDomains.getLogger("javax.enterprise.system.container.web");
                _rb = _logger.getResourceBundle();
            }
            try {
                ElementProperty elementProperty;
                this._serverBean = this._serverContext.getConfigBean();
                this.getDynamicReloadingSettings(this._serverBean.getApplications());
                Level level = Level.SEVERE;
                this.setLogLevel(level);
                LogService logService = this._serverBean.getLogService();
                if (logService != null) {
                    try {
                        level = Level.parse(logService.getLevel());
                        this.setLogLevel(level);
                    }
                    catch (NullPointerException nullPointerException) {
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                try {
                    level = Level.parse(this._serverBean.getWebContainer().getLogLevel());
                    this.setLogLevel(level);
                }
                catch (NullPointerException nullPointerException) {
                    if (this._debug > 0) {
                        _logger.finest("Defaulting <web-container> log-level");
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (this._debug > 0) {
                    _logger.fine("Web container log level: " + this._logLevel);
                }
                if ((elementProperty = this._serverBean.getWebContainer().getElementPropertyByName(DISPATCHER_MAX_DEPTH)) == null || elementProperty.getValue() == null) break block17;
                int n = -1;
                try {
                    n = Integer.parseInt(elementProperty.getValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (n > 0) {
                    RequestBase.setMaxDispatchDepth(n);
                    if (this._debug > 0) {
                        _logger.fine("Maximum depth for nested request dispatches set to " + elementProperty.getValue());
                    }
                }
            }
            catch (ConfigException configException) {
                _logger.log(Level.SEVERE, "webcontainer.configError", configException);
            }
        }
        this._embedded = new EmbeddedWebContainer();
        this._embedded.setUseNaming(false);
        if (this._debug > 1) {
            this._embedded.setDebug(this._debug);
        }
        this._embedded.setLogger(new IASLogger(_logger));
        this._engine = this._embedded.createEngine();
        this._embedded.addEngine(this._engine);
    }

    public String getID() {
        return this._id;
    }

    public StandardHost createVS(long l, String string, String string2) {
        Object[] objectArray;
        VirtualServer virtualServer = (VirtualServer)this._embedded.createHost(string, string2);
        virtualServer.setJNIVirtualServer(l);
        com.iplanet.ias.config.serverbeans.VirtualServer virtualServer2 = this.findVirtalServerBean(string);
        if (virtualServer2 != null) {
            if (!this.isSSOEnabled(virtualServer2)) {
                objectArray = new Object[]{virtualServer.getID()};
                _logger.log(Level.INFO, "webcontainer.ssodisabled", objectArray);
            } else {
                try {
                    ElementProperty elementProperty;
                    ElementProperty elementProperty2;
                    objectArray = new SingleSignOn();
                    if (this._debug > 1) {
                        objectArray.setDebug(this._debug);
                    }
                    if ((elementProperty2 = virtualServer2.getElementPropertyByName(SSO_MAX_IDLE)) != null && elementProperty2.getValue() != null) {
                        _logger.fine("SSO entry max idle time set to: " + elementProperty2.getValue());
                        int n = Integer.parseInt(elementProperty2.getValue());
                        objectArray.setMaxInactive(n);
                    }
                    if ((elementProperty = virtualServer2.getElementPropertyByName(SSO_REAP_INTERVAL)) != null && elementProperty.getValue() != null) {
                        _logger.fine("SSO expire thread interval set to : " + elementProperty.getValue());
                        int n = Integer.parseInt(elementProperty.getValue());
                        objectArray.setReapInterval(n);
                    }
                    virtualServer.addValve((Valve)objectArray);
                }
                catch (Exception exception) {
                    _logger.log(Level.WARNING, "webcontainer.ssobadconfig", exception.getMessage());
                    _logger.log(Level.WARNING, "webcontainer.ssodisabled", virtualServer.getID());
                }
            }
        }
        if ((objectArray = this._engine.getDefaultHost()) == null && this._engine instanceof StandardEngine) {
            ((StandardEngine)this._engine).setDefaultHost(string);
        }
        this._engine.addChild(virtualServer);
        return virtualServer;
    }

    public void addLifecycleListener(LifecycleListener lifecycleListener) {
        this._lifecycle.addLifecycleListener(lifecycleListener);
    }

    public void removeLifecycleListener(LifecycleListener lifecycleListener) {
        this._lifecycle.removeLifecycleListener(lifecycleListener);
    }

    public void start() throws LifecycleException {
        if (this._started) {
            String string = _rb.getString("webcontainer.alreadyStarted");
            throw new LifecycleException(string);
        }
        Container[] containerArray = this._engine.findChildren();
        int n = 0;
        while (n < containerArray.length) {
            this.loadWebModules((VirtualServer)containerArray[n]);
            ++n;
        }
        this.loadAllJ2EEApplicationWebModules();
        this.loadSystemDefaultWebModules();
        this._lifecycle.fireLifecycleEvent("start", null);
        this._started = true;
        this._embedded.start();
        int n2 = 0;
        while (n2 < containerArray.length) {
            ((VirtualServer)containerArray[n2]).handleCoreMappings();
            ++n2;
        }
        if (this._reloadingEnabled) {
            com.iplanet.ias.config.serverbeans.WebModule[] webModuleArray;
            Applications applications = this._serverBean.getApplications();
            this._reloadManager = new StandaloneWebModulesManager(this._id, this._modulesRoot);
            if (applications != null && (webModuleArray = applications.getWebModule()) != null && webModuleArray.length > 0) {
                this._reloadManager.start(webModuleArray, this._pollInterval);
            }
        }
    }

    public void stop() throws LifecycleException {
        if (!this._started) {
            String string = _rb.getString("webcontainer.notStarted");
            throw new LifecycleException(string);
        }
        this._started = false;
        this._embedded.stop();
        if (this._reloadManager != null) {
            this._reloadManager.stop();
            this._reloadManager = null;
        }
    }

    public static WebContainer createInstance(long l, ServerContext serverContext) {
        WebContainer webContainer = new WebContainer(Long.toString(l), serverContext);
        _instances.put(new Long(l), webContainer);
        return webContainer;
    }

    public static WebContainer getInstance(long l) {
        Long l2 = new Long(l);
        WebContainer webContainer = (WebContainer)_instances.get(l2);
        if (webContainer == null) {
            _logger.fine("Cound not find web container associated with the configuration: " + l);
        }
        return webContainer;
    }

    public static void startInstance(long l) throws ServerLifecycleException {
        WebContainer webContainer = WebContainer.getInstance(l);
        if (webContainer != null) {
            try {
                webContainer.start();
            }
            catch (LifecycleException lifecycleException) {
                Throwable throwable = lifecycleException.getThrowable();
                if (throwable == null) {
                    throwable = lifecycleException;
                }
                String string = _rb.getString("webcontainer.startError");
                throw new ServerLifecycleException(string, throwable);
            }
        } else {
            String string = _rb.getString("webcontainer.notFound");
            throw new ServerLifecycleException(string);
        }
    }

    public static void stopInstance(long l) throws ServerLifecycleException {
        WebContainer webContainer = WebContainer.getInstance(l);
        if (webContainer != null) {
            _instances.remove(new Long(l));
            try {
                webContainer.stop();
            }
            catch (LifecycleException lifecycleException) {
                Throwable throwable = lifecycleException.getThrowable();
                if (throwable == null) {
                    throwable = lifecycleException;
                }
                String string = _rb.getString("webcontainer.stopError");
                throw new ServerLifecycleException(string, throwable);
            }
        } else {
            String string = _rb.getString("webcontainer.notFound");
            throw new ServerLifecycleException(string);
        }
    }

    public static void stopAllInstances() throws ServerLifecycleException {
        Enumeration enumeration = _instances.keys();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                Long l = (Long)enumeration.nextElement();
                WebContainer.stopInstance(l);
            }
        }
    }

    public static int service(long l, NSAPIProcessor nSAPIProcessor, StandardHost standardHost, String[] stringArray, byte[][] byArray, int[] nArray, StandardContext standardContext, String string, StandardWrapper standardWrapper, String string2, String string3) {
        boolean bl = false;
        if (nSAPIProcessor == null) {
            nSAPIProcessor = new NSAPIProcessor();
            bl = true;
        }
        NSAPIConnector nSAPIConnector = nSAPIProcessor.getConnector();
        nSAPIConnector.setContainer(standardHost);
        nSAPIConnector.setJNIConnector(l);
        if (bl) {
            nSAPIConnector.jniSetThreadLocalData(nSAPIProcessor);
        }
        nSAPIProcessor.process(standardHost, stringArray, byArray, nArray, standardContext, string, standardWrapper, string2, string3);
        return 0;
    }

    private void loadWebModules(VirtualServer virtualServer) {
        Vector<WebModuleConfig> vector = virtualServer.getWebModules(this._serverBean, this._modulesRoot);
        WebModuleConfig webModuleConfig = virtualServer.getUserDefaultWebModuleConfig(this._serverBean);
        if (webModuleConfig != null) {
            if (vector == null) {
                vector = new Vector<WebModuleConfig>();
            }
            vector.add(0, webModuleConfig);
        }
        if (vector != null && vector.size() > 0) {
            ListIterator listIterator = vector.listIterator();
            while (listIterator.hasNext()) {
                webModuleConfig = (WebModuleConfig)listIterator.next();
                this.loadStandaloneWebModule(virtualServer, webModuleConfig);
            }
        }
    }

    private void loadSystemDefaultWebModules() {
        Container[] containerArray = this._engine.findChildren();
        int n = 0;
        while (n < containerArray.length) {
            VirtualServer virtualServer;
            WebModuleConfig webModuleConfig;
            if (containerArray[n] instanceof VirtualServer && (webModuleConfig = (virtualServer = (VirtualServer)containerArray[n]).createSystemDefaultWebModuleIfNecessary()) != null) {
                this.loadStandaloneWebModule(virtualServer, webModuleConfig);
            }
            ++n;
        }
    }

    private void loadStandaloneWebModule(VirtualServer virtualServer, WebModuleConfig webModuleConfig) {
        String string = webModuleConfig.getName();
        if (string.indexOf(":") != -1) {
            webModuleConfig.setWorkDirBase(this._appsWorkRoot);
        } else {
            webModuleConfig.setWorkDirBase(this._modulesWorkRoot);
        }
        try {
            this.loadWebModule(virtualServer, webModuleConfig);
        }
        catch (NamingException namingException) {
            Object[] objectArray = new Object[]{string, virtualServer.getID(), namingException};
            _logger.log(Level.SEVERE, "webcontainer.loadError", objectArray);
        }
        catch (MalformedURLException malformedURLException) {
            Object[] objectArray = new Object[]{string, virtualServer.getID(), malformedURLException};
            _logger.log(Level.SEVERE, "webcontainer.loadError", objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Object[] objectArray = new Object[]{string, virtualServer.getID(), illegalArgumentException};
            _logger.log(Level.SEVERE, "webcontainer.loadError", objectArray);
        }
    }

    private void loadAllJ2EEApplicationWebModules() {
        J2eeApplication[] j2eeApplicationArray;
        Applications applications = this._serverBean.getApplications();
        if (applications != null && (j2eeApplicationArray = applications.getJ2eeApplication()) != null) {
            int n = 0;
            while (n < j2eeApplicationArray.length) {
                this.loadJ2EEApplicationWebModules(j2eeApplicationArray[n]);
                ++n;
            }
        }
    }

    private void loadJ2EEApplicationWebModules(J2eeApplication j2eeApplication) {
        if (j2eeApplication != null && j2eeApplication.isEnabled()) {
            String string = j2eeApplication.getName();
            String string2 = j2eeApplication.getLocation();
            ApplicationRegistry applicationRegistry = ApplicationRegistry.getInstance();
            ClassLoader classLoader = applicationRegistry.getClassLoaderForApplication(string);
            if (classLoader != null) {
                Application application = applicationRegistry.getApplication(classLoader);
                if (application == null) {
                    Object[] objectArray = new Object[]{string};
                    _logger.log(Level.SEVERE, "webcontainer.notLoaded", objectArray);
                } else {
                    Set set = application.getWebBundleDescriptors();
                    WebBundleDescriptor webBundleDescriptor = null;
                    com.iplanet.ias.config.serverbeans.WebModule webModule = null;
                    WebModuleConfig webModuleConfig = null;
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        StringBuffer stringBuffer = new StringBuffer(string2);
                        webBundleDescriptor = (WebBundleDescriptor)iterator.next();
                        String string3 = webBundleDescriptor.getArchivist().getArchiveUri();
                        stringBuffer.append(File.separator);
                        stringBuffer.append(FileUtils.makeFriendlyFilename(string3));
                        webModule = new com.iplanet.ias.config.serverbeans.WebModule();
                        webModule.setName(string3);
                        webModule.setContextRoot(webBundleDescriptor.getContextRoot());
                        webModule.setLocation(stringBuffer.toString());
                        webModule.setVirtualServers(j2eeApplication.getVirtualServers());
                        webModule.setEnabled(true);
                        webModuleConfig = new WebModuleConfig();
                        webModuleConfig.setBean(webModule);
                        webModuleConfig.setWorkDirBase(this._appsWorkRoot);
                        webModuleConfig.setDescriptor(webBundleDescriptor);
                        webModuleConfig.setParentLoader(classLoader);
                        this.loadWebModule(webModuleConfig);
                    }
                }
            }
        }
    }

    private void loadWebModule(WebModuleConfig webModuleConfig) {
        String string = webModuleConfig.getVirtualServers();
        List list = StringUtils.parseStringList((String)string, (String)" ,");
        boolean bl = list == null || list.size() == 0;
        Container[] containerArray = this._engine.findChildren();
        int n = 0;
        while (n < containerArray.length) {
            if (containerArray[n] instanceof VirtualServer) {
                VirtualServer virtualServer = (VirtualServer)containerArray[n];
                if (bl || list.contains(virtualServer.getID())) {
                    try {
                        this.loadWebModule(virtualServer, webModuleConfig);
                    }
                    catch (NamingException namingException) {
                        Object[] objectArray = new Object[]{webModuleConfig.getName(), virtualServer.getID(), namingException};
                        _logger.log(Level.SEVERE, "webcontainer.appLoadError", objectArray);
                    }
                    catch (MalformedURLException malformedURLException) {
                        Object[] objectArray = new Object[]{webModuleConfig.getName(), virtualServer.getID(), malformedURLException};
                        _logger.log(Level.SEVERE, "webcontainer.appLoadError", objectArray);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        Object[] objectArray = new Object[]{webModuleConfig.getName(), virtualServer.getID(), illegalArgumentException};
                        _logger.log(Level.SEVERE, "webcontainer.appLoadError", objectArray);
                    }
                }
            }
            ++n;
        }
    }

    private void loadWebModule(VirtualServer virtualServer, WebModuleConfig webModuleConfig) throws NamingException, MalformedURLException, IllegalArgumentException {
        Object[] objectArray;
        Object object;
        Object object2;
        String string = webModuleConfig.getName();
        String string2 = webModuleConfig.getContextPath();
        String string3 = null;
        string3 = string2.equals("") ? "/" : string2;
        if (virtualServer.findChild(string2) != null) {
            Object[] objectArray2 = new Object[]{virtualServer.getID(), string3, string};
            _logger.log(Level.SEVERE, "webcontainer.duplicateContextRoot", objectArray2);
            return;
        }
        Object[] objectArray3 = new Object[]{string, virtualServer.getID(), string3};
        if (string.equals("default-web-module")) {
            _logger.log(Level.FINE, "webcontainer.loadModule", objectArray3);
        } else {
            _logger.log(Level.INFO, "webcontainer.loadModule", objectArray3);
        }
        Context context = this._embedded.createContext(string2, webModuleConfig.getLocation());
        ((StandardContext)context).setCachingAllowed(true);
        StringBuffer stringBuffer = new StringBuffer(webModuleConfig.getWorkDir());
        if (string.equals("default-web-module")) {
            stringBuffer.append("-");
            stringBuffer.append(FileUtils.makeFriendlyFilename(virtualServer.getID()));
        }
        ((StandardContext)context).setWorkDir(stringBuffer.toString());
        ClassLoader classLoader = webModuleConfig.getParentLoader();
        if (classLoader == null) {
            classLoader = this._serverContext.getCommonClassLoader();
        }
        context.setParentClassLoader(classLoader);
        WebBundleDescriptor webBundleDescriptor = null;
        webBundleDescriptor = webModuleConfig.getDescriptor();
        if (webBundleDescriptor != null && (object2 = webBundleDescriptor.getArchivist().getExternalDescriptorArchiveUri()) != null) {
            object = webModuleConfig.getLocation() + "/..";
            object2 = ((String)object2).startsWith("/") ? (String)object + ((String)object2).trim() : (String)object + "/" + ((String)object2).trim();
            objectArray = new Object[]{object2, string};
            _logger.log(Level.INFO, "webcontainer.altDDName", objectArray);
            ((StandardContext)context).setAltDDName((String)object2);
        }
        object2 = null;
        if (webBundleDescriptor != null) {
            object2 = webBundleDescriptor.getIasWebApp();
        }
        object = (WebModule)context;
        ((WebModule)object).setIasWebAppConfigBean((SunWebApp)((Object)object2));
        ((WebModule)object).setID(string);
        this.configureLoader(context, (SunWebApp)((Object)object2));
        this.configureMiscSettings(context, (SunWebApp)((Object)object2), virtualServer.getID(), string3);
        this.configureSessionSettings(context, (SunWebApp)((Object)object2));
        ((WebModule)object).setI18nInfo();
        objectArray = Switch.getSwitch();
        if (webBundleDescriptor != null) {
            context.setRealm(new RealmAdapter(webBundleDescriptor));
            objectArray.setDescriptorFor(context, webBundleDescriptor);
            objectArray.getNamingManager().bindObjects(webBundleDescriptor);
        }
        virtualServer.addChild(context);
        if (webBundleDescriptor != null) {
            objectArray.setDescriptorFor(context, webBundleDescriptor);
        }
    }

    private void configureLoader(Context context, SunWebApp sunWebApp) {
        Object object;
        Loader loader = this._embedded.createLoader(context.getParentClassLoader());
        boolean bl = false;
        List list = null;
        if (sunWebApp != null && sunWebApp.isClassLoader()) {
            object = sunWebApp.getAttributeValue("ClassLoader", "delegate");
            if (object != null) {
                bl = ConfigBean.toBoolean((String)object);
            }
            if ((object = sunWebApp.getAttributeValue("ClassLoader", "extra-class-path")) != null) {
                list = StringUtils.parseStringList((String)object, (String)";:");
            }
        }
        if (this._debug > 0) {
            _logger.fine("WebModule[" + context.getPath() + "]: Setting delegate to " + bl);
        }
        loader.setDelegate(bl);
        if (list != null) {
            object = list.listIterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                if (this._debug > 0) {
                    _logger.fine("WebModule[" + context.getPath() + "]: Adding " + string + " to the classpath");
                }
                try {
                    URL uRL = new File(string).toURI().toURL();
                    loader.addRepository(uRL.toString());
                }
                catch (MalformedURLException malformedURLException) {
                    String string2 = _rb.getString("webcontainer.classpathError");
                    Object[] objectArray = new Object[]{string};
                    string2 = MessageFormat.format(string2, objectArray);
                    _logger.log(Level.SEVERE, string2, malformedURLException);
                }
            }
        }
        if (this._reloadingEnabled) {
            if (this._debug > 0) {
                _logger.fine("WebModule[" + context.getPath() + "]: Dynamic reloading enabled (poll interval = " + this._pollInterval + " second(s))");
            }
            context.setReloadable(true);
            ((WebappLoader)loader).setCheckInterval(this._pollInterval);
        }
        context.setLoader(loader);
    }

    private void configureMiscSettings(Context context, SunWebApp sunWebApp, String string, String string2) {
        if (sunWebApp != null && sunWebApp.sizeWebProperty() > 0) {
            WebProperty[] webPropertyArray = sunWebApp.getWebProperty();
            int n = 0;
            while (n < webPropertyArray.length) {
                Object[] objectArray;
                String string3 = webPropertyArray[n].getAttributeValue("name");
                String string4 = webPropertyArray[n].getAttributeValue("value");
                if (string3.equalsIgnoreCase("singleThreadedServletPoolSize")) {
                    try {
                        int n2 = Integer.parseInt(string4);
                        if (n2 > 0) {
                            ((StandardContext)context).setSTMPoolSize(n2);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (string3.equalsIgnoreCase("tempdir")) {
                    ((StandardContext)context).setWorkDir(string4);
                } else if (string3.equalsIgnoreCase("crossContextAllowed")) {
                    boolean bl = ConfigBean.toBoolean(string4);
                    ((StandardContext)context).setCrossContext(bl);
                } else if (string3.equalsIgnoreCase("reuseSessionID")) {
                    boolean bl = ConfigBean.toBoolean(string4);
                    context.setReuseSessionID(bl);
                    if (bl) {
                        objectArray = new Object[]{string2, string};
                        _logger.log(Level.WARNING, "webcontainer.sessionIDsReused", objectArray);
                    }
                } else if (string3.equalsIgnoreCase("useResponseCTForHeaders")) {
                    if (string4.equalsIgnoreCase("true")) {
                        WebModule webModule = (WebModule)context;
                        webModule.setResponseCTForHeaders();
                    }
                } else if (string3.equalsIgnoreCase("encodeCookies")) {
                    boolean bl = ConfigBean.toBoolean(string4);
                    objectArray = (Object[])context;
                    objectArray.setEncodeCookies(bl);
                } else {
                    Object[] objectArray2 = new Object[]{string3, string4};
                    _logger.log(Level.INFO, "webcontainer.invalidProperty", objectArray2);
                }
                ++n;
            }
        }
    }

    private void configureSessionSettings(Context context, SunWebApp sunWebApp) {
        SessionConfig sessionConfig = null;
        SessionManager sessionManager = null;
        SessionProperties sessionProperties = null;
        CookieProperties cookieProperties = null;
        if (sunWebApp != null) {
            sessionConfig = sunWebApp.getSessionConfig();
        }
        if (sessionConfig != null) {
            sessionManager = sessionConfig.getSessionManager();
        }
        if (sessionConfig != null) {
            sessionProperties = sessionConfig.getSessionProperties();
        }
        if (sessionConfig != null) {
            cookieProperties = sessionConfig.getCookieProperties();
        }
        this.configureSessionManager(context, sessionManager);
        this.configureSession(context, sessionProperties);
        this.configureCookieProperties(context, cookieProperties);
    }

    private void configureSessionManager(Context context, SessionManager sessionManager) {
        Object object;
        Object object2;
        Object[] objectArray;
        int n = 60;
        int n2 = -1;
        PersistenceType persistenceType = PersistenceType.MEMORY;
        String string = null;
        int n3 = 60;
        String string2 = ((StandardContext)context).getWorkDir();
        if (sessionManager != null) {
            Object[] objectArray2;
            String string3;
            objectArray = sessionManager.getAttributeValue("persistence-type");
            persistenceType = PersistenceType.parseType((String)objectArray);
            object2 = sessionManager.getManagerProperties();
            if (object2 != null && object2.sizeWebProperty() > 0) {
                object = object2.getWebProperty();
                int n4 = 0;
                while (n4 < ((WebProperty[])object).length) {
                    String string4 = object[n4].getAttributeValue("name");
                    string3 = object[n4].getAttributeValue("value");
                    if (string4.equalsIgnoreCase("reapIntervalSeconds")) {
                        try {
                            n = Integer.parseInt(string3);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    } else if (string4.equalsIgnoreCase("maxSessions")) {
                        try {
                            n2 = Integer.parseInt(string3);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    } else if (string4.equalsIgnoreCase("sessionFilename")) {
                        string = string3;
                    } else {
                        objectArray2 = new Object[]{string4};
                        _logger.log(Level.INFO, "webcontainer.notYet", objectArray2);
                    }
                    ++n4;
                }
            }
            if ((object = sessionManager.getStoreProperties()) != null && ((StoreProperties)((Object)object)).sizeWebProperty() > 0) {
                WebProperty[] webPropertyArray = ((StoreProperties)((Object)object)).getWebProperty();
                int n5 = 0;
                while (n5 < webPropertyArray.length) {
                    string3 = webPropertyArray[n5].getAttributeValue("name");
                    objectArray2 = webPropertyArray[n5].getAttributeValue("value");
                    if (string3.equalsIgnoreCase("reapIntervalSeconds")) {
                        try {
                            n3 = Integer.parseInt((String)objectArray2);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    } else if (string3.equalsIgnoreCase("directory")) {
                        string2 = objectArray2;
                    } else {
                        Object[] objectArray3 = new Object[]{string3};
                        _logger.log(Level.INFO, "webcontainer.notYet", objectArray3);
                    }
                    ++n5;
                }
            }
        }
        if (persistenceType == PersistenceType.MEMORY) {
            objectArray = new StandardManager();
            objectArray.setPathname(string);
            objectArray.setMaxActiveSessions(n2);
            objectArray.setCheckInterval(n);
            context.setManager((Manager)objectArray);
        } else if (persistenceType == PersistenceType.FILE) {
            objectArray = new Object[]{context.getPath()};
            _logger.log(Level.INFO, "webcontainer.filePersistence", objectArray);
            object2 = new PersistentManager();
            ((PersistentManagerBase)object2).setMaxActiveSessions(n2);
            ((PersistentManagerBase)object2).setCheckInterval(n);
            ((PersistentManagerBase)object2).setMaxIdleBackup(0);
            object = new FileStore();
            ((StoreBase)object).setCheckInterval(n3);
            ((FileStore)object).setDirectory(string2);
            ((PersistentManagerBase)object2).setStore((Store)object);
            context.setManager((Manager)object2);
        }
    }

    private void configureSession(Context context, SessionProperties sessionProperties) {
        boolean bl = false;
        int n = 60;
        boolean bl2 = true;
        if (sessionProperties != null && sessionProperties.sizeWebProperty() > 0) {
            WebProperty[] webPropertyArray = sessionProperties.getWebProperty();
            int n2 = 0;
            while (n2 < webPropertyArray.length) {
                String string = webPropertyArray[n2].getAttributeValue("name");
                String string2 = webPropertyArray[n2].getAttributeValue("value");
                if (string.equalsIgnoreCase("timeoutSeconds")) {
                    try {
                        n = Integer.parseInt(string2);
                        bl = true;
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (string.equalsIgnoreCase("enableCookies")) {
                    bl2 = ConfigBean.toBoolean(string2);
                } else {
                    Object[] objectArray = new Object[]{string};
                    _logger.log(Level.INFO, "webcontainer.notYet", objectArray);
                }
                ++n2;
            }
        }
        if (bl) {
            context.getManager().setMaxInactiveInterval(n);
        }
        context.setCookies(bl2);
    }

    private void configureCookieProperties(Context context, CookieProperties cookieProperties) {
        WebProperty[] webPropertyArray;
        if (cookieProperties != null && (webPropertyArray = cookieProperties.getWebProperty()) != null) {
            Object object;
            SessionCookieConfig sessionCookieConfig = new SessionCookieConfig();
            int n = 0;
            while (n < webPropertyArray.length) {
                object = webPropertyArray[n].getAttributeValue("name");
                String string = webPropertyArray[n].getAttributeValue("value");
                if (((String)object).equalsIgnoreCase("cookieName")) {
                    sessionCookieConfig.setName(string);
                } else if (((String)object).equalsIgnoreCase("cookiePath")) {
                    sessionCookieConfig.setPath(string);
                } else if (((String)object).equalsIgnoreCase("cookieMaxAgeSeconds")) {
                    try {
                        sessionCookieConfig.setMaxAge(Integer.parseInt(string));
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (((String)object).equalsIgnoreCase("cookieDomain")) {
                    sessionCookieConfig.setDomain(string);
                } else if (((String)object).equalsIgnoreCase("cookieComment")) {
                    sessionCookieConfig.setComment(string);
                } else {
                    Object[] objectArray = new Object[]{object, string};
                    _logger.log(Level.INFO, "webcontainer.invalidProperty", objectArray);
                }
                ++n;
            }
            if (webPropertyArray.length > 0) {
                if (this._debug > 0) {
                    _logger.fine("WebModule[" + context.getPath() + "]: " + sessionCookieConfig);
                }
                object = (WebModule)context;
                ((WebModule)object).setSessionCookieConfig(sessionCookieConfig);
            }
        }
    }

    private void getDynamicReloadingSettings(Applications applications) {
        block3: {
            if (applications == null) break block3;
            this._reloadingEnabled = applications.isDynamicReloadEnabled();
            String string = applications.getDynamicReloadPollIntervalInSeconds();
            if (string != null) {
                try {
                    this._pollInterval = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
    }

    private void setLogLevel(Level level) {
        this._logLevel = level;
        _logger.setLevel(this._logLevel);
        this._debug = level.equals(Level.FINE) ? 1 : (level.equals(Level.FINER) ? 2 : (level.equals(Level.FINEST) ? 5 : 0));
    }

    private boolean isSSOEnabled(com.iplanet.ias.config.serverbeans.VirtualServer virtualServer) {
        ElementProperty elementProperty = virtualServer.getElementPropertyByName(SSO_ENABLED);
        return elementProperty == null || elementProperty.getValue() == null || ConfigBean.toBoolean(elementProperty.getValue());
    }

    private com.iplanet.ias.config.serverbeans.VirtualServer findVirtalServerBean(String string) {
        HttpService httpService = this._serverBean.getHttpService();
        if (httpService == null) {
            return null;
        }
        VirtualServerClass[] virtualServerClassArray = httpService.getVirtualServerClass();
        if (virtualServerClassArray == null) {
            return null;
        }
        int n = 0;
        while (n < virtualServerClassArray.length) {
            com.iplanet.ias.config.serverbeans.VirtualServer[] virtualServerArray = virtualServerClassArray[n].getVirtualServer();
            if (virtualServerArray == null) {
                return null;
            }
            int n2 = 0;
            while (n2 < virtualServerArray.length) {
                if (string.equals(virtualServerArray[n2].getId())) {
                    return virtualServerArray[n2];
                }
                ++n2;
            }
            ++n;
        }
        return null;
    }
}

