/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.util.threadpool;

import com.iplanet.ias.util.collection.BlockingQueue;
import com.iplanet.ias.util.collection.QueueClosedException;
import com.iplanet.ias.util.collection.TooManyTasksException;
import com.iplanet.ias.util.threadpool.Servicable;
import com.iplanet.ias.util.threadpool.TaskFactory;
import java.util.ArrayList;

public class TaskQueue
extends BlockingQueue {
    private TaskFactory taskFactory;

    public TaskQueue(TaskFactory taskFactory) {
        this.taskFactory = taskFactory;
    }

    public TaskQueue(int n, TaskFactory taskFactory) {
        super(n);
        this.taskFactory = taskFactory;
    }

    public void addFirst(Object object) throws TooManyTasksException, QueueClosedException {
        super.addFirst(this.taskFactory.createTask(object));
    }

    public void addFirst(Servicable servicable) throws TooManyTasksException, QueueClosedException {
        super.addFirst(servicable);
    }

    public void addLast(Object object) throws TooManyTasksException, QueueClosedException {
        super.addLast(this.taskFactory.createTask(object));
    }

    public void addLast(Servicable servicable) throws TooManyTasksException, QueueClosedException {
        super.addLast(servicable);
    }

    public void add(int n, Object object) throws TooManyTasksException, QueueClosedException {
        super.add(n, this.taskFactory.createTask(object));
    }

    public void addAll(ArrayList arrayList) throws TooManyTasksException, QueueClosedException {
        int n = 0;
        while (n < arrayList.size()) {
            Servicable servicable = this.taskFactory.createTask(arrayList.get(n));
            arrayList.set(n, servicable);
            ++n;
        }
        super.addAll(arrayList);
    }

    public void destroyTask(Object object) {
        this.taskFactory.deleteTask(object);
    }
}

