/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.util.collection;

import com.iplanet.ias.util.collection.LongArrayList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;

public class LongArray {
    long[] data;
    int size;
    double growFactor;

    public LongArray() {
        this(6, 0.5);
    }

    public LongArray(int n) {
        this(n, 0.5);
    }

    public LongArray(int n, double d) {
        this.data = new long[n];
        this.growFactor = d;
    }

    public void add(int n, long l) {
        if (this.size == this.data.length) {
            this.makeRoom(1);
        }
        System.arraycopy(this.data, n, this.data, n + 1, this.size - n);
        this.data[n] = l;
        ++this.size;
    }

    public boolean add(long l) {
        if (this.size == this.data.length) {
            this.makeRoom(1);
        }
        this.data[this.size++] = l;
        return true;
    }

    public boolean addAll(LongArray longArray) {
        int n = longArray.size();
        this.makeRoom(n);
        LongIterator longIterator = longArray.longIterator();
        while (longIterator.hasNext()) {
            this.data[this.size++] = longIterator.nextLong();
        }
        return n > 0;
    }

    public boolean addAll(int n, LongArray longArray) {
        int n2 = longArray.size();
        this.makeRoom(n2);
        System.arraycopy(this.data, n, this.data, n + n2, this.size - n);
        LongIterator longIterator = longArray.longIterator();
        while (longIterator.hasNext()) {
            this.data[n++] = longIterator.nextLong();
        }
        this.size += n2;
        return n2 > 0;
    }

    public void clear() {
        this.size = 0;
        this.data = new long[6];
    }

    public boolean contains(long l) {
        return this.indexOf(l) >= 0;
    }

    public boolean containsAll(LongArray longArray) {
        LongIterator longIterator = longArray.longIterator();
        while (longIterator.hasNext()) {
            if (this.contains(longIterator.nextLong())) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(long[] lArray) {
        int n = lArray.length;
        while (n > 0) {
            if (this.contains(lArray[--n])) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public long get(int n) {
        return this.data[n];
    }

    public int hashCode() {
        long l = 1L;
        int n = 0;
        while (n < this.size) {
            l = 31L * l + this.data[n];
            ++n;
        }
        return (int)l;
    }

    public int indexOf(long l) {
        int n = 0;
        while (n < this.size) {
            if (this.data[n] == l) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int lastIndexOf(long l) {
        int n = this.size - 1;
        while (n >= 0) {
            if (this.data[n] == l) {
                return n;
            }
            --n;
        }
        return -1;
    }

    public ListIterator listIterator() {
        return new LongIterator(0);
    }

    public ListIterator listIterator(int n) {
        return new LongIterator(n);
    }

    public long remove(int n) {
        long l = this.data[n];
        if (n < this.size - 1) {
            System.arraycopy(this.data, n + 1, this.data, n, this.size - n);
        }
        --this.size;
        return l;
    }

    public boolean remove(long l) {
        int n = 0;
        while (n < this.size) {
            if (this.data[n] == l && n < this.size - 1) {
                System.arraycopy(this.data, n + 1, this.data, n, this.size - n);
                --this.size;
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean removeAll(LongArray longArray) {
        boolean bl = false;
        LongIterator longIterator = longArray.longIterator();
        while (longIterator.hasNext()) {
            if (!this.remove(longIterator.nextLong())) continue;
            bl = true;
        }
        return bl;
    }

    public boolean removeAll(long[] lArray) {
        boolean bl = false;
        int n = 0;
        while (n < lArray.length) {
            if (this.remove(lArray[n])) {
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    public boolean retainAll(LongArray longArray) {
        return false;
    }

    public boolean retainAll(long[] lArray) {
        return false;
    }

    public Object set(int n, Object object) {
        long l = this.data[n];
        this.data[n] = (Long)object;
        return new Long(l);
    }

    public long set(int n, long l) {
        long l2 = this.data[n];
        this.data[n] = l;
        return l2;
    }

    public int size() {
        return this.size;
    }

    public long[] toArray() {
        return this.data;
    }

    protected void makeRoom(int n) {
        if (n + this.size >= this.data.length) {
            long[] lArray = this.data;
            int n2 = this.size + n + (int)((double)this.size * this.growFactor) + 1;
            this.data = new long[n2];
            System.arraycopy(lArray, 0, this.data, 0, lArray.length);
        }
    }

    public Iterator iterator() {
        return new LongIterator(0);
    }

    public LongIterator longIterator() {
        return new LongIterator(0);
    }

    public void print() {
        System.out.print("Data (size: " + this.size + "): ");
        int n = 0;
        while (n < this.size) {
            System.out.print(" " + this.data[n]);
            ++n;
        }
        System.out.println();
    }

    public void printStat() {
        System.out.println("Size: " + this.size);
        System.out.println("Length: " + this.data.length);
    }

    public static void main(String[] stringArray) {
        int n = 1000000;
        ArrayList<Long> arrayList = new ArrayList<Long>(n);
        LongArray longArray = new LongArray(n, 0.1);
        LongArrayList longArrayList = new LongArrayList(n, 0.1);
        long l = System.currentTimeMillis();
        int n2 = 0;
        while (n2 < n) {
            arrayList.add(new Long(n2));
            ++n2;
        }
        long l2 = System.currentTimeMillis();
        System.out.println("ArrayList took: " + (double)(l2 - l) / 1000.0 + " sec.");
        arrayList.clear();
        l = System.currentTimeMillis();
        int n3 = 0;
        while (n3 < n) {
            longArray.add(n3);
            ++n3;
        }
        l2 = System.currentTimeMillis();
        System.out.println("LongArray took: " + (double)(l2 - l) / 1000.0 + " sec.");
        longArray.printStat();
        longArray.clear();
        l = System.currentTimeMillis();
        int n4 = 0;
        while (n4 < n) {
            longArrayList.add(n4);
            ++n4;
        }
        l2 = System.currentTimeMillis();
        System.out.println("LongArrayList took: " + (double)(l2 - l) / 1000.0 + " sec.");
        longArrayList.clear();
        int n5 = 0;
        while (n5 < n) {
            longArray.add(n5);
            ++n5;
        }
        int n6 = 0;
        while (n6 < 10) {
            int n7 = 0;
            while (n7 < n) {
                if (longArray.get(n7) != (long)n7) {
                    System.out.println("data[" + n7 + "]: " + longArray.get(n7));
                }
                ++n7;
            }
            ++n6;
        }
    }

    private class LongIterator
    implements ListIterator {
        int startIndex;
        int index = 0;

        LongIterator(int n) {
            this.startIndex = n;
        }

        public void add(Object object) {
        }

        public boolean hasPrevious() {
            return this.index > this.startIndex;
        }

        public boolean hasNext() {
            return this.index < LongArray.this.size;
        }

        public Object previous() {
            return new Long(LongArray.this.data[--this.index]);
        }

        public int previousIndex() {
            return this.index;
        }

        public Object next() {
            return new Long(LongArray.this.data[this.index++]);
        }

        public int nextIndex() {
            return this.index;
        }

        public long previousLong() {
            return LongArray.this.data[--this.index];
        }

        public long nextLong() {
            return LongArray.this.data[this.index++];
        }

        public void remove() {
        }

        public void set(Object object) {
        }
    }
}

