/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.license;

import com.iplanet.ias.license.FileLicense;
import com.iplanet.ias.license.LicenseBase;
import com.iplanet.ias.license.LicenseException;
import com.iplanet.ias.util.i18n.StringManager;
import com.iplanet.ias.util.io.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Properties;

public class LicenseManager {
    private static StringManager sm = StringManager.getManager(class$com$iplanet$ias$license$LicenseManager == null ? (class$com$iplanet$ias$license$LicenseManager = LicenseManager.class$("com.iplanet.ias.license.LicenseManager")) : class$com$iplanet$ias$license$LicenseManager);
    private static LicenseBase currentLicense = null;
    private static LicenseManager manager = null;
    private static final String PE_KEY = "7348950986-5346271508";
    private static final String SE_KEY = "2378124054-1735946538";
    private static final String DEV_KEY = "2284910653-4386095633";
    private static final String EVAL_KEY = "5971754263-2547835531";
    private static final String[] iasParams = new String[]{"allow_upgrade", "description", "date_string", "ias.license_type", "ias.file_version", "ias.license_version", "ias.precedence", "ias.num_instances", "ias.allow_remote_admin"};
    private static final String[] PEValue = new String[]{"1", "Sun ONE Application Server 7 Platform Edition production license", "NONE", "PE", "1", "3", "3000", "1", "0"};
    private static final String[] SEValue = new String[]{"1", "Sun ONE Application Server 7 Standard Edition production license", "NONE", "SE", "1", "3", "4000", "-1", "1"};
    private static final String[] DevValue = new String[]{"1", "Sun ONE Application Server 7 Developer license", "NONE", "DEV", "1", "3", "2000", "-1", "1"};
    private static final String[] EvalValue = new String[]{"1", "Sun ONE Application Server 7 Evaluation license", "TRY[60]", "Eval", "1", "3", "1000", "-1", "1"};
    private static final String LICENSE_BASE_PKG_PREFIX = "com.iplanet.ias.license.";
    private static final String STANDALONE_LICENSE_BASE = "StandaloneLicense";
    private static final String LICENSE_BASE_CLASS_PREFIX = "L";
    private static final int MAX_LICENSE_BASE_CLASSES = 100;
    private static final String LICENSE_FILE_SUBDIR = "";
    private boolean allow_multiple_files = false;
    private static FilenameFilter licFilter = new FilenameFilter(){

        public boolean accept(File file, String string) {
            return string.startsWith("appserv") && string.endsWith(".lic");
        }
    };
    static /* synthetic */ Class class$com$iplanet$ias$license$LicenseManager;

    private LicenseManager() {
    }

    public static LicenseBase getLicense() throws IOException, LicenseException {
        if (manager == null) {
            manager = new LicenseManager();
        }
        if (currentLicense != null) {
            return currentLicense;
        }
        String string = LicenseManager.getLicenseHome();
        LicenseBase licenseBase = manager.getLicenseBase();
        FileLicense fileLicense = manager.loadLicenseFile(string);
        if (fileLicense != null) {
            try {
                fileLicense.rewriteLicense();
            }
            catch (IOException iOException) {
                throw new LicenseException(iOException.getMessage());
            }
        }
        if (fileLicense != null) {
            licenseBase.superimpose(fileLicense.getProperties());
        } else if (licenseBase.isLicenseFileRequired()) {
            throw new LicenseException(sm.getString("license.e_no_valid_license"));
        }
        currentLicense = licenseBase;
        return licenseBase;
    }

    public static void upgradeLicenseKey(String string) throws IOException, LicenseException {
        if (string == null || !string.equals(PE_KEY) && !string.equals(SE_KEY) && !string.equals(DEV_KEY)) {
            throw new LicenseException(sm.getString("license.e_bad_key"));
        }
        LicenseManager.installLicense(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void installLicense(String string) throws IOException, LicenseException {
        File file = null;
        try {
            String string2 = LicenseManager.getLicenseHome();
            try {
                File file2 = new File(string2);
                file = new File(file2, "appserv.lic.new");
                LicenseManager.generateLicense(file, string);
            }
            catch (Exception exception) {
                throw new LicenseException(sm.getString("license.e_no_permission"));
            }
            LicenseManager.upgradeLicense(file.getAbsolutePath());
            currentLicense = null;
            currentLicense = manager.getLicense();
            Object var5_5 = null;
            file.delete();
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            file.delete();
            throw throwable;
        }
    }

    private static void generateLicense(File file, String string) throws IOException, LicenseException {
        Properties properties = new Properties();
        LicenseManager.readASProperties(properties, string);
        FileLicense fileLicense = new FileLicense();
        fileLicense.setAutoChecking(false);
        fileLicense.superimpose(properties);
        fileLicense.writeLicense(file);
    }

    private static void readASProperties(Properties properties, String string) throws LicenseException {
        int n = 0;
        while (n < iasParams.length) {
            String string2 = iasParams[n];
            String string3 = null;
            if (string.equals(PE_KEY)) {
                string3 = PEValue[n];
            } else if (string.equals(SE_KEY)) {
                string3 = SEValue[n];
            } else if (string.equals(DEV_KEY)) {
                string3 = DevValue[n];
            } else if (string.equals(EVAL_KEY)) {
                string3 = EvalValue[n];
            } else if (string == null || string.length() == 0) {
                string3 = PEValue[n];
            } else {
                throw new LicenseException(sm.getString("license.e_bad_key"));
            }
            properties.setProperty(string2, string3);
            ++n;
        }
    }

    public static void upgradeLicense(String string) throws IOException, LicenseException {
        Object object;
        boolean bl = true;
        try {
            object = LicenseManager.getLicense();
            bl = ((LicenseBase)object).allowUpgrade();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl) {
            object = LicenseManager.getLicenseHome();
            FileOutputStream fileOutputStream = null;
            FileInputStream fileInputStream = null;
            File file = null;
            File file2 = null;
            try {
                file2 = new File(string);
                fileInputStream = new FileInputStream(file2);
            }
            catch (Exception exception) {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                throw new LicenseException(sm.getString("license.e_no_license", string));
            }
            try {
                File file3 = new File((String)object);
                file = new File(file3, "appserv.lic");
                fileOutputStream = new FileOutputStream(file);
                FileUtils.copy(fileInputStream, fileOutputStream);
            }
            catch (Exception exception) {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                throw new LicenseException(sm.getString("license.e_no_permission"));
            }
        }
        throw new LicenseException(sm.getString("license.e_can_not_upgrade"));
    }

    /*
     * Unable to fully structure code
     */
    private LicenseBase getLicenseBase() throws LicenseException {
        var1_1 = null;
        var2_2 = "com.iplanet.ias.license.StandaloneLicense";
        try {
            var1_1 = Class.forName(var2_2);
            return this.newInstance(var1_1);
        }
        catch (Exception var3_3) {
            var3_4 = new ArrayList<LicenseBase>();
            var4_5 = 0;
            ** while (var4_5 < 100)
        }
lbl-1000:
        // 1 sources

        {
            var2_2 = "com.iplanet.ias.license.L" + var4_5;
            try {
                var1_1 = Class.forName(var2_2);
                var3_4.add(this.newInstance(var1_1));
            }
            catch (Exception var5_6) {
                var5_6.printStackTrace();
            }
            ++var4_5;
            continue;
        }
lbl20:
        // 1 sources

        var5_7 = var3_4.toArray(new LicenseBase[0]);
        return this.selectBestLicense(var5_7);
    }

    private LicenseBase newInstance(Class clazz) throws Exception {
        Constructor constructor = clazz.getConstructor(null);
        return (LicenseBase)constructor.newInstance(null);
    }

    private LicenseBase selectBestLicense(LicenseBase[] licenseBaseArray) throws LicenseException {
        if (licenseBaseArray == null || licenseBaseArray.length == 0) {
            throw new LicenseException(sm.getString("license.e_no_valid_license"));
        }
        LicenseBase licenseBase = licenseBaseArray[0];
        int n = 1;
        while (n < licenseBaseArray.length) {
            if (licenseBase.getPrecedence() < licenseBaseArray[n].getPrecedence()) {
                licenseBase = licenseBaseArray[n];
            }
            ++n;
        }
        return licenseBase;
    }

    private FileLicense loadLicenseFile(String string) throws LicenseException {
        File file = new File(string);
        if (this.allow_multiple_files) {
            try {
                LicenseBase[] licenseBaseArray = LicenseManager.loadFileLicenses(string);
                FileLicense fileLicense = (FileLicense)this.selectBestLicense(licenseBaseArray);
                return fileLicense;
            }
            catch (Exception exception) {
                throw new LicenseException(exception);
            }
        }
        if (LICENSE_FILE_SUBDIR.length() > 0) {
            file = new File(file, LICENSE_FILE_SUBDIR);
        }
        if (!(file = new File(file, "appserv.lic")).exists() || file.isDirectory()) {
            throw new LicenseException(sm.getString("license.e_no_license", file.getPath()));
        }
        try {
            FileLicense fileLicense = new FileLicense(file);
            return fileLicense;
        }
        catch (Exception exception) {
            throw new LicenseException(exception.getMessage());
        }
    }

    public static LicenseBase[] loadFileLicenses(String string) {
        File file = new File(string);
        if (LICENSE_FILE_SUBDIR.length() > 0) {
            file = new File(file, LICENSE_FILE_SUBDIR);
        }
        String[] stringArray = file.list(licFilter);
        ArrayList<FileLicense> arrayList = new ArrayList<FileLicense>();
        int n = 0;
        while (n < stringArray.length) {
            try {
                File file2 = new File(file, stringArray[n]);
                FileLicense fileLicense = new FileLicense(file2);
                arrayList.add(fileLicense);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n;
        }
        return arrayList.toArray(new FileLicense[0]);
    }

    private static String getLicenseHome() throws IOException, LicenseException {
        String string = System.getProperty("com.sun.aas.configRoot");
        if (string == null) {
            throw new LicenseException(sm.getString("license.e_no_config"));
        }
        return string.trim();
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray != null && stringArray.length > 0) {
            String string = stringArray[0];
            if (string.equals(EVAL_KEY)) {
                LicenseManager.installLicense(string);
            } else {
                LicenseManager.upgradeLicenseKey(string);
            }
        } else {
            LicenseBase licenseBase = LicenseManager.getLicense();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

