/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.deployment.backend;

import com.iplanet.ias.deployment.backend.ContextRootChecker;
import com.iplanet.ias.deployment.backend.DeploymentCleanerManager;
import com.iplanet.ias.deployment.backend.DeploymentLogger;
import com.iplanet.ias.deployment.backend.DeploymentRequest;
import com.iplanet.ias.deployment.backend.DeploymentUtils;
import com.iplanet.ias.deployment.backend.IASDeploymentException;
import com.iplanet.ias.ejb.codegen.IASEJBCTimes;
import com.iplanet.ias.instance.InstanceEnvironment;
import com.iplanet.ias.instance.ModuleEnvironment;
import com.iplanet.ias.loader.EJBClassLoader;
import com.iplanet.ias.util.i18n.StringManager;
import com.iplanet.ias.util.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;

public abstract class Deployer {
    protected DeploymentRequest request;
    protected Logger logger = DeploymentLogger.get();
    protected StringBuffer summary = new StringBuffer();
    private InstanceEnvironment instanceEnv;
    private ModuleEnvironment moduleEnv;
    private long timeDeployStarted;
    private long ejbcTime = 0L;
    private long jspcTime = 0L;
    private File lockFile = null;
    static final String lockFileName = ".com.sun.deployment.backend.lock";
    private static StringManager localStrings = StringManager.getManager(class$com$iplanet$ias$deployment$backend$Deployer == null ? (class$com$iplanet$ias$deployment$backend$Deployer = Deployer.class$("com.iplanet.ias.deployment.backend.Deployer")) : class$com$iplanet$ias$deployment$backend$Deployer);
    private static final boolean keepFailedStubsValue;
    private static final String FAILED_SUFFIX = "_failed";
    private IASEJBCTimes ejbcTiming = null;
    static /* synthetic */ Class class$com$iplanet$ias$deployment$backend$Deployer;

    Deployer(DeploymentRequest deploymentRequest) throws IASDeploymentException {
        if (deploymentRequest == null) {
            String string = localStrings.getString("enterprise.deployment.backend.null_deployment_request_object");
            throw new IASDeploymentException(string);
        }
        this.request = deploymentRequest;
        this.instanceEnv = this.request.getInstanceEnv();
        if (this.instanceEnv == null) {
            String string = localStrings.getString("enterprise.deployment.backend.null_instanceenvironment_in_deployment_request");
            throw new IASDeploymentException(string);
        }
    }

    public abstract void doRequest() throws IASDeploymentException;

    public abstract void cleanup_internal();

    public final void cleanup() {
        try {
            this.cleanup_internal();
            if (this.request.amIAnAdminServer()) {
                DeploymentCleanerManager.clean(this.instanceEnv);
            }
        }
        catch (IASDeploymentException iASDeploymentException) {
            this.logger.warning("Error running DeploymentCleanerManager: " + iASDeploymentException);
        }
    }

    public String toString() {
        return this.summary.toString();
    }

    public static final boolean getKeepFailedStubsValue() {
        return keepFailedStubsValue;
    }

    static final String getLockFileName() {
        return lockFileName;
    }

    protected final InstanceEnvironment getInstanceEnv() {
        return this.instanceEnv;
    }

    protected final DeploymentRequest getRequest() {
        return this.request;
    }

    protected final boolean isDirectory() throws IASDeploymentException {
        return this.request.isDirectory();
    }

    protected final boolean isArchive() throws IASDeploymentException {
        return this.request.isArchive();
    }

    protected void addToSummary(String string) {
        this.summary.append(string);
        this.summary.append("\n");
    }

    protected void begin() throws IASDeploymentException {
        this.timeDeployStarted = System.currentTimeMillis();
        ContextRootChecker.checkTimeStamp(this.instanceEnv);
        try {
            this.instanceEnv.verify();
        }
        catch (Exception exception) {
            throw new IASDeploymentException(exception);
        }
    }

    protected void addEJBCTime(IASEJBCTimes iASEJBCTimes) {
        this.ejbcTime += iASEJBCTimes.getTotalTime();
        this.ejbcTiming = iASEJBCTimes;
    }

    protected void addJSPCTime(long l) {
        this.jspcTime += l;
    }

    protected final void finish() {
        long l = System.currentTimeMillis() - this.timeDeployStarted;
        if (l <= 0L) {
            l = 1L;
        }
        int n = (int)((double)this.ejbcTime / (double)l * 100.0);
        int n2 = (int)((double)this.jspcTime / (double)l * 100.0);
        this.deleteLockFile();
        StringBuffer stringBuffer = new StringBuffer("Total Deployment Time: ");
        stringBuffer.append(l);
        stringBuffer.append(" msec, ");
        if (this.jspcTime > 0L) {
            stringBuffer.append("Total JSP Compile Time: ");
            stringBuffer.append(this.jspcTime);
            stringBuffer.append(" msec (").append(n2).append("%),  ");
        }
        stringBuffer.append("Total EJB Compiler Module Time: ");
        stringBuffer.append(this.ejbcTime);
        stringBuffer.append(" msec, Portion spent EJB Compiling: ");
        stringBuffer.append(n);
        stringBuffer.append("%");
        if (this.ejbcTiming != null) {
            stringBuffer.append("\nBreakdown of EJBC Module Time: " + this.ejbcTiming);
        }
        this.logger.info(stringBuffer.toString());
        this.logger.finer(this.toString());
        this.releaseClassLoader();
    }

    private final void releaseClassLoader() {
        try {
            ClassLoader classLoader;
            ClassLoader classLoader2 = this.request.getParentClassLoader();
            if (classLoader2 != null && classLoader2 instanceof EJBClassLoader) {
                ((EJBClassLoader)classLoader2).done();
            }
            if ((classLoader = this.request.getEjbClassLoader()) != null && classLoader instanceof EJBClassLoader) {
                ((EJBClassLoader)classLoader).done();
            }
        }
        catch (Exception exception) {}
    }

    protected final void createLockFile(File file) throws IASDeploymentException {
        if (file == null) {
            String string = localStrings.getString("enterprise.deployment.backend.createlock_on_null_file");
            throw new IASDeploymentException(string);
        }
        if (!FileUtils.safeIsDirectory(file)) {
            file.mkdirs();
        }
        if (!FileUtils.safeIsDirectory(file)) {
            String string = localStrings.getString("enterprise.deployment.backend.cannot_create_lockfile", file.getPath() + File.separatorChar + Deployer.getLockFileName());
            throw new IASDeploymentException(string);
        }
        this.lockFile = new File(file, Deployer.getLockFileName());
        try {
            this.lockFile.createNewFile();
        }
        catch (IOException iOException) {
            String string = localStrings.getString("enterprise.deployment.backend.error_creating_lockfile", this.lockFile.getPath(), iOException);
            throw new IASDeploymentException(string);
        }
    }

    protected void DeleteOrKeepFailedStubs(File file) {
        if (!FileUtils.safeIsDirectory(file)) {
            return;
        }
        if (keepFailedStubsValue) {
            File file2 = new File(file.getPath() + FAILED_SUFFIX);
            FileUtils.whack(file2);
            file.renameTo(file2);
            this.logger.info("com.sun.aas.deployment.KeepFailedStubs is set.  Backdoor is open.  Saving failed generated ejb files in: " + file2.getPath());
        } else {
            FileUtils.whack(file);
        }
    }

    private final void deleteLockFile() {
        if (this.lockFile != null) {
            this.lockFile.delete();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        String string = DeploymentUtils.getSystemPropertyIgnoreCase("com.sun.aas.deployment.KeepFailedStubs");
        keepFailedStubsValue = string != null && string.compareToIgnoreCase("true") == 0;
    }
}

