/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.cis.connection;

import com.iplanet.ias.cis.channel.Channel;
import com.iplanet.ias.cis.channel.ChannelException;
import com.iplanet.ias.cis.connection.ConnectionException;
import com.iplanet.ias.cis.connection.ConnectionInputStream;
import com.iplanet.ias.cis.connection.NotSupportedException;
import java.io.IOException;
import java.nio.ByteBuffer;

public class BlockingConnectionInputStream
extends ConnectionInputStream {
    private Channel channel;
    private final boolean isMarked = false;
    private boolean validStream;

    public BlockingConnectionInputStream(Channel channel) throws ConnectionException {
        this.channel = channel;
        this.validStream = true;
    }

    private void isNotValidStream() throws IOException {
        if (!this.validStream) {
            throw new IOException("Stream already closed");
        }
    }

    public int available() throws IOException {
        this.isNotValidStream();
        return 0;
    }

    public void close() throws IOException {
        this.isNotValidStream();
        this.validStream = false;
    }

    public void mark(int n) {
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        int n;
        this.isNotValidStream();
        byte[] byArray = new byte[1];
        try {
            n = this.channel.recv(byArray, 0, 1, -1);
        }
        catch (ChannelException channelException) {
            throw new IOException(channelException.getMessage());
        }
        if (n == -1) {
            return -1;
        }
        return byArray[0] & 0xFF;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (!this.validStream) {
            throw new IOException("Stream already closed");
        }
        try {
            return this.channel.recv(byArray, n, n2, -1);
        }
        catch (ChannelException channelException) {
            throw new IOException(channelException.getMessage());
        }
    }

    public void reset() throws IOException {
        this.isNotValidStream();
        throw new IOException("mark/reset not supported");
    }

    public long skip(long l) throws IOException {
        this.isNotValidStream();
        return l;
    }

    public int read(ByteBuffer byteBuffer, int n) throws IOException, NotSupportedException {
        throw new NotSupportedException();
    }

    public int read(byte[] byArray, int n) throws IOException, NotSupportedException {
        throw new NotSupportedException();
    }

    public int read(byte[] byArray, int n, int n2, int n3) throws IOException, NotSupportedException {
        throw new NotSupportedException();
    }

    public boolean readBoolean() throws IOException, NotSupportedException {
        throw new NotSupportedException();
    }

    public char readChar() throws IOException, NotSupportedException {
        throw new NotSupportedException();
    }

    public short readShort() throws IOException, NotSupportedException {
        throw new NotSupportedException();
    }

    public int readInt() throws IOException, NotSupportedException {
        throw new NotSupportedException();
    }

    public long readLong() throws IOException, NotSupportedException {
        throw new NotSupportedException();
    }

    public float readFloat() throws IOException, NotSupportedException {
        throw new NotSupportedException();
    }

    public double readDouble() throws IOException, NotSupportedException {
        throw new NotSupportedException();
    }
}

