/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.cis.channel.ssl;

import com.iplanet.ias.cis.channel.ChannelException;
import java.util.HashMap;

public class CipherUtils {
    private static final String[] supportedCiphers = new String[]{"SSL_EN_RC4_128_WITH_MD5", "SSL_EN_RC4_128_EXPORT40_WITH_MD5", "SSL_EN_RC2_128_CBC_WITH_MD5", "SSL_EN_RC2_128_CBC_EXPORT40_WITH_MD5", "SSL_EN_DES_64_CBC_WITH_MD5", "SSL_EN_DES_192_EDE3_CBC_WITH_MD5", "SSL_RSA_WITH_RC4_128_MD5", "SSL_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_WITH_DES_CBC_SHA", "SSL_RSA_EXPORT_WITH_RC4_40_MD5", "SSL_RSA_EXPORT_WITH_RC2_CBC_40_MD5", "SSL_RSA_WITH_NULL_MD5", "TLS_RSA_EXPORT1024_WITH_DES_CBC_SHA", "TLS_RSA_EXPORT1024_WITH_RC4_56_SHA"};
    public static final String[] ssl2Ciphers = new String[]{"rc4", "rc4export", "rc2", "rc2export", "des", "desede3"};
    public static final String[] ssl3Ciphers = new String[]{"rsa_rc4_128_md5", "rsa_3des_sha", "rsa_des_sha", "rsa_rc4_40_md5", "rsa_rc2_40_md5", "rsa_null_md5", "rsa_des_56_sha", "rsa_rc4_56_sha"};
    public static HashMap cipherMap = new HashMap();
    public static HashMap ssl2CipherMap = new HashMap();
    public static HashMap ssl3CipherMap = new HashMap();

    public static int[] getCipherIDs(String[] stringArray) throws ChannelException {
        int[] nArray = new int[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            Integer n2 = (Integer)cipherMap.get(stringArray[n]);
            if (n2 == null) {
                throw new ChannelException("Invalid cipher specified: " + stringArray[n]);
            }
            nArray[n] = n2;
            ++n;
        }
        return nArray;
    }

    public static int[] getSsl2CipherIDs(String[] stringArray) throws ChannelException {
        if (stringArray == null) {
            return null;
        }
        int[] nArray = new int[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            Integer n2 = (Integer)ssl2CipherMap.get(stringArray[n]);
            if (n2 == null) {
                throw new ChannelException("Invalid cipher specified: " + stringArray[n]);
            }
            nArray[n] = n2;
            ++n;
        }
        return nArray;
    }

    public static int[] getSsl3CipherIDs(String[] stringArray) throws ChannelException {
        if (stringArray == null) {
            return null;
        }
        int[] nArray = new int[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            Integer n2 = (Integer)ssl3CipherMap.get(stringArray[n]);
            if (n2 == null) {
                throw new ChannelException("Invalid cipher specified: " + stringArray[n]);
            }
            nArray[n] = n2;
            ++n;
        }
        return nArray;
    }

    static {
        int n = 0;
        while (n < supportedCiphers.length) {
            cipherMap.put(supportedCiphers[n], new Integer(n));
            ++n;
        }
        int n2 = 0;
        while (n2 < ssl2Ciphers.length) {
            ssl2CipherMap.put(ssl2Ciphers[n2], new Integer(n2));
            ++n2;
        }
        int n3 = 0;
        while (n3 < ssl3Ciphers.length) {
            ssl3CipherMap.put(ssl3Ciphers[n3], new Integer(n3));
            ++n3;
        }
    }
}

