/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.cis.channel;

import com.iplanet.ias.cis.LogWrap;
import com.iplanet.ias.cis.channel.Channel;
import com.iplanet.ias.cis.channel.ChannelException;
import com.iplanet.ias.cis.channel.ServerChannel;
import com.iplanet.ias.cis.channel.ssl.SSLBlockingChannel;
import com.iplanet.ias.cis.channel.ssl.SSLBlockingServerChannel;
import com.iplanet.ias.cis.channel.tcp.TCPChannelFactory;
import com.iplanet.ias.cis.channel.tcp.TCPPoll;
import com.iplanet.ias.cis.connection.EndPoint;
import java.util.logging.Level;

public final class ChannelManager {
    protected static int iPollTimeout = 1000;
    private static ChannelManager channelManager = new ChannelManager();
    private TCPChannelFactory tcpFactory = TCPChannelFactory.getTCPChannelFactory();

    private ChannelManager() {
    }

    public static ChannelManager getChannelManager() {
        return channelManager;
    }

    public Channel createChannel(EndPoint endPoint, EndPoint endPoint2, boolean bl, int n, int n2, int n3) throws ChannelException {
        if (endPoint2.getType().equals("IIOP_CLEAR_TEXT")) {
            return this.tcpFactory.createChannel(endPoint, endPoint2, bl, n, n2, n3);
        }
        throw new ChannelException("Invalid type: " + endPoint2.getType());
    }

    public Channel createChannel(EndPoint endPoint, EndPoint endPoint2, String string, int n, String[] stringArray, String[] stringArray2, boolean bl) throws ChannelException {
        if (endPoint2.getType().indexOf("SSL") != -1) {
            return new SSLBlockingChannel(endPoint, endPoint2, string, n, stringArray, stringArray2, bl);
        }
        throw new ChannelException("Invalid type: " + endPoint2.getType());
    }

    public ServerChannel createServerChannel(EndPoint endPoint, boolean bl, int n) throws ChannelException {
        if (endPoint.getType().equals("IIOP_CLEAR_TEXT")) {
            return this.tcpFactory.createServerChannel(endPoint, bl, n);
        }
        throw new ChannelException("Invalid type: " + endPoint.getType());
    }

    public ServerChannel createServerChannel(EndPoint endPoint, String string, int n, String[] stringArray, String[] stringArray2, boolean bl, int n2) throws ChannelException {
        if (endPoint.getType().indexOf("SSL") != -1) {
            return new SSLBlockingServerChannel(endPoint, string, n, stringArray, stringArray2, bl, n2);
        }
        throw new ChannelException("Invalid type: " + endPoint.getType());
    }

    public int[] poll(Channel[] channelArray) {
        try {
            return TCPPoll.poll(channelArray, iPollTimeout);
        }
        catch (ChannelException channelException) {
            LogWrap.logger.log(Level.SEVERE, "cis.16", channelException);
            return null;
        }
    }
}

