/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.server.core.mbean.config;

import com.iplanet.ias.admin.server.core.mbean.config.Resource;
import com.iplanet.ias.util.i18n.StringManager;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ResourcesXMLParser {
    private File resourceFile = null;
    private Document document;
    private Vector resources;
    private static final String CUSTOM_RESOURCE = "custom-resource";
    private static final String EXT_JNDI_RESOURCE = "external-jndi-resource";
    private static final String JDBC_RESOURCE = "jdbc-resource";
    private static final String JDBC_CONN_POOL = "jdbc-connection-pool";
    private static final String MAIL_RESOURCE = "mail-resource";
    private static final String PERSISTENCE_RESOURCE = "persistence-manager-factory-resource";
    private static final String JMS_RESOURCE = "jms-resource";
    private static StringManager localStrings = StringManager.getManager(class$com$iplanet$ias$admin$server$core$mbean$config$ResourcesXMLParser == null ? (class$com$iplanet$ias$admin$server$core$mbean$config$ResourcesXMLParser = ResourcesXMLParser.class$("com.iplanet.ias.admin.server.core.mbean.config.ResourcesXMLParser")) : class$com$iplanet$ias$admin$server$core$mbean$config$ResourcesXMLParser);
    public static final String JNDI_NAME = "jndi-name";
    public static final String POOL_NAME = "pool-name";
    public static final String RES_TYPE = "res-type";
    public static final String FACTORY_CLASS = "factory-class";
    public static final String ENABLED = "enabled";
    public static final String JNDI_LOOKUP = "jndi-lookup-name";
    public static final String CONNECTION_POOL_NAME = "name";
    public static final String STEADY_POOL_SIZE = "steady-pool-size";
    public static final String MAX_POOL_SIZE = "max-pool-size";
    public static final String MAX_WAIT_TIME_IN_MILLIS = "max-wait-time-in-millis";
    public static final String POOL_SIZE_QUANTITY = "pool-resize-quantity";
    public static final String IDLE_TIME_OUT_IN_SECONDS = "idle-timeout-in-seconds";
    public static final String IS_CONNECTION_VALIDATION_REQUIRED = "is-connection-validation-required";
    public static final String CONNECTION_VALIDATION_METHOD = "connection-validation-method";
    public static final String FAIL_ALL_CONNECTIONS = "fail-all-connections";
    public static final String VALIDATION_TABLE_NAME = "validation-table-name";
    public static final String DATASOURCE_CLASS = "datasource-classname";
    public static final String TRANS_ISOLATION_LEVEL = "transaction-isolation-level";
    public static final String IS_ISOLATION_LEVEL_GUARANTEED = "is-isolation-level-guaranteed";
    public static final String MAIL_HOST = "host";
    public static final String MAIL_USER = "user";
    public static final String MAIL_FROM_ADDRESS = "from";
    public static final String MAIL_STORE_PROTO = "store-protocol";
    public static final String MAIL_STORE_PROTO_CLASS = "store-protocol-class";
    public static final String MAIL_TRANS_PROTO = "transport-protocol";
    public static final String MAIL_TRANS_PROTO_CLASS = "transport-protocol-class";
    public static final String MAIL_DEBUG = "debug";
    public static final String JDBC_RESOURCE_JNDI_NAME = "jdbc-resource-jndi-name";
    static /* synthetic */ Class class$com$iplanet$ias$admin$server$core$mbean$config$ResourcesXMLParser;

    public ResourcesXMLParser(String string) throws Exception {
        this.resourceFile = new File(string);
        this.initProperties();
        this.resources = new Vector();
        this.generateResourceObjects();
    }

    public void initProperties() throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            documentBuilderFactory.setValidating(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            if (this.resourceFile == null) {
                String string = localStrings.getString("admin.server.core.mbean.config.no_resource_file");
                throw new Exception(string);
            }
            InputSource inputSource = new InputSource(this.resourceFile.toString());
            this.document = documentBuilder.parse(inputSource);
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            throw new Exception(exception.getLocalizedMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new Exception(parserConfigurationException.getLocalizedMessage());
        }
        catch (IOException iOException) {
            throw new Exception(iOException.getLocalizedMessage());
        }
    }

    private void generateResourceObjects() throws Exception {
        if (this.document != null) {
            Node node = this.document.getDocumentElement().getFirstChild();
            while (node != null) {
                String string = node.getNodeName();
                if (string.equalsIgnoreCase(CUSTOM_RESOURCE)) {
                    this.generateCustomResource(node);
                } else if (string.equalsIgnoreCase(EXT_JNDI_RESOURCE)) {
                    this.generateJNDIResource(node);
                } else if (string.equalsIgnoreCase(JDBC_RESOURCE)) {
                    this.generateJDBCResource(node);
                } else if (string.equalsIgnoreCase(JDBC_CONN_POOL)) {
                    this.generateJDBCConnectionPoolResource(node);
                } else if (string.equalsIgnoreCase(MAIL_RESOURCE)) {
                    this.generateMailResource(node);
                } else if (string.equalsIgnoreCase(PERSISTENCE_RESOURCE)) {
                    this.generatePersistenceResource(node);
                } else if (string.equalsIgnoreCase(JMS_RESOURCE)) {
                    this.generateJMSResource(node);
                }
                node = node.getNextSibling();
            }
        }
    }

    private void generateCustomResource(Node node) throws Exception {
        Object object;
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap == null) {
            return;
        }
        Node node2 = namedNodeMap.getNamedItem(JNDI_NAME);
        String string = node2.getNodeValue();
        Node node3 = namedNodeMap.getNamedItem(RES_TYPE);
        String string2 = node3.getNodeValue();
        Node node4 = namedNodeMap.getNamedItem(FACTORY_CLASS);
        String string3 = node4.getNodeValue();
        Node node5 = namedNodeMap.getNamedItem(ENABLED);
        Resource resource = new Resource(6);
        resource.setAttribute(JNDI_NAME, string);
        resource.setAttribute(RES_TYPE, string2);
        resource.setAttribute(FACTORY_CLASS, string3);
        if (node5 != null) {
            object = node5.getNodeValue();
            resource.setAttribute(ENABLED, (String)object);
        }
        object = node.getChildNodes();
        this.generatePropertyElement(resource, (NodeList)object);
        this.resources.add(resource);
        this.printResourceElements(resource);
    }

    private void generateJNDIResource(Node node) throws Exception {
        Object object;
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap == null) {
            return;
        }
        Node node2 = namedNodeMap.getNamedItem(JNDI_NAME);
        String string = node2.getNodeValue();
        Node node3 = namedNodeMap.getNamedItem(JNDI_LOOKUP);
        String string2 = node3.getNodeValue();
        Node node4 = namedNodeMap.getNamedItem(RES_TYPE);
        String string3 = node4.getNodeValue();
        Node node5 = namedNodeMap.getNamedItem(FACTORY_CLASS);
        String string4 = node5.getNodeValue();
        Node node6 = namedNodeMap.getNamedItem(ENABLED);
        Resource resource = new Resource(7);
        resource.setAttribute(JNDI_NAME, string);
        resource.setAttribute(JNDI_LOOKUP, string2);
        resource.setAttribute(RES_TYPE, string3);
        resource.setAttribute(FACTORY_CLASS, string4);
        if (node6 != null) {
            object = node6.getNodeValue();
            resource.setAttribute(ENABLED, (String)object);
        }
        object = node.getChildNodes();
        this.generatePropertyElement(resource, (NodeList)object);
        this.resources.add(resource);
        this.printResourceElements(resource);
    }

    private void generateJDBCResource(Node node) throws Exception {
        Object object;
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap == null) {
            return;
        }
        Node node2 = namedNodeMap.getNamedItem(JNDI_NAME);
        String string = node2.getNodeValue();
        Node node3 = namedNodeMap.getNamedItem(POOL_NAME);
        String string2 = node3.getNodeValue();
        Node node4 = namedNodeMap.getNamedItem(ENABLED);
        Resource resource = new Resource(4);
        resource.setAttribute(JNDI_NAME, string);
        resource.setAttribute(POOL_NAME, string2);
        if (node4 != null) {
            object = node4.getNodeValue();
            resource.setAttribute(ENABLED, (String)object);
        }
        if ((object = node.getChildNodes()) != null) {
            int n = 0;
            while (n < object.getLength()) {
                if (object.item(n).getNodeName().equals("description")) {
                    resource.setDescription(object.item(n).getFirstChild().getNodeValue());
                }
                ++n;
            }
        }
        this.resources.add(resource);
        this.printResourceElements(resource);
    }

    private void generateJDBCConnectionPoolResource(Node node) throws Exception {
        Object object;
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap == null) {
            return;
        }
        Node node2 = namedNodeMap.getNamedItem(CONNECTION_POOL_NAME);
        String string = node2.getNodeValue();
        Node node3 = namedNodeMap.getNamedItem(STEADY_POOL_SIZE);
        Node node4 = namedNodeMap.getNamedItem(MAX_POOL_SIZE);
        Node node5 = namedNodeMap.getNamedItem(MAX_WAIT_TIME_IN_MILLIS);
        Node node6 = namedNodeMap.getNamedItem(POOL_SIZE_QUANTITY);
        Node node7 = namedNodeMap.getNamedItem(IDLE_TIME_OUT_IN_SECONDS);
        Node node8 = namedNodeMap.getNamedItem(IS_CONNECTION_VALIDATION_REQUIRED);
        Node node9 = namedNodeMap.getNamedItem(CONNECTION_VALIDATION_METHOD);
        Node node10 = namedNodeMap.getNamedItem(FAIL_ALL_CONNECTIONS);
        Node node11 = namedNodeMap.getNamedItem(VALIDATION_TABLE_NAME);
        Node node12 = namedNodeMap.getNamedItem(RES_TYPE);
        Node node13 = namedNodeMap.getNamedItem(TRANS_ISOLATION_LEVEL);
        Node node14 = namedNodeMap.getNamedItem(IS_ISOLATION_LEVEL_GUARANTEED);
        Node node15 = namedNodeMap.getNamedItem(DATASOURCE_CLASS);
        String string2 = node15.getNodeValue();
        Resource resource = new Resource(5);
        resource.setAttribute(CONNECTION_POOL_NAME, string);
        resource.setAttribute(DATASOURCE_CLASS, string2);
        if (node3 != null) {
            object = node3.getNodeValue();
            resource.setAttribute(STEADY_POOL_SIZE, (String)object);
        }
        if (node4 != null) {
            object = node4.getNodeValue();
            resource.setAttribute(MAX_POOL_SIZE, (String)object);
        }
        if (node5 != null) {
            object = node5.getNodeValue();
            resource.setAttribute(MAX_WAIT_TIME_IN_MILLIS, (String)object);
        }
        if (node6 != null) {
            object = node6.getNodeValue();
            resource.setAttribute(POOL_SIZE_QUANTITY, (String)object);
        }
        if (node7 != null) {
            object = node7.getNodeValue();
            resource.setAttribute(IDLE_TIME_OUT_IN_SECONDS, (String)object);
        }
        if (node8 != null) {
            object = node8.getNodeValue();
            resource.setAttribute(IS_CONNECTION_VALIDATION_REQUIRED, (String)object);
        }
        if (node9 != null) {
            object = node9.getNodeValue();
            resource.setAttribute(CONNECTION_VALIDATION_METHOD, (String)object);
        }
        if (node10 != null) {
            object = node10.getNodeValue();
            resource.setAttribute(FAIL_ALL_CONNECTIONS, (String)object);
        }
        if (node11 != null) {
            object = node11.getNodeValue();
            resource.setAttribute(VALIDATION_TABLE_NAME, (String)object);
        }
        if (node12 != null) {
            object = node12.getNodeValue();
            resource.setAttribute(RES_TYPE, (String)object);
        }
        if (node13 != null) {
            object = node13.getNodeValue();
            resource.setAttribute(TRANS_ISOLATION_LEVEL, (String)object);
        }
        if (node14 != null) {
            object = node14.getNodeValue();
            resource.setAttribute(IS_ISOLATION_LEVEL_GUARANTEED, (String)object);
        }
        object = node.getChildNodes();
        this.generatePropertyElement(resource, (NodeList)object);
        this.resources.add(resource);
        this.printResourceElements(resource);
    }

    private void generateMailResource(Node node) throws Exception {
        Object object;
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap == null) {
            return;
        }
        Node node2 = namedNodeMap.getNamedItem(JNDI_NAME);
        Node node3 = namedNodeMap.getNamedItem(MAIL_HOST);
        Node node4 = namedNodeMap.getNamedItem(MAIL_USER);
        Node node5 = namedNodeMap.getNamedItem(MAIL_FROM_ADDRESS);
        Node node6 = namedNodeMap.getNamedItem(MAIL_STORE_PROTO);
        Node node7 = namedNodeMap.getNamedItem(MAIL_STORE_PROTO_CLASS);
        Node node8 = namedNodeMap.getNamedItem(MAIL_TRANS_PROTO);
        Node node9 = namedNodeMap.getNamedItem(MAIL_TRANS_PROTO_CLASS);
        Node node10 = namedNodeMap.getNamedItem(MAIL_DEBUG);
        Node node11 = namedNodeMap.getNamedItem(ENABLED);
        String string = node2.getNodeValue();
        String string2 = node3.getNodeValue();
        String string3 = node4.getNodeValue();
        String string4 = node5.getNodeValue();
        Resource resource = new Resource(2);
        resource.setAttribute(JNDI_NAME, string);
        resource.setAttribute(MAIL_HOST, string2);
        resource.setAttribute(MAIL_USER, string3);
        resource.setAttribute(MAIL_FROM_ADDRESS, string4);
        if (node6 != null) {
            object = node6.getNodeValue();
            resource.setAttribute(MAIL_STORE_PROTO, (String)object);
        }
        if (node7 != null) {
            object = node7.getNodeValue();
            resource.setAttribute(MAIL_STORE_PROTO_CLASS, (String)object);
        }
        if (node8 != null) {
            object = node8.getNodeValue();
            resource.setAttribute(MAIL_TRANS_PROTO, (String)object);
        }
        if (node9 != null) {
            object = node9.getNodeValue();
            resource.setAttribute(MAIL_TRANS_PROTO_CLASS, (String)object);
        }
        if (node10 != null) {
            object = node10.getNodeValue();
            resource.setAttribute(MAIL_DEBUG, (String)object);
        }
        if (node11 != null) {
            object = node11.getNodeValue();
            resource.setAttribute(ENABLED, (String)object);
        }
        object = node.getChildNodes();
        this.generatePropertyElement(resource, (NodeList)object);
        this.resources.add(resource);
        this.printResourceElements(resource);
    }

    private void generatePersistenceResource(Node node) throws Exception {
        Object object;
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap == null) {
            return;
        }
        Node node2 = namedNodeMap.getNamedItem(JNDI_NAME);
        String string = node2.getNodeValue();
        Node node3 = namedNodeMap.getNamedItem(FACTORY_CLASS);
        Node node4 = namedNodeMap.getNamedItem(JDBC_RESOURCE_JNDI_NAME);
        Node node5 = namedNodeMap.getNamedItem(ENABLED);
        Resource resource = new Resource(3);
        resource.setAttribute(JNDI_NAME, string);
        if (node3 != null) {
            object = node3.getNodeValue();
            resource.setAttribute(FACTORY_CLASS, (String)object);
        }
        if (node4 != null) {
            object = node4.getNodeValue();
            resource.setAttribute(JDBC_RESOURCE_JNDI_NAME, (String)object);
        }
        if (node5 != null) {
            object = node5.getNodeValue();
            resource.setAttribute(ENABLED, (String)object);
        }
        object = node.getChildNodes();
        this.generatePropertyElement(resource, (NodeList)object);
        this.resources.add(resource);
        this.printResourceElements(resource);
    }

    private void generateJMSResource(Node node) throws Exception {
        Object object;
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap == null) {
            return;
        }
        Node node2 = namedNodeMap.getNamedItem(JNDI_NAME);
        String string = node2.getNodeValue();
        Node node3 = namedNodeMap.getNamedItem(RES_TYPE);
        String string2 = node3.getNodeValue();
        Node node4 = namedNodeMap.getNamedItem(ENABLED);
        Resource resource = new Resource(1);
        resource.setAttribute(JNDI_NAME, string);
        resource.setAttribute(RES_TYPE, string2);
        if (node4 != null) {
            object = node4.getNodeValue();
            resource.setAttribute(ENABLED, (String)object);
        }
        object = node.getChildNodes();
        this.generatePropertyElement(resource, (NodeList)object);
        this.resources.add(resource);
        this.printResourceElements(resource);
    }

    private void generatePropertyElement(Resource resource, NodeList nodeList) throws Exception {
        if (nodeList != null) {
            int n = 0;
            while (n < nodeList.getLength()) {
                if (nodeList.item(n).getNodeName().equals("property")) {
                    NamedNodeMap namedNodeMap = nodeList.item(n).getAttributes();
                    Node node = namedNodeMap.getNamedItem(CONNECTION_POOL_NAME);
                    Node node2 = namedNodeMap.getNamedItem("value");
                    if (node != null && node2 != null) {
                        boolean bl = false;
                        String string = node.getNodeValue();
                        String string2 = node2.getNodeValue();
                        Node node3 = nodeList.item(n).getFirstChild();
                        while (node3 != null && !bl) {
                            if (node3.getNodeName().equalsIgnoreCase("description")) {
                                try {
                                    resource.setElementProperty(string, string2, node3.getFirstChild().getNodeValue());
                                    bl = true;
                                }
                                catch (DOMException dOMException) {
                                    throw new Exception(dOMException.getLocalizedMessage());
                                }
                            }
                            node3 = node3.getNextSibling();
                        }
                        if (!bl) {
                            resource.setElementProperty(string, string2);
                        }
                    }
                }
                if (nodeList.item(n).getNodeName().equals("description")) {
                    resource.setDescription(nodeList.item(n).getFirstChild().getNodeValue());
                }
                ++n;
            }
        }
    }

    public Iterator getResources() {
        return this.resources.iterator();
    }

    private void printResourceElements(Resource resource) {
        Properties properties = resource.getAttributes();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Logger logger = Logger.getLogger("javax.enterprise.system.tools.admin");
            logger.log(Level.FINE, "general.print_attr_name", string);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

