/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.server.core.mbean.config;

import com.iplanet.ias.admin.common.EntityStatus;
import com.iplanet.ias.admin.common.constant.ConfigAttributeName;
import com.iplanet.ias.admin.common.exception.J2EEEjbJarModuleException;
import com.iplanet.ias.admin.common.exception.MBeanConfigException;
import com.iplanet.ias.admin.server.core.mbean.config.ConfigMBeanBase;
import com.iplanet.ias.admin.server.core.mbean.config.ModulesXMLHelper;
import com.iplanet.ias.config.serverbeans.ServerTags;
import javax.management.Attribute;

public class ManagedStandaloneJ2EEEjbJarModule
extends ConfigMBeanBase
implements ConfigAttributeName.StandaloneEjbJarModule {
    private static final String[][] MAPLIST = new String[][]{{"name", "@" + ServerTags.NAME}, {"location", "@" + ServerTags.LOCATION}, {"enabled", "@" + ServerTags.ENABLED}, {"description", "@" + ConfigMBeanBase.PSEUDO_ATTR_DESCRIPTION}};
    private static final String[] ATTRIBUTES = new String[]{"name, String,     R", "location, String,     RW", "enabled, boolean,    RW", "description, String,     RW"};
    private static final String[] OPERATIONS = new String[]{"getStatus(),   INFO", "enable(),      ACTION", "disable(),     ACTION", "getEnterpriseBeans(),   INFO", "getSessionEJBs(),   INFO", "getEntityEJBs(),   INFO"};

    public ManagedStandaloneJ2EEEjbJarModule() throws MBeanConfigException {
        this.setDescriptions(MAPLIST, ATTRIBUTES, OPERATIONS);
    }

    public ManagedStandaloneJ2EEEjbJarModule(String string, String string2) throws MBeanConfigException {
        this();
        this.initialize("standalone-ejb-module", new String[]{string, string2});
    }

    public EntityStatus getStatus() throws J2EEEjbJarModuleException {
        EntityStatus entityStatus = null;
        try {
            boolean bl = (Boolean)this.getAttribute("enabled");
            entityStatus = new EntityStatus();
            if (bl) {
                entityStatus.setEnabled();
            } else {
                entityStatus.setDisabled();
            }
        }
        catch (Exception exception) {
            ConfigMBeanBase.sLogger.throwing(this.getClass().getName(), "getStatus", exception);
            throw new J2EEEjbJarModuleException(exception.getMessage());
        }
        return entityStatus;
    }

    public void disable() throws J2EEEjbJarModuleException {
        try {
            this.setAttribute(new Attribute("enabled", new Boolean(false)));
            super.getConfigContext().flush();
        }
        catch (Exception exception) {
            ConfigMBeanBase.sLogger.throwing(this.getClass().getName(), "disable", exception);
            throw new J2EEEjbJarModuleException(exception.getMessage());
        }
    }

    public void enable() throws J2EEEjbJarModuleException {
        try {
            this.setAttribute(new Attribute("enabled", new Boolean(true)));
            super.getConfigContext().flush();
        }
        catch (Exception exception) {
            ConfigMBeanBase.sLogger.throwing(this.getClass().getName(), "enable", exception);
            throw new J2EEEjbJarModuleException(exception.getMessage());
        }
    }

    public String[] getEnterpriseBeans() throws J2EEEjbJarModuleException {
        return this.getBeansByType(255);
    }

    public String[] getSessionEJBs() throws J2EEEjbJarModuleException {
        return this.getBeansByType(1);
    }

    public String[] getEntityEJBs() throws J2EEEjbJarModuleException {
        return this.getBeansByType(2);
    }

    private String[] getBeansByType(int n) throws J2EEEjbJarModuleException {
        try {
            String string = (String)this.getAttribute("location");
            return ModulesXMLHelper.getEnterpriseBeansForEjbModule(string, null, n);
        }
        catch (Exception exception) {
            ConfigMBeanBase.sLogger.throwing(this.getClass().getName(), "getBeansByType", exception);
            throw new J2EEEjbJarModuleException(exception.getMessage());
        }
    }
}

