/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.monitor;

import com.iplanet.ias.admin.monitor.BaseMonitorMBean;
import com.iplanet.ias.admin.monitor.MonitorCommand;
import com.iplanet.ias.admin.monitor.MonitoredObjectType;
import com.iplanet.ias.admin.monitor.MonitoringHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.ObjectName;

public class MonitorGetCommand
extends MonitorCommand {
    private static final int GET_ATTR = 2;
    private static final int GET_ALL_ATTR = 4;
    private static final int GET_ATTR_FOR_TYPE = 6;
    private static final int GET_ALL_ATTR_FOR_TYPE = 8;
    private String attrName;
    private static final String WILDCARD = "*";

    MonitorGetCommand(ObjectName objectName, String string) {
        this.objectName = objectName;
        this.attrName = string;
        this.actionCode = WILDCARD.equals(string) ? 4 : 2;
    }

    MonitorGetCommand(ObjectName objectName, MonitoredObjectType monitoredObjectType, String string) {
        this.objectName = objectName;
        this.monitoredObjectType = monitoredObjectType.getTypeName();
        this.attrName = string;
        this.actionCode = WILDCARD.equals(string) ? 8 : 6;
    }

    Object runCommand() throws InstanceNotFoundException, AttributeNotFoundException {
        BaseMonitorMBean baseMonitorMBean = MonitoringHelper.getMonitorMBean(this.objectName);
        MonitoredObjectType monitoredObjectType = null;
        if (this.monitoredObjectType != null) {
            monitoredObjectType = MonitoredObjectType.getMonitoredObjectType(this.monitoredObjectType);
        }
        ArrayList<BaseMonitorMBean> arrayList = null;
        if (this.actionCode == 6 || this.actionCode == 8) {
            arrayList = baseMonitorMBean.getChildList(monitoredObjectType);
        } else {
            arrayList = new ArrayList<BaseMonitorMBean>();
            arrayList.add(baseMonitorMBean);
        }
        AttributeList attributeList = new AttributeList();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Serializable serializable;
            String[] stringArray;
            BaseMonitorMBean baseMonitorMBean2 = (BaseMonitorMBean)iterator.next();
            if (this.actionCode == 2 || this.actionCode == 6) {
                stringArray = baseMonitorMBean2.getAttribute(this.attrName);
                serializable = null;
                serializable = this.actionCode == 6 ? new Attribute(this.getQualifiedName(baseMonitorMBean2, monitoredObjectType, this.attrName), stringArray) : new Attribute(this.attrName, stringArray);
                attributeList.add((Attribute)serializable);
                continue;
            }
            if (this.actionCode != 4 && this.actionCode != 8) continue;
            stringArray = baseMonitorMBean2.getAllAttributeNames();
            serializable = baseMonitorMBean2.getAttributes(stringArray);
            if (this.actionCode == 8) {
                AttributeList attributeList2 = new AttributeList();
                int n = ((ArrayList)serializable).size();
                int n2 = 0;
                while (n2 < n) {
                    Attribute attribute = (Attribute)((ArrayList)serializable).get(n2);
                    attribute = new Attribute(this.getQualifiedName(baseMonitorMBean2, monitoredObjectType, attribute.getName()), attribute.getValue());
                    attributeList2.add(attribute);
                    ++n2;
                }
                serializable = attributeList2;
            }
            attributeList.addAll((AttributeList)serializable);
        }
        return attributeList;
    }

    private String getQualifiedName(BaseMonitorMBean baseMonitorMBean, MonitoredObjectType monitoredObjectType, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(baseMonitorMBean.getNodeType());
        if (!monitoredObjectType.isSingleton()) {
            stringBuffer.append("." + baseMonitorMBean.getNodeName());
        }
        stringBuffer.append("." + string);
        return stringBuffer.toString();
    }
}

