/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.schema2beans;

import java.util.ArrayList;
import org.netbeans.modules.schema2beans.BaseAttribute;
import org.netbeans.modules.schema2beans.Common;

public class AttrProp
implements BaseAttribute {
    public static final int MASK_KIND = 255;
    public static final int CDATA = 1;
    public static final int ENUM = 2;
    public static final int NMTOKEN = 3;
    public static final int ID = 4;
    public static final int IDREF = 5;
    public static final int IDREFS = 6;
    public static final int ENTITY = 7;
    public static final int ENTITIES = 8;
    public static final int NOTATION = 9;
    static final String[] kinds = new String[]{"CDATA", "ENUM", "NMTOKEN", "ID", "IDREF", "IDREFS", "ENTITY", "ENTITIES", "NOTATION"};
    static final int[] kindValues = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
    public static final int MASK_OPTION = 3840;
    public static final int REQUIRED = 256;
    public static final int IMPLIED = 512;
    public static final int FIXED = 768;
    public static final int TRANSIENT = 4096;
    static final String[] options = new String[]{"#REQUIRED", "#IMPLIED", "#FIXED"};
    static final int[] optionValues = new int[]{256, 512, 768};
    String propertyName;
    String name;
    String dtdName;
    int type;
    ArrayList values;
    String defaultValue;
    private int state;
    private int enumMode;
    private static final int NEED_NAME = 0;
    private static final int NEED_TYPE = 1;
    private static final int NEED_ENUM = 2;
    private static final int NEED_OPTION = 3;
    private static final int NEED_DEFVAL = 4;
    private static final int NEED_VALUE = 5;
    private static final int DONE = 6;

    public AttrProp() {
        this.values = null;
        this.state = 0;
        this.type = 0;
        this.enumMode = 0;
    }

    public AttrProp(String string) {
        this();
        this.propertyName = string;
    }

    public AttrProp(String string, String string2, String string3, int n, String[] stringArray, String string4) {
        this.dtdName = string2;
        this.name = string3;
        this.propertyName = string;
        if (stringArray != null && stringArray.length > 0) {
            this.values = new ArrayList();
            int n2 = 0;
            while (n2 < stringArray.length) {
                this.values.add(stringArray[n2]);
                ++n2;
            }
        }
        this.defaultValue = string4;
        this.state = 6;
        this.type = n;
    }

    void setEnum(boolean bl) {
        this.enumMode += bl ? 1 : -1;
        if (this.enumMode == 1) {
            if (this.values == null) {
                this.values = new ArrayList();
            }
            this.type = 2;
            this.state = 2;
        } else if (this.enumMode == 0) {
            this.state = 3;
        } else {
            this.failed(Common.getMessage("WrongEnumDecl_msg"));
        }
    }

    void addValue(String string) {
        if (string.charAt(0) == '\"') {
            string = string.substring(1, string.length() - 1);
        } else if (string.charAt(0) == '\'') {
            string = string.substring(1, string.length() - 1);
        }
        switch (this.state) {
            case 0: {
                this.dtdName = string;
                this.name = Common.convertName(string);
                this.state = 1;
                break;
            }
            case 1: {
                this.type = this.stringToInt(string, kinds, kindValues);
                this.state = 3;
                if (this.type != -1) break;
                this.failed(Common.getMessage("UnknownType_msg", string));
                break;
            }
            case 2: {
                this.values.add(string);
                break;
            }
            case 3: {
                int n = this.stringToInt(string, options, optionValues);
                if (n != -1) {
                    this.type |= n;
                    if (n == 768) {
                        this.state = 5;
                        break;
                    }
                    this.state = 6;
                    break;
                }
            }
            case 5: {
                this.defaultValue = string;
                this.state = 6;
                break;
            }
            case 6: {
                this.failed(Common.getMessage("TooMuchDeclaration_msg"));
            }
        }
    }

    public boolean isTransient() {
        return (this.type & 0x1000) == 4096;
    }

    boolean isComplete() {
        return this.state == 6;
    }

    public boolean hasName(String string) {
        return string.equals(this.name) || string.equals(this.dtdName);
    }

    public String[] getValues() {
        int n = 0;
        if (this.values != null) {
            n = this.values.size();
        }
        String[] stringArray = new String[n];
        if (n > 0) {
            return this.values.toArray(stringArray);
        }
        return stringArray;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    String getPropertyName() {
        return this.propertyName;
    }

    public String getName() {
        return this.name;
    }

    public String getDtdName() {
        return this.dtdName;
    }

    String typeAsString() {
        String string = "AttrProp." + this.intToString(this.type & 0xFF, kinds, kindValues);
        int n = this.type & 0xF00;
        if (n != 0) {
            string = string + " | AttrProp." + this.intToString(n, options, optionValues).substring(1);
        }
        return string;
    }

    String enumsToString() {
        String[] stringArray = this.getValues();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n]);
            stringBuffer.append(" ");
            ++n;
        }
        return stringBuffer.toString();
    }

    void validate() {
        if (this.state != 6) {
            this.failed(Common.getMessage("BadAttributeDecl_msg"));
        }
    }

    void checkEnum() {
        if (this.enumMode == 0) {
            this.failed(Common.getMessage("UseCharORWithEnum_msg"));
        }
    }

    public boolean isEnum() {
        return (this.type & 0xFF) == 2;
    }

    public boolean isFixed() {
        return (this.type & 0xF00) == 768;
    }

    public int getType() {
        return this.type & 0xFF;
    }

    public int getOption() {
        return this.type & 0xF00;
    }

    int stringToInt(String string, String[] stringArray, int[] nArray) {
        int n = 0;
        while (n < stringArray.length) {
            if (string.equals(stringArray[n])) {
                return nArray[n];
            }
            ++n;
        }
        return -1;
    }

    String intToString(int n, String[] stringArray, int[] nArray) {
        int n2 = 0;
        while (n2 < nArray.length) {
            if (n == nArray[n2]) {
                return stringArray[n2];
            }
            ++n2;
        }
        return "?";
    }

    private void failed(String string) {
        throw new RuntimeException(Common.getMessage("ATTLISTParseError_msg", this.name, string));
    }

    public String toString() {
        String string = this.name + " " + this.intToString(this.type & 0xFF, kinds, kindValues) + " ";
        int n = this.type & 0xF00;
        if (n != 0) {
            string = string + this.intToString(n, options, optionValues) + " ";
        }
        if (this.values != null) {
            int n2 = this.values.size();
            string = string + "( ";
            int n3 = 0;
            while (n3 < n2) {
                string = string + this.values.get(n3) + " ";
                ++n3;
            }
            string = string + ") ";
        }
        if (this.defaultValue != null) {
            string = string + this.defaultValue;
        }
        if (this.isTransient()) {
            string = string + " (transient)";
        }
        return string;
    }
}

