/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.cli;

import com.iplanet.ias.admin.servermodel.ServerInstanceManager;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.tools.cli.BaseLifeCycleCommand;
import com.iplanet.ias.tools.cli.framework.CommandException;
import com.iplanet.ias.tools.cli.framework.CommandValidationException;
import com.iplanet.ias.tools.cli.framework.Option;

public class StopDomainCommand
extends BaseLifeCycleCommand {
    private static final String ADMIN_SERV = "adminserv";

    public StopDomainCommand() {
    }

    public StopDomainCommand(String string) {
        this.setName(string);
    }

    public boolean validateOptions() throws CommandValidationException {
        boolean bl = super.validateOptions();
        if (!bl) {
            return bl;
        }
        if (this.isLocal()) {
            return true;
        }
        if (this.findOption("host") == null || this.findOption("port") == null || this.findOption("user") == null) {
            String string = null;
            Option option = this.findOption("host");
            string = this.findOption("host") == null ? "host" : (this.findOption("port") == null ? "port" : "user");
            throw new CommandValidationException(this.getLocalizedString("RequiredOptionsNotProvided", new Object[]{string}));
        }
        if (!this.isPasswordProvided()) {
            if (!this.isInteractive()) {
                throw new CommandValidationException(this.getLocalizedString("RequiredOptionsNotProvided", new Object[]{"password"}));
            }
            this.initPasswordOption();
        }
        return bl;
    }

    public void runCommand() throws CommandException, CommandValidationException {
        if (!this.validateOptions()) {
            return;
        }
        boolean bl = this.shutdownAdmin();
        String string = "";
        if (this.isLocal()) {
            try {
                string = this.getDomain();
                boolean bl2 = this.stopDomain(string, bl);
                if (!bl2) {
                    throw new CommandException(this.getLocalizedString("CouldNotStopDomainInstances", new Object[]{string}));
                }
                this.printMessage(this.getLocalizedString("DomainStopped", new Object[]{string}));
                Debug.println(this.getClass().getName() + " : Command executed");
            }
            catch (Exception exception) {
                Debug.printStackTrace(exception);
                this.printMessage(this.getLocalizedString("CannotStopDomain"));
                throw new CommandException(exception.getLocalizedMessage());
            }
        }
        ServerInstanceManager serverInstanceManager = this.getServerInstanceManager();
        try {
            serverInstanceManager.stopDomain(bl);
            this.printMessage(this.getLocalizedString("DomainStoppedRemotely"));
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            this.printMessage(this.getLocalizedString("CannotStopDomainRemotely"));
            throw new CommandException(exception.getLocalizedMessage());
        }
    }

    private boolean shutdownAdmin() throws CommandValidationException {
        boolean bl = true;
        Option option = this.findOption(ADMIN_SERV);
        if (option != null) {
            String string = option.getValue();
            if (string.equalsIgnoreCase("true")) {
                bl = true;
            } else if (string.equalsIgnoreCase("false")) {
                bl = false;
            } else {
                throw new CommandValidationException(this.getLocalizedString("InvalidOptionValue") + ": " + option.getName().toLowerCase());
            }
        }
        return bl;
    }
}

