/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.cli;

import com.iplanet.ias.admin.servermodel.AppServerInstance;
import com.iplanet.ias.admin.servermodel.Controllable;
import com.iplanet.ias.admin.servermodel.ServerInstanceManager;
import com.iplanet.ias.admin.servermodel.beans.HttpServiceComponentBean;
import com.iplanet.ias.admin.servermodel.beans.ServerComponent;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.tools.cli.BaseOtherCommand;
import com.iplanet.ias.tools.cli.framework.CommandException;
import com.iplanet.ias.tools.cli.framework.CommandValidationException;
import com.iplanet.ias.tools.cli.framework.Operand;
import com.iplanet.ias.tools.cli.framework.Option;
import javax.management.Attribute;
import javax.management.AttributeList;

public class CreateHttpListenerCommand
extends BaseOtherCommand {
    private static final String LISTENER_ADDRESS = "address";
    private static final String LISTENER_PORT = "listenerport";
    private static final String LISTENER_DEFAULTVS = "defaultvs";
    private static final String LISTENER_SERVER_NAME = "servername";
    private static final String FAMILY = "family";
    private static final String ACCEPTOR_THREADS = "acceptorthreads";
    private static final String BLOCKING_ENABLED = "blockingenabled";
    private static final String SECURITY_ENABLED = "securityenabled";
    private static final String ENABLED = "enabled";

    public boolean validateOptions() throws CommandValidationException {
        return super.validateOptions();
    }

    public void runCommand() throws CommandException, CommandValidationException {
        Object object;
        Controllable controllable;
        HttpServiceComponentBean httpServiceComponentBean = null;
        String string = null;
        AttributeList attributeList = null;
        if (!this.validateOptions()) {
            return;
        }
        try {
            controllable = this.getServerInstanceManager();
            string = ((Operand)this.getOperands().get(0)).getName();
            object = this.getAddressOption();
            int n = this.getPortOption();
            String string2 = this.getDefalutVSOption();
            String string3 = this.getServerNameOption();
            attributeList = this.getAttributeList();
            AppServerInstance appServerInstance = ((ServerInstanceManager)controllable).getServerInstance(this.getInstanceOption());
            httpServiceComponentBean = appServerInstance.getHttpService();
            httpServiceComponentBean.createHttpListener(string, (String)object, n, string2, string3);
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            this.printError(this.getLocalizedString("CannotCreateHttpListener"));
            throw new CommandException(exception.getLocalizedMessage());
        }
        this.printMessage(this.getLocalizedString("CreatedHttpListener", new Object[]{string}));
        try {
            if (attributeList != null && !attributeList.isEmpty()) {
                controllable = httpServiceComponentBean.getHttpListener(string);
                object = ((ServerComponent)controllable).setAttributes(attributeList);
                this.validateAttributeList(attributeList, (AttributeList)object);
            }
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            this.printError(this.getLocalizedString("UseDefaultAttribute"));
            throw new CommandException(exception.getLocalizedMessage());
        }
        Debug.println(this.getClass().getName() + " : Command executed");
    }

    private AttributeList getAttributeList() throws CommandValidationException {
        Object object;
        AttributeList attributeList = new AttributeList();
        if (this.findOption(FAMILY) != null) {
            object = this.getOptionValue(FAMILY);
            if (!(((String)object).equals("inet") || ((String)object).equals("inet6") || ((String)object).equals("nca"))) {
                throw new CommandValidationException(this.getLocalizedString("InvalidFamilyValue"));
            }
            Attribute attribute = new Attribute(FAMILY, object);
            attributeList.add(attribute);
        }
        if (this.findOption(ACCEPTOR_THREADS) != null) {
            object = new Attribute("acceptorThreads", this.getIntegerOptionValue(ACCEPTOR_THREADS));
            attributeList.add((Attribute)object);
        }
        if (this.findOption(BLOCKING_ENABLED) != null) {
            object = new Attribute("blockingEnabled", this.getBooleanOptionValue(BLOCKING_ENABLED));
            attributeList.add((Attribute)object);
        }
        if (this.findOption(SECURITY_ENABLED) != null) {
            object = new Attribute("securityEnabled", this.getBooleanOptionValue(SECURITY_ENABLED));
            attributeList.add((Attribute)object);
        }
        if (this.findOption(ENABLED) != null) {
            object = new Attribute(ENABLED, this.getBooleanOptionValue(ENABLED));
            attributeList.add((Attribute)object);
        }
        return attributeList;
    }

    private String getAddressOption() {
        Option option = this.findOption(LISTENER_ADDRESS);
        String string = null;
        if (option != null) {
            string = option.getValue();
        }
        return string;
    }

    private String getDefalutVSOption() {
        Option option = this.findOption(LISTENER_DEFAULTVS);
        String string = null;
        if (option != null) {
            string = option.getValue();
        }
        return string;
    }

    private String getServerNameOption() {
        Option option = this.findOption(LISTENER_SERVER_NAME);
        String string = null;
        if (option != null) {
            string = option.getValue();
        }
        return string;
    }

    private int getPortOption() throws CommandValidationException {
        String string = "";
        Option option = this.findOption(LISTENER_PORT);
        if (option == null) {
            throw new CommandValidationException(this.getLocalizedString("PortOptionNotSpecified"));
        }
        string = option.getValue();
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            throw new CommandValidationException(this.getLocalizedString("InvalidPortNumber"));
        }
        return n;
    }
}

