/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.servermodel.controllers;

import com.iplanet.ias.admin.common.ObjectNames;
import com.iplanet.ias.admin.common.exception.AFException;
import com.iplanet.ias.admin.servermodel.beans.DeployedWebModuleComponentBean;
import com.iplanet.ias.admin.servermodel.beans.VirtualServer;
import com.iplanet.ias.admin.servermodel.beans.VirtualServerClass;
import com.iplanet.ias.admin.servermodel.context.ContextHolder;
import com.iplanet.ias.admin.servermodel.controllers.Controller;
import com.iplanet.ias.admin.servermodel.controllers.SOMRequestDispatcher;
import com.iplanet.ias.admin.servermodel.util.ServerModelIterator;
import com.iplanet.ias.admin.util.ArgChecker;
import com.iplanet.ias.admin.util.Assert;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.admin.util.StringValidator;
import java.util.Vector;
import javax.management.ObjectName;

public class VirtualServerClassController
implements Controller {
    private static final String CREATE_VIRTUAL_SERVER = "createVirtualServer";
    private static final String DELETE_VIRTUAL_SERVER = "deleteVirtualServer";
    private static final String LIST_VIRTUAL_SERVERS = "listVirtualServers";
    private static final String CREATE_HTTP_QOS = "createHttpQos";
    private static final String DELETE_HTTP_QOS = "deleteHttpQos";
    private static final String IS_HTTP_QOS_CREATED = "isHttpQosCreated";
    private VirtualServerClass component;

    public VirtualServerClassController(VirtualServerClass virtualServerClass) {
        this.component = virtualServerClass;
    }

    public void createVirtualServer(String string, String string2, String string3, String string4) throws AFException {
        ArgChecker.checkValid(string, "id", StringValidator.getInstance());
        ArgChecker.checkValid(string2, "hosts");
        ArgChecker.checkValid(string3, "mime");
        String[] stringArray = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.Boolean", "java.lang.String", "java.lang.String"};
        Object[] objectArray = new Object[]{string, string4, null, null, string2, string3, null, null, null, null, null};
        this.invoke(CREATE_VIRTUAL_SERVER, objectArray, stringArray);
    }

    public void removeVirtualServer(String string) throws AFException {
        ArgChecker.checkValid(string, "id", StringValidator.getInstance());
        this.delWebModuleRef(string);
        String[] stringArray = new String[]{"java.lang.String"};
        Object[] objectArray = new Object[]{string};
        this.invoke(DELETE_VIRTUAL_SERVER, objectArray, stringArray);
    }

    private void delWebModuleRef(String string) throws AFException {
        try {
            String string2;
            DeployedWebModuleComponentBean deployedWebModuleComponentBean;
            VirtualServer virtualServer = this.component.getVirtualServer(string);
            String string3 = (String)virtualServer.getAttribute("defaultWebModule");
            if (string3 != null && string3.length() > 0 && (deployedWebModuleComponentBean = this.getWebModule(string3)) != null && (string2 = (String)deployedWebModuleComponentBean.getAttribute("virtualServers")) != null && string2.length() > 0 && string2.indexOf(string) != -1) {
                String string4 = string2.substring(0, string2.indexOf(string));
                String string5 = string2.substring(string2.indexOf(string) + string.length());
                if (string4.length() > 0 && string5.length() > 0) {
                    string4 = string4.substring(0, string4.length() - 1);
                } else if (string4.length() > 0 && string5.length() == 0) {
                    string4 = string4.substring(0, string4.length() - 1);
                } else if (string4.length() == 0 && string5.length() > 0) {
                    string5 = string5.substring(1);
                }
                String string6 = string4 + string5;
                deployedWebModuleComponentBean.setAttribute("virtualServers", string6);
            }
        }
        catch (Exception exception) {
            if (exception instanceof AFException) {
                throw (AFException)exception;
            }
            throw new AFException(exception.getLocalizedMessage());
        }
    }

    private DeployedWebModuleComponentBean getWebModule(String string) {
        ArgChecker.checkValid(string, "moduleName", StringValidator.getInstance());
        ObjectName objectName = ObjectNames.getWebModuleObjectName(this.component.getInstanceName(), string);
        Assert.assertit(objectName != null, "null value returned");
        DeployedWebModuleComponentBean deployedWebModuleComponentBean = new DeployedWebModuleComponentBean(objectName.toString(), string, true);
        deployedWebModuleComponentBean.setContextHolder(this.component.getContextHolder());
        return deployedWebModuleComponentBean;
    }

    public ServerModelIterator getVirtualServers() throws AFException {
        Vector<VirtualServer> vector = new Vector<VirtualServer>();
        String[] stringArray = (String[])this.invoke(LIST_VIRTUAL_SERVERS, null, null);
        if (stringArray != null && stringArray.length > 0) {
            String string = this.component.getInstanceName();
            String string2 = this.component.getClassId();
            Assert.assertit(string != null, "null value returned");
            int n = 0;
            while (n < stringArray.length) {
                ObjectName objectName = ObjectNames.getVirtualServerObjectName(string, string2, stringArray[n]);
                Assert.assertit(objectName != null, "null value returned");
                Debug.println("VirtualServerClassController.getVirtualServers: virtual server mbean = " + objectName);
                VirtualServer virtualServer = new VirtualServer(objectName.toString(), stringArray[n]);
                virtualServer.setContextHolder(this.component.getContextHolder());
                vector.add(virtualServer);
                ++n;
            }
        }
        return new ServerModelIterator(vector);
    }

    public boolean isHttpQosCreated() throws AFException {
        Boolean bl = (Boolean)this.invoke(IS_HTTP_QOS_CREATED, null, null);
        Assert.assertit(bl != null, "null value returned");
        return bl;
    }

    public void createHttpQos() throws AFException {
        String[] stringArray = new String[]{"java.lang.String", "java.lang.Boolean", "java.lang.String", "java.lang.Boolean"};
        Object[] objectArray = new Object[]{null, null, null, null};
        this.invoke(CREATE_HTTP_QOS, objectArray, stringArray);
    }

    public void removeHttpQos() throws AFException {
        this.invoke(DELETE_HTTP_QOS, null, null);
    }

    private Object invoke(String string, Object[] objectArray, String[] stringArray) throws AFException {
        try {
            ContextHolder contextHolder = this.component.getContextHolder();
            ObjectName objectName = new ObjectName(this.component.getIdentifier());
            SOMRequestDispatcher sOMRequestDispatcher = SOMRequestDispatcher.getDispatcher(contextHolder);
            return sOMRequestDispatcher.invoke(objectName, string, objectArray, stringArray);
        }
        catch (Exception exception) {
            if (exception instanceof AFException) {
                throw (AFException)exception;
            }
            throw new AFException(exception.getLocalizedMessage());
        }
    }
}

