/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.servermodel;

import com.iplanet.ias.admin.common.domains.registry.DomainEntry;
import com.iplanet.ias.admin.common.exception.AFException;
import com.iplanet.ias.admin.common.exception.AFTargetNotFoundException;
import com.iplanet.ias.admin.common.exception.AttributeNotFoundException;
import com.iplanet.ias.admin.common.exception.ControlException;
import com.iplanet.ias.admin.common.exception.DeploymentException;
import com.iplanet.ias.admin.common.exception.InstanceAlreadyExistsException;
import com.iplanet.ias.admin.common.exception.NoSuchInstanceException;
import com.iplanet.ias.admin.servermodel.AppServerInstance;
import com.iplanet.ias.admin.servermodel.Controllable;
import com.iplanet.ias.admin.servermodel.context.AdminContext;
import com.iplanet.ias.admin.servermodel.context.AuthenticationContext;
import com.iplanet.ias.admin.servermodel.context.Context;
import com.iplanet.ias.admin.servermodel.context.ContextHolder;
import com.iplanet.ias.admin.servermodel.controllers.AdminController;
import com.iplanet.ias.admin.servermodel.controllers.Controller;
import com.iplanet.ias.admin.servermodel.util.ServerModelIterator;
import com.iplanet.ias.admin.util.ArgChecker;
import com.iplanet.ias.admin.util.HostAndPort;
import com.iplanet.ias.admin.util.StringValidator;
import java.net.MalformedURLException;
import java.net.URL;
import javax.management.AttributeList;

public class ServerInstanceManager
implements Controllable {
    public static final String HTTP = "http";
    private HostAndPort adminHostAndPort;
    private ContextHolder ctxHolder;
    private transient AdminController controller;

    ServerInstanceManager() {
        this.initialize();
        AdminContext adminContext = new AdminContext();
        this.ctxHolder.put(adminContext);
    }

    ServerInstanceManager(HostAndPort hostAndPort) {
        ArgChecker.checkValid(hostAndPort, "adminHostAndPort");
        this.initialize();
        this.adminHostAndPort = hostAndPort;
        AdminContext adminContext = new AdminContext(hostAndPort);
        this.ctxHolder.put(adminContext);
    }

    ServerInstanceManager(HostAndPort hostAndPort, String string, String string2) {
        ArgChecker.checkValid(hostAndPort, "adminHostAndPort");
        ArgChecker.checkValid(string, "user", StringValidator.getInstance());
        ArgChecker.checkValid(string2, "password", StringValidator.getInstance());
        this.initialize();
        this.adminHostAndPort = hostAndPort;
        AdminContext adminContext = new AdminContext(hostAndPort);
        this.ctxHolder.put(adminContext);
        AuthenticationContext authenticationContext = new AuthenticationContext(string, string2);
        this.ctxHolder.put(authenticationContext);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        boolean bl = false;
        if (object instanceof ServerInstanceManager) {
            ServerInstanceManager serverInstanceManager = (ServerInstanceManager)object;
            ContextHolder contextHolder = serverInstanceManager.getContextHolder();
            ContextHolder contextHolder2 = this.getContextHolder();
            AdminContext adminContext = contextHolder2.getAdminContext();
            AdminContext adminContext2 = contextHolder.getAdminContext();
            boolean bl2 = adminContext2 != null ? adminContext2.equals(adminContext) : adminContext == null;
            AuthenticationContext authenticationContext = contextHolder2.getAuthenticationContext();
            AuthenticationContext authenticationContext2 = contextHolder.getAuthenticationContext();
            boolean bl3 = authenticationContext != null ? authenticationContext.equals(authenticationContext2) : authenticationContext2 == null;
            bl = bl3 && bl2;
        }
        return bl;
    }

    public Controller getController() {
        return this.controller;
    }

    public synchronized void setContextHolder(ContextHolder contextHolder) {
        ArgChecker.checkValid(contextHolder, "ctxHolder");
        if (contextHolder != null) {
            contextHolder = new ContextHolder();
            Context context = contextHolder.getAdminContext();
            contextHolder.put(context);
            context = contextHolder.getAuthenticationContext();
            contextHolder.put(context);
        }
    }

    public synchronized ContextHolder getContextHolder() {
        return this.ctxHolder;
    }

    public HostAndPort getAdminHostAndPort() {
        return this.adminHostAndPort;
    }

    public String getProtocol() {
        return HTTP;
    }

    public boolean handlesURL(URL uRL) {
        HostAndPort hostAndPort = new HostAndPort(uRL.getHost(), uRL.getPort());
        return this.adminHostAndPort.equals(hostAndPort);
    }

    public boolean handlesURL(String string) throws MalformedURLException {
        return this.handlesURL(new URL(string));
    }

    public AppServerInstance getServerInstance(String string) throws AFTargetNotFoundException {
        return this.controller.getServerInstance(string);
    }

    public ServerModelIterator getAllServerInstances() {
        return this.controller.getAllServerInstances();
    }

    public AppServerInstance createServerInstance(HostAndPort hostAndPort, String string) throws InstanceAlreadyExistsException, ControlException {
        return this.createServerInstance(hostAndPort, string, null);
    }

    public AppServerInstance createServerInstance(HostAndPort hostAndPort, String string, String string2) throws InstanceAlreadyExistsException, ControlException {
        return this.controller.createServerInstance(hostAndPort, string, string2);
    }

    public AppServerInstance createServerInstance(HostAndPort hostAndPort, String string, String string2, String string3, String string4, int n, String string5, String string6) throws InstanceAlreadyExistsException, ControlException {
        return this.controller.createServerInstance(hostAndPort, string, string2, string3, string4, n, string5, string6);
    }

    public boolean deleteServerInstance(String string) throws NoSuchInstanceException, ControlException {
        return this.controller.deleteServerInstance(string);
    }

    public boolean deleteServerInstance(AppServerInstance appServerInstance) throws NoSuchInstanceException, ControlException {
        return this.deleteServerInstance(appServerInstance.getName());
    }

    public AttributeList getGenericAttributes(String[] stringArray) throws AFTargetNotFoundException, AttributeNotFoundException {
        return this.controller.getGenericAttributes(stringArray);
    }

    public AttributeList getGenericAttributeDefaultValues(String string, String string2, String[] stringArray) throws AFTargetNotFoundException {
        return this.controller.getGenericAttributeDefaultValues(string, string2, stringArray);
    }

    public String[] listGenericDottedNameContinuiations(String string) throws AFTargetNotFoundException {
        return this.controller.listGenericDottedNameContinuiations(string);
    }

    public AttributeList setGenericAttributes(AttributeList attributeList) throws AFTargetNotFoundException {
        return this.controller.setGenericAttributes(attributeList);
    }

    public String[] listMonitorableComponents(String string) throws AFException {
        return this.controller.listMonitorableComponents(string);
    }

    public AttributeList getMonitorAttributes(String[] stringArray) throws AFException {
        return this.controller.getMonitorAttributes(stringArray);
    }

    public AttributeList setMonitorAttributes(AttributeList attributeList) throws AFException {
        return this.controller.setMonitorAttributes(attributeList);
    }

    public AppServerInstance getDefaultServerInstance() {
        throw new UnsupportedOperationException("To be implemented");
    }

    public void setDefaultServerInstance(String string) {
        throw new UnsupportedOperationException("To be implemented");
    }

    public void setDefaultServerInstance(AppServerInstance appServerInstance) {
        throw new UnsupportedOperationException("To be implemented");
    }

    public String getVersion() throws AFException {
        return this.controller.getVersion();
    }

    public String getFullVersion() throws AFException {
        return this.controller.getFullVersion();
    }

    public void stopServer() throws AFException {
        this.controller.stopServer();
    }

    public String uploadFile(String string) throws Exception {
        return this.controller.uploadFile(string);
    }

    public void deployApplication(String string, AppServerInstance[] appServerInstanceArray) throws DeploymentException {
        throw new UnsupportedOperationException("To be implemented");
    }

    public AppServerInstance getAdminInstance() throws AFException {
        return this.controller.getAdminInstance();
    }

    public void setAuthenticationContext(String string, String string2) {
        AuthenticationContext authenticationContext = new AuthenticationContext(string, string2);
        this.ctxHolder.put(authenticationContext);
    }

    private void initialize() {
        this.controller = new AdminController(this);
        this.ctxHolder = new ContextHolder();
    }

    public DomainEntry[] listDomains() throws AFException {
        return this.controller.listDomains();
    }

    public void stopDomain(boolean bl) throws AFException {
        this.controller.stopDomain(bl);
    }

    public String getLicenseInfo() throws AFException {
        String string = this.controller.getLicenseInfo();
        return string;
    }
}

