/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.common.domains.registry;

import com.iplanet.ias.admin.common.domains.registry.AlreadyRegisteredException;
import com.iplanet.ias.admin.common.domains.registry.DomainEntry;
import com.iplanet.ias.admin.common.domains.registry.DomainRegistryException;
import com.iplanet.ias.admin.common.domains.registry.DomainRegistryI;
import com.iplanet.ias.admin.common.domains.registry.InvalidRootException;
import com.iplanet.ias.admin.common.domains.registry.UnregisteredDomainException;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.TreeMap;

class Registry
implements Serializable,
Cloneable,
DomainRegistryI {
    TreeMap roots = new TreeMap();
    HashMap entries = new HashMap();

    Registry() {
    }

    public boolean isRegistered(String string) {
        return this.roots.containsKey(string);
    }

    public void registerDomain(DomainEntry domainEntry) throws DomainRegistryException {
        if (this.isRegistered(domainEntry.getName())) {
            throw new AlreadyRegisteredException(domainEntry.getName());
        }
        if (this.containsRoot(domainEntry.getRoot())) {
            throw new InvalidRootException("The root \"" + domainEntry.getRoot() + "\" is already registered");
        }
        this.roots.put(domainEntry.getName(), domainEntry.getRoot());
        this.entries.put(domainEntry.getName(), domainEntry);
    }

    public void unregisterDomain(String string) throws DomainRegistryException {
        if (!this.isRegistered(string)) {
            throw new UnregisteredDomainException(string);
        }
        this.delete(string);
    }

    public void unregisterDomain(DomainEntry domainEntry) throws DomainRegistryException {
        this.unregisterDomain(domainEntry.getName());
    }

    public void reregisterDomain(DomainEntry domainEntry) throws DomainRegistryException {
        if (this.isRegistered(domainEntry.getName())) {
            if (!this.roots.get(domainEntry.getName()).equals(domainEntry.getRoot())) {
                throw new InvalidRootException("The given root (" + domainEntry.getRoot() + ") of domain " + domainEntry.getName() + " doesn't match the already registered root for this domain");
            }
        } else if (this.containsRoot(domainEntry.getRoot())) {
            throw new InvalidRootException("The given root (" + domainEntry.getRoot() + ") of domain " + domainEntry.getName() + " is already registered with a different domain");
        }
        this.entries.put(domainEntry.getName(), domainEntry);
    }

    public Iterator iterator() throws DomainRegistryException {
        return new RegistryIterator(this);
    }

    public boolean containsDomain(DomainEntry domainEntry) throws DomainRegistryException {
        return this.entries.values().contains(domainEntry);
    }

    public DomainEntry getDomain(String string) throws DomainRegistryException {
        return (DomainEntry)this.entries.get(string);
    }

    public int size() {
        return this.roots.size();
    }

    private boolean containsRoot(File file) {
        return this.roots.containsValue(file);
    }

    private void delete(String string) {
        this.roots.remove(string);
        this.entries.remove(string);
    }

    protected Object clone() {
        try {
            Registry registry = (Registry)super.clone();
            registry.roots = (TreeMap)this.roots.clone();
            registry.entries = (HashMap)this.entries.clone();
            return registry;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    class RegistryIterator
    implements Iterator {
        Registry registry;
        Iterator iterator;

        RegistryIterator(Registry registry2) {
            this.registry = (Registry)registry2.clone();
            this.iterator = this.registry.roots.keySet().iterator();
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() throws NoSuchElementException {
            return Registry.this.entries.get((String)this.iterator.next());
        }

        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }
}

