/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.server.gui.jato;

import com.iplanet.ias.admin.common.constant.ConfigAttributeName;
import com.iplanet.ias.admin.server.gui.jato.IASPropertySheetViewBean;
import com.iplanet.ias.admin.servermodel.beans.ServerComponent;
import com.iplanet.jato.RequestContext;
import java.io.File;
import java.util.StringTokenizer;

public class JVMPathSettingsViewBean
extends IASPropertySheetViewBean
implements ConfigAttributeName.JVM {
    private static String[] name = new String[]{"ClassPathSuffix", "NativeLibraryPathPrefix", "NativeLibraryPathSuffix", "EnvClassPathIgnored"};
    private static String[] configName = new String[]{"classpathsuffix", "libpathprefix", "libpathsuffix", "envpathignore"};
    private static short[] type = new short[]{1, 1, 1, 3};
    public static final String PAGE_NAME = "JVMPathSettings";

    public JVMPathSettingsViewBean(RequestContext requestContext) {
        super(requestContext, PAGE_NAME);
    }

    public String getDefaultURL() {
        return "JVMPathSettings.jsp";
    }

    public ServerComponent getServerComponent() {
        return this.getInstance().getJVMComponent();
    }

    protected String[] getConfigNames() {
        return configName;
    }

    protected String getPageName() {
        return PAGE_NAME;
    }

    protected String[] getDisplayNames() {
        return name;
    }

    protected short[] getTypes() {
        return type;
    }

    public void setDisplayFieldValue(String string, Object object) {
        if (this.isPathField(string) && object instanceof String) {
            super.setDisplayFieldValue(string, (Object)this.breakClassPath((String)object));
        } else {
            super.setDisplayFieldValue(string, object);
        }
    }

    public Object getDisplayFieldValue(String string) {
        Object object = super.getDisplayFieldValue(string);
        if (this.isPathField(string)) {
            return this.joinClassPath((String)super.getDisplayFieldValue(string));
        }
        return super.getDisplayFieldValue(string);
    }

    private boolean isPathField(String string) {
        return string.equals("ClassPathSuffix") || string.equals("NativeLibraryPathPrefix") || string.equals("NativeLibraryPathSuffix");
    }

    private String breakClassPath(String string) {
        if (string == null) {
            return string;
        }
        String string2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            string2 = string2 == null ? new String(stringTokenizer.nextToken()) + '\n' : string2 + stringTokenizer.nextToken() + '\n';
        }
        return string2;
    }

    private String joinClassPath(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        String string2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\r");
        while (stringTokenizer.hasMoreTokens()) {
            string2 = string2 == null ? new String(stringTokenizer.nextToken()).trim() + File.pathSeparator : string2 + stringTokenizer.nextToken().trim() + File.pathSeparator;
        }
        if (string2 == null) {
            return string;
        }
        if (string2.endsWith(File.pathSeparator)) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }
}

