/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.util;

import java.io.CharConversionException;
import org.mozilla.jss.util.Assert;
import org.mozilla.jss.util.Debug;

public class UTF8Converter {
    public static byte[] UnicodeToUTF8(char[] cArray) throws CharConversionException {
        return UTF8Converter.UnicodeToUTF8(cArray, false);
    }

    protected static byte[] UnicodeToUTF8(char[] cArray, boolean bl) throws CharConversionException {
        byte[] byArray;
        int n;
        char c;
        block28: {
            byte[] byArray2 = null;
            byte[] byArray3 = null;
            boolean bl2 = true;
            boolean bl3 = false;
            Assert.assert(cArray != null);
            if (cArray == null) {
                return null;
            }
            try {
                int n2 = cArray.length * 3;
                if (bl) {
                    ++n2;
                }
                byArray2 = new byte[n2];
                int n3 = 0;
                int n4 = 0;
                while (n3 < cArray.length) {
                    c = cArray[n3];
                    if (c >= '\ud800' && c <= '\udbff') {
                        n = c - 55296 << 10;
                        if (n3 == cArray.length - 1) {
                            throw new CharConversionException();
                        }
                        if ((c = cArray[++n3]) < '\udc00' || c > '\udfff') {
                            throw new CharConversionException();
                        }
                        n |= c - 56320;
                        n += 65536;
                    } else {
                        if (c >= '\udc00' && c <= '\udfff') {
                            bl3 = true;
                            throw new CharConversionException();
                        }
                        n = cArray[n3];
                    }
                    if (n < 128) {
                        byArray2[n4++] = (byte)n;
                    } else if (n < 2048) {
                        byArray2[n4++] = (byte)(0xC0 | n >> 6);
                        byArray2[n4++] = (byte)(0x80 | n & 0x3F);
                    } else if (n < 65536) {
                        byArray2[n4++] = (byte)(0xE0 | n >> 12);
                        byArray2[n4++] = (byte)(0x80 | n >> 6 & 0x3F);
                        byArray2[n4++] = (byte)(0x80 | n & 0x3F);
                    } else if (n < 0x200000) {
                        byArray2[n4++] = (byte)(0xF0 | n >> 18);
                        byArray2[n4++] = (byte)(0x80 | n >> 12 & 0x3F);
                        byArray2[n4++] = (byte)(0x80 | n >> 6 & 0x3F);
                        byArray2[n4++] = (byte)(0x80 | n & 0x3F);
                    } else if (n < 0x200000) {
                        byArray2[n4++] = (byte)(0xF8 | n >> 24);
                        byArray2[n4++] = (byte)(0x80 | n >> 18 & 0x3F);
                        byArray2[n4++] = (byte)(0x80 | n >> 12 & 0x3F);
                        byArray2[n4++] = (byte)(0x80 | n >> 6 & 0x3F);
                        byArray2[n4++] = (byte)(0x80 | n & 0x3F);
                    } else {
                        byArray2[n4++] = (byte)(0xFC | n >> 30);
                        byArray2[n4++] = (byte)(0x80 | n >> 24 & 0x3F);
                        byArray2[n4++] = (byte)(0x80 | n >> 18 & 0x3F);
                        byArray2[n4++] = (byte)(0x80 | n >> 12 & 0x3F);
                        byArray2[n4++] = (byte)(0x80 | n >> 6 & 0x3F);
                        byArray2[n4++] = (byte)(0x80 | n & 0x3F);
                    }
                    ++n3;
                }
                if (bl) {
                    byArray2[n4++] = 0;
                }
                try {
                    byArray3 = new byte[n4];
                    int n5 = 0;
                    while (n5 < n4) {
                        byArray3[n5] = byArray2[n5];
                        byArray2[n5] = 0;
                        ++n5;
                    }
                    byArray2 = byArray3;
                    byArray3 = null;
                }
                finally {
                    Object var15_14 = null;
                    if (byArray3 != null) {
                        UTF8Converter.wipeBytes(byArray3);
                    }
                }
                bl2 = false;
                byArray = byArray2;
                Object var13_18 = null;
                if (!bl2 || byArray2 == null) break block28;
            }
            catch (Throwable throwable) {
                Object var13_19 = null;
                if (bl2 && byArray2 != null) {
                    UTF8Converter.wipeBytes(byArray2);
                    byArray2 = null;
                }
                boolean bl4 = false;
                boolean bl5 = false;
                throw throwable;
            }
            UTF8Converter.wipeBytes(byArray2);
            byArray2 = null;
        }
        n = 0;
        c = '\u0000';
        return byArray;
    }

    public static byte[] UnicodeToUTF8NullTerm(char[] cArray) throws CharConversionException {
        return UTF8Converter.UnicodeToUTF8(cArray, true);
    }

    public static void main(String[] stringArray) {
        Debug.setLevel(10);
        System.out.println("***WARNING***");
        System.out.println("Debugging mode is disabled. This code only checks itself in debug mode. The test is almost worthless in optimized mode.");
        try {
            try {
                System.out.println("ASCII Test:");
                char[] cArray = new char[128];
                int n = 0;
                while (n < 128) {
                    cArray[n] = (char)n;
                    ++n;
                }
                byte[] byArray = UTF8Converter.UnicodeToUTF8(cArray);
                n = 0;
                while (n < 128) {
                    int n2 = n;
                    while (n2 < 128 && n2 < n + 20) {
                        System.out.print(String.valueOf((int)cArray[n2]) + " ");
                        ++n2;
                    }
                    System.out.println();
                    n2 = n;
                    while (n2 < 128 && n2 < n + 20) {
                        System.out.print(String.valueOf(byArray[n2]) + " ");
                        ++n2;
                    }
                    System.out.println("\n");
                    n = n2;
                }
                System.out.println("UCS2 test:");
                char[] cArray2 = new char[10];
                cArray2[1] = 127;
                cArray2[2] = 128;
                cArray2[3] = 1024;
                cArray2[4] = 2047;
                cArray2[5] = 2048;
                cArray2[6] = 12647;
                cArray2[7] = 55295;
                cArray2[8] = 57344;
                cArray2[9] = 65535;
                cArray = cArray2;
                byArray = UTF8Converter.UnicodeToUTF8(cArray);
                n = 0;
                while (n < 10) {
                    System.out.print(String.valueOf(Integer.toHexString(cArray[n])) + " ");
                    ++n;
                }
                System.out.println();
                n = 0;
                while (n < byArray.length) {
                    System.out.print(String.valueOf(Integer.toHexString(byArray[n])) + " ");
                    ++n;
                }
                System.out.println();
                System.out.println("Maximum buffer size test:");
                cArray = new char[]{'\uffff', '\uffff', '\uffff', '\uffff'};
                byArray = UTF8Converter.UnicodeToUTF8(cArray);
                Assert.assert(byArray.length == 12);
                System.out.println("8 bytes of unicode --> " + byArray.length + " bytes of utf8\n");
                System.out.println("Empty input test:");
                cArray = new char[]{};
                byArray = UTF8Converter.UnicodeToUTF8(cArray);
                Assert.assert(byArray != null);
                Assert.assert(byArray.length == 0);
                System.out.println("given 0 bytes Unicode, produces 0 length utf8\n");
                System.out.println("UCS4 Test:");
                cArray = new char[]{'\ud800', '\udc00', '\uda85', '\ude47', '\udbff', '\udfff'};
                byArray = UTF8Converter.UnicodeToUTF8(cArray);
                n = 0;
                while (n < 6) {
                    System.out.print(String.valueOf(Integer.toHexString(cArray[n])) + " ");
                    ++n;
                }
                System.out.println();
                n = 0;
                while (n < byArray.length) {
                    System.out.print(String.valueOf(Integer.toHexString(byArray[n])) + " ");
                    ++n;
                }
                System.out.println("\n");
                System.out.println("high half at end of input:");
                try {
                    cArray = new char[]{'\ud800'};
                    byArray = UTF8Converter.UnicodeToUTF8(cArray);
                    Assert.notReached("should have failed on bad UCS4");
                }
                catch (CharConversionException charConversionException) {
                    System.out.println("Correctly caught bad UCS4\n");
                }
                System.out.println("high half with something other than low half:");
                try {
                    cArray = new char[]{'\ud800', '\u007f'};
                    byArray = UTF8Converter.UnicodeToUTF8(cArray);
                    Assert.notReached("should have failed on bad UCS4");
                }
                catch (CharConversionException charConversionException) {
                    System.out.println("Correctly caught bad UCS4\n");
                }
                System.out.println("orphaned low half test:");
                try {
                    cArray = new char[]{'2', '\udc01', '3'};
                    byArray = UTF8Converter.UnicodeToUTF8(cArray);
                    Assert.notReached("should have failed on bad UCS4");
                }
                catch (CharConversionException charConversionException) {
                    System.out.println("Correctly caught bad UCS4\n");
                }
                System.out.println("null-terminating:");
                cArray = new char[]{'f', 'o', 'o', 'b', 'a', 'r'};
                byArray = UTF8Converter.UnicodeToUTF8NullTerm(cArray);
                n = 0;
                while (n < cArray.length) {
                    System.out.print(String.valueOf(cArray[n]) + " ");
                    ++n;
                }
                System.out.println();
                n = 0;
                while (n < byArray.length) {
                    System.out.print(String.valueOf(byArray[n]) + " ");
                    ++n;
                }
                System.out.println("\n");
            }
            catch (CharConversionException charConversionException) {
                System.out.println("Error converting Unicode " + charConversionException);
            }
            Object var6_6 = null;
            System.out.println("***WARNING***");
            System.out.println("Debugging mode is disabled. This code only checks itself in debug mode. The test is almost worthless in optimized mode.");
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            System.out.println("***WARNING***");
            System.out.println("Debugging mode is disabled. This code only checks itself in debug mode. The test is almost worthless in optimized mode.");
            throw throwable;
        }
    }

    public static void wipeBytes(byte[] byArray) {
        Assert.assert(byArray != null);
        if (byArray == null) {
            return;
        }
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = 0;
            ++n;
        }
    }
}

