/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.cmmf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.ENUMERATED;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.asn1.UTF8String;

public class RevRequest
implements ASN1Value {
    public static final ENUMERATED unspecified = new ENUMERATED(0L);
    public static final ENUMERATED keyCompromise = new ENUMERATED(1L);
    public static final ENUMERATED cACompromise = new ENUMERATED(2L);
    public static final ENUMERATED affiliationChanged = new ENUMERATED(3L);
    public static final ENUMERATED superseded = new ENUMERATED(4L);
    public static final ENUMERATED cessationOfOperation = new ENUMERATED(5L);
    public static final ENUMERATED certificateHold = new ENUMERATED(6L);
    public static final ENUMERATED removeFromCRL = new ENUMERATED(8L);
    private ANY issuerName;
    private INTEGER serialNumber;
    private ENUMERATED reason;
    private OCTET_STRING passphrase;
    private UTF8String comment;
    private SEQUENCE sequence;
    private static final Tag TAG = SEQUENCE.TAG;

    private RevRequest() {
    }

    public RevRequest(ANY aNY, INTEGER iNTEGER, ENUMERATED eNUMERATED, OCTET_STRING oCTET_STRING, UTF8String uTF8String) {
        if (aNY == null || iNTEGER == null || eNUMERATED == null) {
            throw new IllegalArgumentException("parameter to RevRequest constructor is null");
        }
        this.sequence = new SEQUENCE();
        this.issuerName = aNY;
        this.sequence.addElement(aNY);
        this.serialNumber = iNTEGER;
        this.sequence.addElement(iNTEGER);
        this.reason = eNUMERATED;
        this.sequence.addElement(eNUMERATED);
        this.passphrase = oCTET_STRING;
        this.sequence.addElement(oCTET_STRING);
        this.comment = uTF8String;
        this.sequence.addElement(uTF8String);
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.sequence.encode(outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        this.sequence.encode(tag, outputStream);
    }

    public UTF8String getComment() {
        return this.comment;
    }

    public ANY getIssuerName() {
        return this.issuerName;
    }

    public OCTET_STRING getPassphrase() {
        return this.passphrase;
    }

    public ENUMERATED getReason() {
        return this.reason;
    }

    public INTEGER getSerialNumber() {
        return this.serialNumber;
    }

    public Tag getTag() {
        return TAG;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(ANY.getTemplate());
            this.seqt.addElement(INTEGER.getTemplate());
            this.seqt.addElement(INTEGER.getTemplate());
            this.seqt.addOptionalElement(OCTET_STRING.getTemplate());
            this.seqt.addOptionalElement(UTF8String.getTemplate());
        }

        public ASN1Value decode(InputStream inputStream) throws InvalidBERException, IOException {
            return this.decode(TAG, inputStream);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws InvalidBERException, IOException {
            SEQUENCE sEQUENCE = (SEQUENCE)this.seqt.decode(tag, inputStream);
            return new RevRequest((ANY)sEQUENCE.elementAt(0), (INTEGER)sEQUENCE.elementAt(1), (ENUMERATED)sEQUENCE.elementAt(2), (OCTET_STRING)sEQUENCE.elementAt(3), (UTF8String)sEQUENCE.elementAt(4));
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }
    }
}

